/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.store;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentStoreProvider;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClientSync;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyServerSync;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Property(name="org.apache.sling.installer.configuration.persist", label="Persist configuration", description="Must be always disabled to avoid storing the configuration in the repository", boolValue={false})
@Component(metatype=true, policy=ConfigurationPolicy.REQUIRE)
public class StandbyStoreService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MODE_PRIMARY = "primary";
    private static final String MODE_STANDBY = "standby";
    public static final String MODE_DEFAULT = "primary";
    @Property(options={@PropertyOption(name="primary", value="primary"), @PropertyOption(name="standby", value="standby")}, value={"primary"})
    public static final String MODE = "mode";
    public static final int PORT_DEFAULT = 8023;
    @Property(intValue={8023})
    public static final String PORT = "port";
    public static final String PRIMARY_HOST_DEFAULT = "127.0.0.1";
    @Property(value={"127.0.0.1"})
    public static final String PRIMARY_HOST = "primary.host";
    public static final int INTERVAL_DEFAULT = 5;
    @Property(intValue={5})
    public static final String INTERVAL = "interval";
    public static final String[] ALLOWED_CLIENT_IP_RANGES_DEFAULT = new String[0];
    @Property(cardinality=0x7FFFFFFF)
    public static final String ALLOWED_CLIENT_IP_RANGES = "primary.allowed-client-ip-ranges";
    public static final boolean SECURE_DEFAULT = false;
    @Property(boolValue={false})
    public static final String SECURE = "secure";
    public static final int READ_TIMEOUT_DEFAULT = 60000;
    @Property(intValue={60000})
    public static final String READ_TIMEOUT = "standby.readtimeout";
    public static final boolean AUTO_CLEAN_DEFAULT = false;
    @Property(boolValue={false})
    public static final String AUTO_CLEAN = "standby.autoclean";
    @Reference(policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private SegmentStoreProvider storeProvider = null;
    private Closer closer = Closer.create();

    @Activate
    private void activate(ComponentContext context) {
        SegmentStore segmentStore = this.storeProvider.getSegmentStore();
        if (!(segmentStore instanceof FileStore)) {
            throw new IllegalArgumentException("Unexpected SegmentStore implementation");
        }
        FileStore fileStore = (FileStore)segmentStore;
        String mode = String.valueOf(context.getProperties().get(MODE));
        if ("primary".equals(mode)) {
            this.bootstrapMaster(context, fileStore);
            return;
        }
        if (MODE_STANDBY.equals(mode)) {
            this.bootstrapSlave(context, fileStore);
            return;
        }
        throw new IllegalArgumentException(String.format("Unexpected mode property, got '%s'", mode));
    }

    @Deactivate
    public void deactivate() throws Exception {
        this.closer.close();
    }

    private void bootstrapMaster(ComponentContext context, FileStore fileStore) {
        Dictionary props = context.getProperties();
        int port = PropertiesUtil.toInteger(props.get(PORT), (int)8023);
        String[] ranges = PropertiesUtil.toStringArray(props.get(ALLOWED_CLIENT_IP_RANGES), (String[])ALLOWED_CLIENT_IP_RANGES_DEFAULT);
        boolean secure = PropertiesUtil.toBoolean(props.get(SECURE), (boolean)false);
        StandbyServerSync standbyServerSync = new StandbyServerSync(port, fileStore, ranges, secure);
        this.closer.register((Closeable)standbyServerSync);
        standbyServerSync.start();
        this.log.info("Started primary on port {} with allowed IP ranges {}", (Object)port, (Object)ranges);
    }

    private void bootstrapSlave(ComponentContext context, FileStore fileStore) {
        Dictionary props = context.getProperties();
        int port = PropertiesUtil.toInteger(props.get(PORT), (int)8023);
        long interval = PropertiesUtil.toInteger(props.get(INTERVAL), (int)5);
        String host = PropertiesUtil.toString(props.get(PRIMARY_HOST), (String)PRIMARY_HOST_DEFAULT);
        boolean secure = PropertiesUtil.toBoolean(props.get(SECURE), (boolean)false);
        int readTimeout = PropertiesUtil.toInteger(props.get(READ_TIMEOUT), (int)60000);
        boolean clean = PropertiesUtil.toBoolean(props.get(AUTO_CLEAN), (boolean)false);
        StandbyClientSync standbyClientSync = new StandbyClientSync(host, port, fileStore, secure, readTimeout, clean);
        this.closer.register((Closeable)standbyClientSync);
        Hashtable<String, Constable> dictionary = new Hashtable<String, Constable>();
        ((Dictionary)dictionary).put("scheduler.period", interval);
        ((Dictionary)dictionary).put("scheduler.concurrent", false);
        ServiceRegistration registration = context.getBundleContext().registerService(Runnable.class.getName(), (Object)standbyClientSync, dictionary);
        this.closer.register(StandbyStoreService.asCloseable(registration));
        this.log.info("Started standby on port {} with {}s sync frequency", (Object)port, (Object)interval);
    }

    private static Closeable asCloseable(final ServiceRegistration r) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                r.unregister();
            }
        };
    }

    protected void bindStoreProvider(SegmentStoreProvider segmentStoreProvider) {
        this.storeProvider = segmentStoreProvider;
    }

    protected void unbindStoreProvider(SegmentStoreProvider segmentStoreProvider) {
        if (this.storeProvider == segmentStoreProvider) {
            this.storeProvider = null;
        }
    }
}

