/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.store;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.jackrabbit.oak.segment.standby.jmx.ObservablePartnerMBean;

class CommunicationPartnerMBean
implements ObservablePartnerMBean {
    private final ObjectName mbeanName;
    private final String clientName;
    private String lastRequest;
    private Date lastSeen;
    private String lastSeenTimestamp;
    private String remoteAddress;
    private int remotePort;
    private long segmentsSent;
    private long segmentBytesSent;
    private long binariesSent;
    private long binariesBytesSent;

    CommunicationPartnerMBean(String clientName) throws MalformedObjectNameException {
        this.clientName = clientName;
        this.mbeanName = new ObjectName("org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=\"Client " + clientName + "\"");
    }

    ObjectName getMBeanName() {
        return this.mbeanName;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.clientName;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getLastRequest() {
        return this.lastRequest;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getLastSeenTimestamp() {
        return this.lastSeenTimestamp;
    }

    @Override
    public long getTransferredSegments() {
        return this.segmentsSent;
    }

    @Override
    public long getTransferredSegmentBytes() {
        return this.segmentBytesSent;
    }

    @Override
    public long getTransferredBinaries() {
        return this.binariesSent;
    }

    @Override
    public long getTransferredBinariesBytes() {
        return this.binariesBytesSent;
    }

    void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    Date getLastSeen() {
        return this.lastSeen;
    }

    void setLastSeen(Date lastSeen) {
        this.lastSeen = lastSeen;
        this.lastSeenTimestamp = lastSeen.toString();
    }

    void setLastRequest(String lastRequest) {
        this.lastRequest = lastRequest;
    }

    void onSegmentSent(long bytes) {
        ++this.segmentsSent;
        this.segmentBytesSent += bytes;
    }

    void onBinarySent(long bytes) {
        ++this.binariesSent;
        this.binariesBytesSent += bytes;
    }
}

