/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileStoreUtil {
    private static final Logger log = LoggerFactory.getLogger(FileStoreUtil.class);

    private FileStoreUtil() {
    }

    static Segment readSegmentWithRetry(FileStore store, SegmentId id) {
        for (int i = 0; i < 160; ++i) {
            if (store.containsSegment(id)) {
                return store.readSegment(id);
            }
            try {
                log.trace("Unable to read segment, waiting...");
                TimeUnit.MILLISECONDS.sleep(125L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }
}

