/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarRevisions
implements Revisions,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TarRevisions.class);
    public static final String JOURNAL_FILE_NAME = "journal.log";
    private final Lock journalFileLock = new ReentrantLock();
    @Nonnull
    private final AtomicReference<RecordId> head;
    @Nonnull
    private final File directory;
    private RandomAccessFile journalFile;
    @Nonnull
    private final AtomicReference<RecordId> persistedHead;
    @Nonnull
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    public static final Revisions.Option EXPEDITE_OPTION = new Revisions.Option(){

        public String toString() {
            return "Expedite Option";
        }
    };
    public static final Revisions.Option INFINITY = new TimeOutOption(Long.MAX_VALUE, TimeUnit.DAYS);

    public static Revisions.Option timeout(long time, TimeUnit unit) {
        return new TimeOutOption(time, unit);
    }

    public TarRevisions(@Nonnull File directory) throws IOException {
        this.directory = (File)Preconditions.checkNotNull((Object)directory);
        this.journalFile = new RandomAccessFile(new File(directory, JOURNAL_FILE_NAME), "rw");
        this.journalFile.seek(this.journalFile.length());
        this.head = new AtomicReference<Object>(null);
        this.persistedHead = new AtomicReference<Object>(null);
    }

    synchronized void bind(@Nonnull SegmentStore store, @Nonnull Supplier<RecordId> writeInitialNode) throws IOException {
        if (this.head.get() == null) {
            RecordId persistedId;
            block20: {
                persistedId = null;
                JournalReader journalReader = new JournalReader(new File(this.directory, JOURNAL_FILE_NAME));
                Throwable throwable = null;
                block11: while (true) {
                    try {
                        while (persistedId == null && journalReader.hasNext()) {
                            String entry = (String)journalReader.next();
                            try {
                                RecordId id = RecordId.fromString(store, entry);
                                if (store.containsSegment(id.getSegmentId())) {
                                    persistedId = id;
                                    continue block11;
                                }
                                LOG.warn("Unable to access revision {}, rewinding...", (Object)id);
                                continue block11;
                            }
                            catch (IllegalArgumentException ignore) {
                                LOG.warn("Skipping invalid record id {}", (Object)entry);
                            }
                        }
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (journalReader != null) {
                        if (throwable != null) {
                            try {
                                journalReader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            journalReader.close();
                        }
                    }
                }
            }
            if (persistedId == null) {
                this.head.set((RecordId)writeInitialNode.get());
            } else {
                this.persistedHead.set(persistedId);
                this.head.set(persistedId);
            }
        }
    }

    private void checkBound() {
        Preconditions.checkState((this.head.get() != null ? 1 : 0) != 0, (Object)"Revisions not bound to a store");
    }

    public void flush(@Nonnull Callable<Void> persisted) throws IOException {
        if (this.head.get() == null) {
            return;
        }
        if (this.journalFileLock.tryLock()) {
            try {
                if (this.journalFile == null) {
                    return;
                }
                this.doFlush(persisted);
            }
            finally {
                this.journalFileLock.unlock();
            }
        }
    }

    private void doFlush(Callable<Void> persisted) throws IOException {
        try {
            RecordId before = this.persistedHead.get();
            RecordId after = this.getHead();
            if (!after.equals(before)) {
                persisted.call();
                LOG.debug("TarMK journal update {} -> {}", (Object)before, (Object)after);
                this.journalFile.writeBytes(after.toString10() + " root " + System.currentTimeMillis() + "\n");
                this.journalFile.getChannel().force(false);
                this.persistedHead.set(after);
            }
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    @Nonnull
    public RecordId getHead() {
        this.checkBound();
        return this.head.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setHead(@Nonnull RecordId expected, @Nonnull RecordId head, Revisions.Option ... options) {
        this.checkBound();
        Lock lock = TarRevisions.isExpedited(options) ? this.rwLock.writeLock() : this.rwLock.readLock();
        lock.lock();
        try {
            RecordId id = this.head.get();
            boolean bl = id.equals(expected) && this.head.compareAndSet(id, head);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setHead(@Nonnull Function<RecordId, RecordId> newHead, Revisions.Option ... options) throws InterruptedException {
        this.checkBound();
        TimeOutOption timeout = TarRevisions.getTimeout(options);
        if (this.rwLock.writeLock().tryLock(timeout.time, timeout.unit)) {
            try {
                RecordId after = (RecordId)newHead.apply((Object)this.getHead());
                if (after != null) {
                    this.head.set(after);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        return false;
    }

    private static boolean isExpedited(Revisions.Option[] options) {
        if (options.length == 0) {
            return false;
        }
        if (options.length == 1) {
            return options[0] == EXPEDITE_OPTION;
        }
        throw new IllegalArgumentException("Expected zero or one options, got " + options.length);
    }

    @Nonnull
    private static TimeOutOption getTimeout(@Nonnull Revisions.Option[] options) {
        if (options.length == 0) {
            return TimeOutOption.from(INFINITY);
        }
        if (options.length == 1) {
            return TimeOutOption.from(options[0]);
        }
        throw new IllegalArgumentException("Expected zero or one options, got " + options.length);
    }

    @Override
    public void close() throws IOException {
        this.journalFileLock.lock();
        try {
            if (this.journalFile == null) {
                return;
            }
            this.journalFile.close();
            this.journalFile = null;
        }
        finally {
            this.journalFileLock.unlock();
        }
    }

    private static class TimeOutOption
    implements Revisions.Option {
        private final long time;
        @Nonnull
        private final TimeUnit unit;

        TimeOutOption(long time, @Nonnull TimeUnit unit) {
            this.time = time;
            this.unit = unit;
        }

        @Nonnull
        public static TimeOutOption from(@CheckForNull Revisions.Option option) {
            if (option instanceof TimeOutOption) {
                return (TimeOutOption)option;
            }
            throw new IllegalArgumentException("Invalid option " + option);
        }
    }
}

