/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.compaction;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;

public class SegmentGCOptions {
    public static final boolean PAUSE_DEFAULT = false;
    public static final boolean DISABLE_ESTIMATION_DEFAULT = false;
    public static final int RETRY_COUNT_DEFAULT = 5;
    public static final int FORCE_TIMEOUT_DEFAULT = 60;
    public static final int RETAINED_GENERATIONS_DEFAULT = 2;
    public static final long SIZE_DELTA_ESTIMATION_DEFAULT = 0x40000000L;
    public static final long GC_PROGRESS_LOG_DEFAULT = -1L;
    public static final int MEMORY_THRESHOLD_DEFAULT = 15;
    private boolean paused = false;
    private boolean estimationDisabled = false;
    private int retryCount = 5;
    private int forceTimeout = 60;
    private int retainedGenerations = 2;
    private boolean offline = false;
    private int memoryThreshold = 15;
    private boolean ocBinDeduplication = Boolean.getBoolean("oak.segment.compaction.binaryDeduplication");
    private long ocBinMaxSize = Long.getLong("oak.segment.compaction.binaryDeduplicationMaxSize", 0x6400000L);
    private long gcSizeDeltaEstimation = Long.getLong("oak.segment.compaction.gcSizeDeltaEstimation", 0x40000000L);
    private GCNodeWriteMonitor gcNodeWriteMonitor = GCNodeWriteMonitor.EMPTY;

    public SegmentGCOptions(boolean paused, int retryCount, int forceTimeout) {
        this.paused = paused;
        this.retryCount = retryCount;
        this.forceTimeout = forceTimeout;
    }

    public SegmentGCOptions() {
        this(false, 5, 60);
    }

    public static SegmentGCOptions defaultGCOptions() {
        return new SegmentGCOptions();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public SegmentGCOptions setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public SegmentGCOptions setRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public int getForceTimeout() {
        return this.forceTimeout;
    }

    public SegmentGCOptions setForceTimeout(int timeout) {
        this.forceTimeout = timeout;
        return this;
    }

    public int getRetainedGenerations() {
        return this.retainedGenerations;
    }

    public SegmentGCOptions setRetainedGenerations(int retainedGenerations) {
        Preconditions.checkArgument((retainedGenerations > 1 ? 1 : 0) != 0, (String)"RetainedGenerations must not be below 2. Got %s", (Object[])new Object[]{retainedGenerations});
        this.retainedGenerations = retainedGenerations;
        return this;
    }

    public String toString() {
        if (this.offline) {
            return this.getClass().getSimpleName() + "{offline=" + this.offline + ", retainedGenerations=" + this.retainedGenerations + ", ocBinDeduplication=" + this.ocBinDeduplication + ", ocBinMaxSize=" + this.ocBinMaxSize + "}";
        }
        return this.getClass().getSimpleName() + "{paused=" + this.paused + ", estimationDisabled=" + this.estimationDisabled + ", gcSizeDeltaEstimation=" + this.gcSizeDeltaEstimation + ", retryCount=" + this.retryCount + ", forceTimeout=" + this.forceTimeout + ", retainedGenerations=" + this.retainedGenerations + ", gcSizeDeltaEstimation=" + this.gcSizeDeltaEstimation + "}";
    }

    public static boolean isDiskSpaceSufficient(long repositoryDiskSpace, long availableDiskSpace) {
        return (double)availableDiskSpace > 0.25 * (double)repositoryDiskSpace;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public SegmentGCOptions setOffline() {
        this.offline = true;
        this.retainedGenerations = 1;
        return this;
    }

    public SegmentGCOptions withBinaryDeduplication() {
        this.ocBinDeduplication = true;
        return this;
    }

    public boolean isBinaryDeduplication() {
        return this.ocBinDeduplication;
    }

    public SegmentGCOptions setBinaryDeduplicationMaxSize(long binMaxSize) {
        this.ocBinMaxSize = binMaxSize;
        return this;
    }

    public long getBinaryDeduplicationMaxSize() {
        return this.ocBinMaxSize;
    }

    public long getGcSizeDeltaEstimation() {
        return this.gcSizeDeltaEstimation;
    }

    public SegmentGCOptions setGcSizeDeltaEstimation(long gcSizeDeltaEstimation) {
        this.gcSizeDeltaEstimation = gcSizeDeltaEstimation;
        return this;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public SegmentGCOptions setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
        return this;
    }

    public boolean isEstimationDisabled() {
        return this.estimationDisabled;
    }

    public SegmentGCOptions setEstimationDisabled(boolean disabled) {
        this.estimationDisabled = disabled;
        return this;
    }

    public SegmentGCOptions withGCNodeWriteMonitor(long gcProgressLog) {
        this.gcNodeWriteMonitor = new GCNodeWriteMonitor(gcProgressLog);
        return this;
    }

    public GCNodeWriteMonitor getGCNodeWriteMonitor() {
        return this.gcNodeWriteMonitor;
    }
}

