/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreService;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, name="org.apache.jackrabbit.oak.segment.SegmentNodeStoreFactory", configurationFactory=true, metatype=true, label="Apache Jackrabbit Oak Segment-Tar NodeStore Factory", description="Factory allowing configuration of adjacent instances of NodeStore implementation based on Segment model besides a default SegmentNodeStore in same setup.")
public class SegmentNodeStoreFactory {
    @Property(label="Role", description="As multiple SegmentNodeStores can be configured, this parameter defines the role of 'this' SegmentNodeStore.")
    public static final String ROLE = "role";
    @Property(boolValue={false}, label="Custom BlobStore", description="Boolean value indicating that a custom BlobStore is to be used. By default large binary content would be stored within segment tar files")
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    @Property(boolValue={false}, label="Register JCR descriptors as OSGi services", description="Should only be done for one factory instance")
    public static final String REGISTER_DESCRIPTORS = "registerDescriptors";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private volatile BlobStore blobStore;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private Closer registrations = Closer.create();

    @Activate
    public void activate(ComponentContext context) throws IOException {
        String role = SegmentNodeStoreFactory.property(ROLE, context);
        boolean isSecondaryStoreMode = "secondary".equals(role);
        boolean customBlobStore = Boolean.parseBoolean(SegmentNodeStoreFactory.property(CUSTOM_BLOB_STORE, context)) || isSecondaryStoreMode;
        boolean registerRepositoryDescriptors = Boolean.parseBoolean(SegmentNodeStoreFactory.property(REGISTER_DESCRIPTORS, context));
        this.log.info("activate: SegmentNodeStore '" + role + "' starting.");
        if (this.blobStore == null && customBlobStore) {
            this.log.info("BlobStore use enabled. SegmentNodeStore would be initialized when BlobStore would be available");
            return;
        }
        if (role != null) {
            this.registrations = Closer.create();
            OsgiWhiteboard whiteboard = new OsgiWhiteboard(context.getBundleContext());
            final SegmentNodeStore store = SegmentNodeStoreService.registerSegmentStore(context, this.blobStore, this.statisticsProvider, this.registrations, (Whiteboard)whiteboard, role, registerRepositoryDescriptors);
            if (store != null) {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put(ROLE, role);
                this.registrations.register(SegmentNodeStoreFactory.asCloseable(whiteboard.register(NodeStoreProvider.class, (Object)new NodeStoreProvider(){

                    public NodeStore getNodeStore() {
                        return store;
                    }
                }, props)));
                this.log.info("Registered NodeStoreProvider backed by SegmentNodeStore of type '{}'", (Object)role);
            }
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.registrations != null) {
            IOUtils.closeQuietly((Closeable)this.registrations);
            this.registrations = null;
        }
    }

    private static Closeable asCloseable(final Registration r) {
        return new Closeable(){

            @Override
            public void close() {
                r.unregister();
            }
        };
    }

    static String property(String name, ComponentContext context) {
        return OsgiUtil.lookupConfigurationThenFramework((ComponentContext)context, (String)name);
    }

    protected void bindBlobStore(BlobStore blobStore) {
        this.blobStore = blobStore;
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        if (this.blobStore == blobStore) {
            this.blobStore = null;
        }
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }
}

