/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.http;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.http.Representation;
import org.apache.tika.mime.MediaType;

class JsonRepresentation
implements Representation {
    private final MediaType type;
    private final JsonFactory factory;

    public JsonRepresentation(MediaType type, JsonFactory factory) {
        this.type = type;
        this.factory = factory;
    }

    @Override
    public MediaType getType() {
        return this.type;
    }

    @Override
    public void render(Tree tree, HttpServletResponse response) throws IOException {
        JsonGenerator generator = this.startResponse(response);
        JsonRepresentation.render(tree, generator);
        generator.close();
    }

    @Override
    public void render(PropertyState property, HttpServletResponse response) throws IOException {
        JsonGenerator generator = this.startResponse(response);
        JsonRepresentation.render(property, generator);
        generator.close();
    }

    protected JsonGenerator startResponse(HttpServletResponse response) throws IOException {
        response.setContentType(this.type.toString());
        return this.factory.createJsonGenerator((OutputStream)response.getOutputStream());
    }

    private static void render(Tree tree, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        for (PropertyState property : tree.getProperties()) {
            generator.writeFieldName(property.getName());
            JsonRepresentation.render(property, generator);
        }
        for (Tree child : tree.getChildren()) {
            generator.writeFieldName(child.getName());
            generator.writeStartObject();
            generator.writeEndObject();
        }
        generator.writeEndObject();
    }

    private static void render(PropertyState property, JsonGenerator generator) throws IOException {
        if (property.isArray()) {
            generator.writeStartArray();
            JsonRepresentation.renderValue(property, generator);
            generator.writeEndArray();
        } else {
            JsonRepresentation.renderValue(property, generator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderValue(PropertyState property, JsonGenerator generator) throws IOException {
        int type = property.getType().tag();
        if (type == 6) {
            Iterator i$ = ((Iterable)property.getValue(Type.BOOLEANS)).iterator();
            while (i$.hasNext()) {
                boolean value = (Boolean)i$.next();
                generator.writeBoolean(value);
            }
        } else if (type == 12) {
            for (BigDecimal value : (Iterable)property.getValue(Type.DECIMALS)) {
                generator.writeNumber(value);
            }
        } else if (type == 4) {
            Iterator i$ = ((Iterable)property.getValue(Type.DOUBLES)).iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                generator.writeNumber(value);
            }
        } else if (type == 3) {
            Iterator i$ = ((Iterable)property.getValue(Type.LONGS)).iterator();
            while (i$.hasNext()) {
                long value = (Long)i$.next();
                generator.writeNumber(value);
            }
        } else if (type == 2) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (Blob value : (Iterable)property.getValue(Type.BINARIES)) {
                try (InputStream stream = value.getNewStream();){
                    byte[] b = new byte[1024];
                    int n = stream.read(b);
                    while (n != -1) {
                        buffer.write(b, 0, n);
                        n = stream.read(b);
                    }
                }
                generator.writeBinary(buffer.toByteArray());
            }
        } else {
            for (String value : (Iterable)property.getValue(Type.STRINGS)) {
                generator.writeString(value);
            }
        }
    }
}

