/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.http.segment;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;

public abstract class SegmentServlet
extends HttpServlet {
    protected abstract SegmentStore getSegmentStore();

    private SegmentId getSegmentId(String info) {
        try {
            UUID uuid = UUID.fromString(info);
            return this.getSegmentStore().getTracker().getSegmentId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private RecordId getRecordId(BufferedReader reader) throws IOException {
        try {
            return RecordId.fromString((SegmentTracker)this.getSegmentStore().getTracker(), (String)reader.readLine());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info == null || info.equals("") || info.equals("/")) {
            response.setContentType("text/plain; charset=UTF-8");
            SegmentNodeState head = this.getSegmentStore().getHead();
            response.getWriter().write(head.getRecordId().toString());
        } else if (info.startsWith("/")) {
            this.doGetSegment(info.substring(1, info.length()), response);
        } else {
            response.sendError(404);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info == null || info.equals("") || info.equals("/")) {
            RecordId id = this.getRecordId(request.getReader());
            if (id == null) {
                response.sendError(400);
            } else {
                SegmentStore store = this.getSegmentStore();
                SegmentNodeState head = new SegmentNodeState(id);
                if (store.setHead(store.getHead(), head)) {
                    response.setStatus(200);
                } else {
                    response.sendError(409);
                }
            }
        } else if (info.startsWith("/")) {
            this.doPutSegment(info.substring(1, info.length()), request, response);
        } else {
            response.sendError(404);
        }
    }

    private void doGetSegment(String info, HttpServletResponse response) throws ServletException, IOException {
        SegmentId id = this.getSegmentId(info);
        if (id == null) {
            response.sendError(404);
            return;
        }
        Segment segment = id.getSegment();
        if (segment == null) {
            response.sendError(404);
            return;
        }
        response.setContentType("application/octet-stream");
        segment.writeTo((OutputStream)response.getOutputStream());
    }

    private void doPutSegment(String info, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SegmentId id = this.getSegmentId(info);
        if (id == null) {
            response.sendError(404);
        } else if (this.getSegmentStore().containsSegment(id)) {
            response.sendError(403);
        } else {
            byte[] data = ByteStreams.toByteArray((InputStream)request.getInputStream());
            this.getSegmentStore().writeSegment(id, data, 0, data.length);
            response.setStatus(200);
        }
    }
}

