/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.principal;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CustomPrincipalProvider
implements PrincipalProvider {
    private final Set knownPrincipalNames;

    CustomPrincipalProvider(String[] knownPrincipalNames) {
        this.knownPrincipalNames = ImmutableSet.copyOf((Object[])knownPrincipalNames);
    }

    public Principal getPrincipal(@NotNull String principalName) {
        if (this.knownPrincipalNames.contains(principalName)) {
            return () -> principalName;
        }
        return null;
    }

    @NotNull
    public Set<Principal> getMembershipPrincipals(@NotNull Principal principal) {
        return Collections.EMPTY_SET;
    }

    @NotNull
    public Set<? extends Principal> getPrincipals(@NotNull String userID) {
        return Collections.EMPTY_SET;
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        return Collections.emptyIterator();
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return Collections.emptyIterator();
    }
}

