/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.ThreeRolesAccessControlManager;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.ThreeRolesConstants;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.ThreeRolesPermissionProvider;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeTypeRegistry;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.EmptyPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={AuthorizationConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="supportedPath", label="Supported Path"), @Property(name="configurationRanking", label="Ranking", description="Ranking of this configuration in a setup with multiple authorization configurations.", intValue={10}), @Property(name="oak.security.name", propertyPrivate=true, value={"org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.ThreeRolesAuthorizationConfiguration"})})
public class ThreeRolesAuthorizationConfiguration
extends ConfigurationBase
implements AuthorizationConfiguration,
ThreeRolesConstants {
    private static final Logger log = LoggerFactory.getLogger(ThreeRolesAuthorizationConfiguration.class);
    private String supportedPath;

    @Activate
    private void activate(Map<String, Object> properties) {
        this.supportedPath = PropertiesUtil.toString((Object)properties.get("supportedPath"), (String)null);
    }

    @Modified
    private void modified(Map<String, Object> properties) {
        this.supportedPath = PropertiesUtil.toString((Object)properties.get("supportedPath"), (String)null);
    }

    @Deactivate
    private void deactivate(Map<String, Object> properties) {
        this.supportedPath = null;
    }

    @NotNull
    public AccessControlManager getAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        return new ThreeRolesAccessControlManager(root, this.supportedPath, this.getSecurityProvider());
    }

    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        return RestrictionProvider.EMPTY;
    }

    @NotNull
    public PermissionProvider getPermissionProvider(@NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals) {
        if (this.supportedPath == null) {
            return EmptyPermissionProvider.getInstance();
        }
        return new ThreeRolesPermissionProvider(root, principals, this.supportedPath, this.getContext(), this.getRootProvider());
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.authorization";
    }

    @NotNull
    public RepositoryInitializer getRepositoryInitializer() {
        String cnd = "<rep='internal'>\n[rep:ThreeRolesMixin] \n   mixin\n   +rep:threeRolesPolicy (rep:ThreeRolesPolicy) protected IGNORE\n\n[rep:ThreeRolesPolicy] > rep:Policy\n  - rep:readers (STRING) multiple protected IGNORE\n  - rep:editors (STRING) multiple protected IGNORE\n  - rep:owners (STRING) multiple protected IGNORE";
        System.out.println(cnd);
        return builder -> {
            NodeState base = builder.getNodeState();
            MemoryNodeStore store = new MemoryNodeStore(base);
            Root root = this.getRootProvider().createSystemRoot((NodeStore)store, (CommitHook)new EditorHook((EditorProvider)new CompositeEditorProvider(new EditorProvider[]{new NamespaceEditorProvider(), new TypeEditorProvider()})));
            try {
                if (!ReadOnlyNodeTypeManager.getInstance((Root)root, (NamePathMapper)NamePathMapper.DEFAULT).hasNodeType("rep:ThreeRolesMixin")) {
                    NodeTypeRegistry.register((Root)root, (InputStream)new ByteArrayInputStream(cnd.getBytes()), (String)"oak exercise");
                    NodeState target = store.getRoot();
                    target.compareAgainstBaseState(base, (NodeStateDiff)new ApplyDiff(builder));
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        };
    }

    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        return ImmutableList.of((Object)new ValidatorProvider(){

            protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
                return null;
            }
        });
    }

    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return ImmutableList.of();
    }

    @NotNull
    public Context getContext() {
        return new Context(){

            public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
                return this.definesTree(parent) && ThreeRolesConstants.NAMES.contains(property.getName());
            }

            public boolean definesContextRoot(@NotNull Tree tree) {
                return this.definesTree(tree);
            }

            public boolean definesTree(@NotNull Tree tree) {
                return "rep:threeRolesPolicy".equals(tree.getName());
            }

            public boolean definesLocation(@NotNull TreeLocation location) {
                String name = location.getName();
                return ThreeRolesConstants.NAMES.contains(name);
            }

            public boolean definesInternal(@NotNull Tree tree) {
                return false;
            }
        };
    }

    public void setParameters(@NotNull ConfigurationParameters config) {
        super.setParameters(config);
        this.supportedPath = (String)config.getConfigValue("supportedPath", null);
    }
}

