/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.authorization.models.readonly;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.NamedAccessControlPolicy;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.EmptyPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Component(metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={AuthorizationConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="configurationRanking", label="Ranking", description="Ranking of this configuration in a setup with multiple authorization configurations.", intValue={300}), @Property(name="oak.security.name", propertyPrivate=true, value={"org.apache.jackrabbit.oak.exercise.security.authorization.models.readonly.ReadOnlyAuthorizationConfiguration"})})
public final class ReadOnlyAuthorizationConfiguration
extends ConfigurationBase
implements AuthorizationConfiguration {
    private static final long READ_PERMISSIONS = 131L;
    private static final Set<String> READ_PRIVILEGE_NAMES = ImmutableSet.of((Object)"jcr:read", (Object)"jcr:readAccessControl", (Object)"rep:readNodes", (Object)"rep:readProperties");

    @NotNull
    public AccessControlManager getAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        return new AbstractAccessControlManager(root, namePathMapper, this.getSecurityProvider()){

            public AccessControlPolicy[] getPolicies(String absPath) {
                return new AccessControlPolicy[0];
            }

            public AccessControlPolicy[] getEffectivePolicies(String absPath) {
                return new AccessControlPolicy[]{ReadOnlyPolicy.INSTANCE};
            }

            public AccessControlPolicyIterator getApplicablePolicies(String absPath) {
                return new AccessControlPolicyIteratorAdapter(Collections.emptyIterator());
            }

            public void setPolicy(String absPath, AccessControlPolicy policy) throws AccessControlException {
                throw new AccessControlException();
            }

            public void removePolicy(String absPath, AccessControlPolicy policy) throws AccessControlException {
                throw new AccessControlException();
            }

            public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) {
                return new JackrabbitAccessControlPolicy[0];
            }

            public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) {
                return new JackrabbitAccessControlPolicy[0];
            }

            public AccessControlPolicy[] getEffectivePolicies(Set<Principal> set) {
                return new AccessControlPolicy[]{ReadOnlyPolicy.INSTANCE};
            }
        };
    }

    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        return RestrictionProvider.EMPTY;
    }

    @NotNull
    public PermissionProvider getPermissionProvider(final @NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals) {
        if (principals.contains(SystemPrincipal.INSTANCE)) {
            return EmptyPermissionProvider.getInstance();
        }
        return new AggregatedPermissionProvider(){

            @NotNull
            public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
                return privilegeBits != null ? privilegeBits : new PrivilegeBitsProvider(root).getBits(new String[]{"jcr:all"});
            }

            public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
                return permissions;
            }

            public long supportedPermissions(@NotNull TreeLocation location, long permissions) {
                return permissions;
            }

            public long supportedPermissions(@NotNull TreePermission treePermission, @Nullable PropertyState property, long permissions) {
                return permissions;
            }

            public boolean isGranted(@NotNull TreeLocation location, long permissions) {
                return ReadOnlyAuthorizationConfiguration.onlyReadPermissions(permissions);
            }

            @NotNull
            public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreePermission parentPermission) {
                return new ReadOnlyPermissions();
            }

            public void refresh() {
            }

            @NotNull
            public Set<String> getPrivileges(@Nullable Tree tree) {
                return READ_PRIVILEGE_NAMES;
            }

            public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
                HashSet privs = Sets.newHashSet((Object[])privilegeNames);
                privs.removeAll(READ_PRIVILEGE_NAMES);
                return privs.isEmpty();
            }

            @NotNull
            public RepositoryPermission getRepositoryPermission() {
                return RepositoryPermission.EMPTY;
            }

            @NotNull
            public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreePermission parentPermission) {
                return ReadOnlyPermissions.INSTANCE;
            }

            public boolean isGranted(@NotNull Tree tree, @Nullable PropertyState property, long permissions) {
                return ReadOnlyAuthorizationConfiguration.onlyReadPermissions(permissions);
            }

            public boolean isGranted(@NotNull String oakPath, @NotNull String jcrActions) {
                return ReadOnlyAuthorizationConfiguration.onlyReadPermissions(Permissions.getPermissions((String)jcrActions, (TreeLocation)TreeLocation.create((Root)root, (String)oakPath), (boolean)false));
            }
        };
    }

    private static final boolean onlyReadPermissions(long permissions) {
        return Permissions.diff((long)permissions, (long)131L) == 0L;
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.authorization";
    }

    @NotNull
    public ConfigurationParameters getParameters() {
        return ConfigurationParameters.EMPTY;
    }

    @NotNull
    public WorkspaceInitializer getWorkspaceInitializer() {
        return WorkspaceInitializer.DEFAULT;
    }

    @NotNull
    public RepositoryInitializer getRepositoryInitializer() {
        return RepositoryInitializer.DEFAULT;
    }

    @NotNull
    public List<? extends CommitHook> getCommitHooks(@NotNull String workspaceName) {
        return ImmutableList.of();
    }

    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        return ImmutableList.of();
    }

    @NotNull
    public List<ThreeWayConflictHandler> getConflictHandlers() {
        return ImmutableList.of();
    }

    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return ImmutableList.of();
    }

    @NotNull
    public Context getContext() {
        return Context.DEFAULT;
    }

    private static final class ReadOnlyPolicy
    implements NamedAccessControlPolicy {
        private static final NamedAccessControlPolicy INSTANCE = new ReadOnlyPolicy();

        private ReadOnlyPolicy() {
        }

        public String getName() {
            return "Read-only Policy defined by 'ReadOnlyAuthorizationConfiguration'";
        }
    }

    private static final class ReadOnlyPermissions
    implements TreePermission {
        private static final TreePermission INSTANCE = new ReadOnlyPermissions();

        private ReadOnlyPermissions() {
        }

        @NotNull
        public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
            return this;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canRead(@NotNull PropertyState property) {
            return true;
        }

        public boolean canReadAll() {
            return true;
        }

        public boolean canReadProperties() {
            return true;
        }

        public boolean isGranted(long permissions) {
            return ReadOnlyAuthorizationConfiguration.onlyReadPermissions(permissions);
        }

        public boolean isGranted(long permissions, @NotNull PropertyState property) {
            return ReadOnlyAuthorizationConfiguration.onlyReadPermissions(permissions);
        }
    }
}

