/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TimeDurationFormatter {
    private final int threshold;
    private final boolean allowNonAscii;
    private final Locale locale;
    private static TimeUnit[] UNITS = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};
    private static Map<TimeUnit, String> DISPLAYUNIT;
    private static Map<TimeUnit, String> DISPLAYUNIT_ASCII;
    private static TimeDurationFormatter FOR_LOGGING;

    public static TimeDurationFormatter forLogging() {
        return FOR_LOGGING;
    }

    public TimeDurationFormatter(Locale locale, int threshold, boolean allowNonAscii) {
        this.locale = locale;
        this.threshold = threshold;
        this.allowNonAscii = allowNonAscii;
    }

    public String format(long amount, TimeUnit unit) {
        long nanos = unit.toNanos(amount);
        TimeUnit outputUnit = TimeUnit.NANOSECONDS;
        for (TimeUnit u : UNITS) {
            if (u.convert(nanos, TimeUnit.NANOSECONDS) < (long)this.threshold) continue;
            outputUnit = u;
            break;
        }
        double convertedToUnit = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, outputUnit);
        return String.format(this.locale, "%.4g %s", convertedToUnit, this.allowNonAscii ? DISPLAYUNIT.get((Object)outputUnit) : DISPLAYUNIT_ASCII.get((Object)outputUnit));
    }

    static {
        HashMap t = Maps.newHashMap();
        t.put(TimeUnit.DAYS, "d");
        t.put(TimeUnit.HOURS, "h");
        t.put(TimeUnit.MINUTES, "min");
        t.put(TimeUnit.SECONDS, "s");
        t.put(TimeUnit.MILLISECONDS, "ms");
        t.put(TimeUnit.MICROSECONDS, "us");
        t.put(TimeUnit.NANOSECONDS, "ns");
        DISPLAYUNIT_ASCII = Collections.unmodifiableMap(t);
        t = Maps.newHashMap((Map)t);
        t.put(TimeUnit.MICROSECONDS, "\u00b5s");
        DISPLAYUNIT = Collections.unmodifiableMap(t);
        FOR_LOGGING = new TimeDurationFormatter(Locale.US, 2, false);
    }
}

