/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.json;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;

public class JsonObject {
    private Map<String, String> props = new HashMap<String, String>();
    private Map<String, JsonObject> children = new HashMap<String, JsonObject>();

    public static JsonObject create(JsopTokenizer t) {
        JsonObject obj = new JsonObject();
        if (!t.matches(125)) {
            do {
                String key = t.readString();
                t.read(58);
                if (t.matches(123)) {
                    obj.children.put(key, JsonObject.create(t));
                    continue;
                }
                obj.props.put(key, t.readRawValue().trim());
            } while (t.matches(44));
            t.read(125);
        }
        return obj;
    }

    public void toJson(JsopBuilder buf) {
        JsonObject.toJson(buf, this);
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public Map<String, JsonObject> getChildren() {
        return this.children;
    }

    private static void toJson(JsopBuilder buf, JsonObject obj) {
        buf.object();
        for (String name : obj.props.keySet()) {
            buf.key(name).encodedValue(obj.props.get(name));
        }
        for (String name : obj.children.keySet()) {
            buf.key(name);
            JsonObject.toJson(buf, obj.children.get(name));
        }
        buf.endObject();
    }
}

