/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.benchmark;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class PerfLogger {
    private final Logger delegate;

    public PerfLogger(Logger delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.delegate = delegate;
    }

    public final long start() {
        if (this.canExitEarly()) {
            return -1L;
        }
        return this.start(null, false);
    }

    public final long startForInfoLog() {
        if (this.canExitEarly(true)) {
            return -1L;
        }
        return this.start(null, true);
    }

    public final long start(String traceMsgOrNull) {
        if (this.canExitEarly()) {
            return -1L;
        }
        return this.start(traceMsgOrNull, false);
    }

    public final long startForInfoLog(String traceMsgOrNull) {
        if (this.canExitEarly(true)) {
            return -1L;
        }
        return this.start(traceMsgOrNull, true);
    }

    private long start(String traceMsgOrNull, boolean logAtInfoToo) {
        if (this.canExitEarly(logAtInfoToo)) {
            return -1L;
        }
        if (traceMsgOrNull != null && this.delegate.isTraceEnabled()) {
            this.delegate.trace(traceMsgOrNull);
        }
        return System.nanoTime();
    }

    public final void end(long start, long logAtDebugIfSlowerThanMs, String logMessagePrefix, Object arg1) {
        if (start < 0L) {
            return;
        }
        this.end(start, logAtDebugIfSlowerThanMs, Long.MAX_VALUE, logMessagePrefix, new Object[]{arg1});
    }

    public final void end(long start, long logAtDebugIfSlowerThanMs, String logMessagePrefix, Object arg1, Object arg2) {
        if (start < 0L) {
            return;
        }
        this.end(start, logAtDebugIfSlowerThanMs, Long.MAX_VALUE, logMessagePrefix, new Object[]{arg1, arg2});
    }

    public void end(long start, long logAtDebugIfSlowerThanMs, String logMessagePrefix, Object ... arguments) {
        this.end(start, logAtDebugIfSlowerThanMs, Long.MAX_VALUE, logMessagePrefix, arguments);
    }

    public final void end(long start, long logAtDebugIfSlowerThanMs, long logAtInfoIfSlowerThanMs, String logMessagePrefix, Object arg1) {
        if (start < 0L) {
            return;
        }
        this.end(start, logAtDebugIfSlowerThanMs, logAtInfoIfSlowerThanMs, logMessagePrefix, new Object[]{arg1});
    }

    public final void end(long start, long logAtDebugIfSlowerThanMs, long logAtInfoIfSlowerThanMs, String logMessagePrefix, Object arg1, Object arg2) {
        if (start < 0L) {
            return;
        }
        this.end(start, logAtDebugIfSlowerThanMs, logAtInfoIfSlowerThanMs, logMessagePrefix, new Object[]{arg1, arg2});
    }

    public void end(long start, long logAtDebugIfSlowerThanMs, long logAtInfoIfSlowerThanMs, String logMessagePrefix, Object ... arguments) {
        if (start < 0L) {
            return;
        }
        long diff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        if (this.isTraceEnabled()) {
            this.delegate.trace(logMessagePrefix + " [took " + diff + "ms]", arguments);
        } else if ((logAtDebugIfSlowerThanMs < 0L || diff > logAtDebugIfSlowerThanMs) && this.isDebugEnabled()) {
            this.delegate.debug(logMessagePrefix + " [took " + diff + "ms]", arguments);
        } else if (logAtInfoIfSlowerThanMs < 0L || diff > logAtInfoIfSlowerThanMs) {
            this.delegate.info(logMessagePrefix + " [took " + diff + "ms]", arguments);
        }
    }

    private boolean canExitEarly() {
        return this.canExitEarly(false);
    }

    private boolean canExitEarly(boolean logAtInfoToo) {
        if (!logAtInfoToo) {
            return !this.isDebugEnabled();
        }
        return !this.isInfoEnabled();
    }

    public final boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public final boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public final boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }
}

