/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.commons.jmx.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.GarbageCollectionRepoStats;
import org.apache.jackrabbit.oak.plugins.blob.OperationsStatsMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobGC
extends AnnotatedStandardMBean
implements BlobGCMBean {
    private static final Logger log = LoggerFactory.getLogger(BlobGC.class);
    public static final String OP_NAME = "Blob garbage collection";
    private final BlobGarbageCollector blobGarbageCollector;
    private final Executor executor;
    private ManagementOperation<String> gcOp = ManagementOperation.done((String)"Blob garbage collection", (Object)"");
    public static final String CONSISTENCY_OP_NAME = "Blob consistency check";
    private ManagementOperation<String> consistencyOp = ManagementOperation.done((String)"Blob consistency check", (Object)"");
    private static final String[] MARK_FIELD_NAMES = new String[]{"repositoryId", "markStartTime", "markEndTime", "referenceFileSizeBytes", "referencesFileSize", "numReferences"};
    private static final String[] MARK_FIELD_DESCRIPTIONS = new String[]{"Repository ID", "Start time of mark", "End time of mark", "References file size in bytes", "References file size in human readable format", "Number of references"};
    private static final OpenType[] MARK_FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.INTEGER};
    private static final CompositeType MARK_TYPE = BlobGC.createMarkCompositeType();
    private static final String[] OP_STATS_FIELD_NAMES = new String[]{"startCount", "finishSuccessCount", "finishErrorCount", "duration"};
    private static final String[] OP_STATS_FIELD_DESCRIPTIONS = new String[]{"Start Count", "Finish Success Count", "Finish Error Count", "Duration"};
    private static final OpenType[] OP_STATS_FIELD_TYPES = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
    private static final CompositeType OP_STATS_TYPE = BlobGC.createOpStatsCompositeType();

    public BlobGC(@Nonnull BlobGarbageCollector blobGarbageCollector, @Nonnull Executor executor) {
        super(BlobGCMBean.class);
        this.blobGarbageCollector = (BlobGarbageCollector)Preconditions.checkNotNull((Object)blobGarbageCollector);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    @Nonnull
    public CompositeData startBlobGC(final boolean markOnly) {
        if (this.gcOp.isDone()) {
            this.gcOp = ManagementOperation.newManagementOperation((String)OP_NAME, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    BlobGC.this.blobGarbageCollector.collectGarbage(markOnly);
                    return "Blob gc completed in " + ManagementOperation.Status.formatTime((long)(System.nanoTime() - t0));
                }
            });
            this.executor.execute((Runnable)this.gcOp);
        }
        return this.getBlobGCStatus();
    }

    @Override
    public CompositeData startBlobGC(final boolean markOnly, final boolean forceBlobIdRetrieve) {
        if (this.gcOp.isDone()) {
            this.gcOp = ManagementOperation.newManagementOperation((String)OP_NAME, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    BlobGC.this.blobGarbageCollector.collectGarbage(markOnly, forceBlobIdRetrieve);
                    return "Blob gc completed in " + ManagementOperation.Status.formatTime((long)(System.nanoTime() - t0));
                }
            });
            this.executor.execute((Runnable)this.gcOp);
        }
        return this.getBlobGCStatus();
    }

    @Override
    @Nonnull
    public CompositeData getBlobGCStatus() {
        return this.gcOp.getStatus().toCompositeData();
    }

    @Override
    public CompositeData checkConsistency() {
        if (this.consistencyOp.isDone()) {
            this.consistencyOp = ManagementOperation.newManagementOperation((String)CONSISTENCY_OP_NAME, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    long missing = BlobGC.this.blobGarbageCollector.checkConsistency();
                    return "Consistency check completed in " + ManagementOperation.Status.formatTime((long)(System.nanoTime() - t0)) + ". " + missing + " missing blobs found (details in the log).";
                }
            });
            this.executor.execute((Runnable)this.consistencyOp);
        }
        return this.getConsistencyCheckStatus();
    }

    @Override
    @Nonnull
    public CompositeData getConsistencyCheckStatus() {
        return this.consistencyOp.getStatus().toCompositeData();
    }

    @Override
    public TabularData getGlobalMarkStats() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(BlobGC.class.getName(), "Garbage collection global mark phase Stats", MARK_TYPE, new String[]{"repositoryId"});
            tds = new TabularDataSupport(tt);
            List<GarbageCollectionRepoStats> stats = this.blobGarbageCollector.getStats();
            for (GarbageCollectionRepoStats stat : stats) {
                tds.put(this.toCompositeData(stat));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    private CompositeDataSupport toCompositeData(GarbageCollectionRepoStats statObj) throws OpenDataException {
        Object[] values = new Object[]{statObj.getRepositoryId() + (statObj.isLocal() ? " *" : ""), (statObj.getStartTime() == 0L ? "" : new Date(statObj.getStartTime())).toString(), (statObj.getEndTime() == 0L ? "" : new Date(statObj.getEndTime())).toString(), statObj.getLength(), IOUtils.humanReadableByteCount((long)statObj.getLength()), statObj.getNumLines()};
        return new CompositeDataSupport(MARK_TYPE, MARK_FIELD_NAMES, values);
    }

    private static CompositeType createMarkCompositeType() {
        try {
            return new CompositeType(GarbageCollectionRepoStats.class.getName(), "Composite data type for datastore GC statistics", MARK_FIELD_NAMES, MARK_FIELD_DESCRIPTIONS, MARK_FIELD_TYPES);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public TabularData getOperationStats() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(BlobGC.class.getName(), "Garbage Collection Operation Stats", OP_STATS_TYPE, OP_STATS_FIELD_NAMES);
            tds = new TabularDataSupport(tt);
            OperationsStatsMBean operationStats = this.blobGarbageCollector.getOperationStats();
            tds.put(this.toCompositeData(operationStats));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    private CompositeData toCompositeData(OperationsStatsMBean statObj) throws OpenDataException {
        Object[] values = new Object[]{statObj.getStartCount(), statObj.getFinishSucessCount(), statObj.getFinishErrorCount(), statObj.duration()};
        return new CompositeDataSupport(OP_STATS_TYPE, OP_STATS_FIELD_NAMES, values);
    }

    private static CompositeType createOpStatsCompositeType() {
        try {
            return new CompositeType(GarbageCollectionRepoStats.class.getName(), "Composite data type for datastore GC operation stats", OP_STATS_FIELD_NAMES, OP_STATS_FIELD_DESCRIPTIONS, OP_STATS_FIELD_TYPES);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
    }
}

