/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CugUtil
implements CugConstants {
    private static final Logger log = LoggerFactory.getLogger(CugUtil.class);

    private CugUtil() {
    }

    public static boolean hasCug(@Nonnull Tree tree) {
        return tree.exists() && tree.hasChild("rep:cugPolicy");
    }

    public static boolean hasCug(@CheckForNull NodeState state) {
        return state != null && state.hasChildNode("rep:cugPolicy");
    }

    public static boolean hasCug(@CheckForNull NodeBuilder builder) {
        return builder != null && builder.hasChildNode("rep:cugPolicy");
    }

    @CheckForNull
    public static Tree getCug(@Nonnull Tree tree) {
        Tree cugTree;
        Tree tree2 = cugTree = CugUtil.hasCug(tree) ? tree.getChild("rep:cugPolicy") : null;
        if (cugTree != null && "rep:CugPolicy".equals(TreeUtil.getPrimaryTypeName((Tree)cugTree))) {
            return cugTree;
        }
        return null;
    }

    public static boolean definesCug(@Nonnull Tree tree) {
        return tree.exists() && "rep:cugPolicy".equals(tree.getName()) && "rep:CugPolicy".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public static boolean definesCug(@Nonnull String name, @Nonnull NodeState state) {
        return "rep:cugPolicy".equals(name) && "rep:CugPolicy".equals(NodeStateUtils.getPrimaryTypeName((NodeState)state));
    }

    public static boolean definesCug(@Nonnull Tree tree, @Nonnull PropertyState property) {
        return "rep:principalNames".equals(property.getName()) && CugUtil.definesCug(tree);
    }

    public static boolean hasNestedCug(@Nonnull Tree cugTree) {
        return cugTree.hasProperty(":nestedCugs");
    }

    public static boolean isSupportedPath(@Nullable String oakPath, @Nonnull Set<String> supportedPaths) {
        if (oakPath == null) {
            return false;
        }
        for (String supportedPath : supportedPaths) {
            if (!Text.isDescendantOrEqual((String)supportedPath, (String)oakPath)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getSupportedPaths(@Nonnull ConfigurationParameters params, @Nonnull MountInfoProvider mountInfoProvider) {
        Set supportedPaths = (Set)params.getConfigValue("cugSupportedPaths", (Object)ImmutableSet.of());
        if (!supportedPaths.isEmpty() && mountInfoProvider.hasNonDefaultMounts()) {
            for (Mount mount : mountInfoProvider.getNonDefaultMounts()) {
                for (String path : supportedPaths) {
                    if (mount.isUnder(path)) {
                        log.error("Configured supported CUG path '{}' includes node store mount '{}'.", (Object)path, (Object)mount.getName());
                        throw new IllegalStateException();
                    }
                    if (!mount.isMounted(path)) continue;
                    log.error("Configured supported CUG path '{}' is part of node store mount '{}'.", (Object)path, (Object)mount.getName());
                    throw new IllegalStateException();
                }
            }
        }
        return supportedPaths;
    }

    public static int getImportBehavior(ConfigurationParameters config) {
        String importBehaviorStr = (String)config.getConfigValue("importBehavior", (Object)"abort");
        return ImportBehavior.valueFromString((String)importBehaviorStr);
    }
}

