/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.spi.LoginModule;
import org.apache.felix.jaas.LoginModuleFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProviderManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.SyncHandlerMapping;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.SyncMBeanImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.SynchronizationMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Jackrabbit Oak External Login Module", metatype=true, policy=ConfigurationPolicy.REQUIRE, configurationFactory=true)
@Service
public class ExternalLoginModuleFactory
implements LoginModuleFactory,
SyncHandlerMapping {
    private static final Logger log = LoggerFactory.getLogger(ExternalLoginModuleFactory.class);
    @Property(intValue={50}, label="JAAS Ranking", description="Specifying the ranking (i.e. sort order) of this login module entry. The entries are sorted in a descending order (i.e. higher value ranked configurations come first).")
    public static final String JAAS_RANKING = "jaas.ranking";
    @Property(value={"SUFFICIENT"}, label="JAAS Control Flag", description="Property specifying whether or not a LoginModule is REQUIRED, REQUISITE, SUFFICIENT or OPTIONAL. Refer to the JAAS configuration documentation for more details around the meaning of these flags.")
    public static final String JAAS_CONTROL_FLAG = "jaas.controlFlag";
    @Property(label="JAAS Realm", description="The realm name (or application name) against which the LoginModule  is be registered. If no realm name is provided then LoginModule is registered with a default realm as configured in the Felix JAAS configuration.")
    public static final String JAAS_REALM_NAME = "jaas.realmName";
    @Property(label="Identity Provider Name", description="Name of the identity provider (for example: 'ldap').")
    public static final String PARAM_IDP_NAME = "idp.name";
    @Property(value={"default"}, label="Sync Handler Name", description="Name of the sync handler.")
    public static final String PARAM_SYNC_HANDLER_NAME = "sync.handlerName";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private SecurityProvider securityProvider;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private ContentRepository contentRepository;
    @Reference
    private SyncManager syncManager;
    @Reference
    private ExternalIdentityProviderManager idpManager;
    private ConfigurationParameters osgiConfig = ConfigurationParameters.EMPTY;
    private BundleContext bundleContext;
    private Registration mbeanRegistration;

    @Activate
    private void activate(ComponentContext context) {
        this.osgiConfig = ConfigurationParameters.of((Dictionary)context.getProperties());
        this.bundleContext = context.getBundleContext();
        this.mayRegisterSyncMBean();
    }

    @Deactivate
    private void deactivate() {
        this.unregisterSyncMBean();
    }

    public void bindContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.mayRegisterSyncMBean();
    }

    public void unbindContentRepository(ContentRepository contentRepository) {
        this.contentRepository = null;
        this.unregisterSyncMBean();
    }

    public void bindSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
        this.mayRegisterSyncMBean();
    }

    public void unbindSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = null;
        this.unregisterSyncMBean();
    }

    private void mayRegisterSyncMBean() {
        log.debug("Trying to register SynchronizationMBean");
        if (this.mbeanRegistration != null) {
            log.debug("SynchronizationMBean already registered");
            return;
        }
        if (this.bundleContext == null) {
            log.debug("Cannot register SynchronizationMBean; not yet activated.");
            return;
        }
        if (this.contentRepository == null || this.securityProvider == null) {
            log.debug("Cannot register SynchronizationMBean; waiting for references to ContentRepository|SecurityProvider.");
            return;
        }
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.bundleContext);
        try {
            log.debug("Registering SynchronizationMBean");
            String idpName = (String)this.osgiConfig.getConfigValue(PARAM_IDP_NAME, (Object)"");
            String sncName = (String)this.osgiConfig.getConfigValue(PARAM_SYNC_HANDLER_NAME, (Object)"");
            SyncMBeanImpl bean = new SyncMBeanImpl(this.contentRepository, this.securityProvider, this.syncManager, sncName, this.idpManager, idpName);
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("type", "UserManagement");
            table.put("name", "External Identity Synchronization Management");
            table.put("handler", ObjectName.quote(sncName));
            table.put("idp", ObjectName.quote(idpName));
            this.mbeanRegistration = whiteboard.register(SynchronizationMBean.class, (Object)bean, (Map)ImmutableMap.of((Object)"jmx.objectname", (Object)new ObjectName("org.apache.jackrabbit.oak", table)));
            log.debug("Registration of SynchronizationMBean completed");
        }
        catch (MalformedObjectNameException e) {
            log.error("Unable to register SynchronizationMBean", (Throwable)e);
        }
    }

    private void unregisterSyncMBean() {
        if (this.mbeanRegistration != null) {
            log.debug("Unregistering SynchronizationMBean");
            this.mbeanRegistration.unregister();
            this.mbeanRegistration = null;
            log.debug("Unregister SynchronizationMBean: completed");
        } else {
            log.debug("Unable to unregister SynchronizationMBean; missing registration.");
        }
    }

    public LoginModule createLoginModule() {
        ExternalLoginModule lm = new ExternalLoginModule(this.osgiConfig);
        lm.setIdpManager(this.idpManager);
        lm.setSyncManager(this.syncManager);
        return lm;
    }

    protected void bindSyncManager(SyncManager syncManager) {
        this.syncManager = syncManager;
    }

    protected void unbindSyncManager(SyncManager syncManager) {
        if (this.syncManager == syncManager) {
            this.syncManager = null;
        }
    }

    protected void bindIdpManager(ExternalIdentityProviderManager externalIdentityProviderManager) {
        this.idpManager = externalIdentityProviderManager;
    }

    protected void unbindIdpManager(ExternalIdentityProviderManager externalIdentityProviderManager) {
        if (this.idpManager == externalIdentityProviderManager) {
            this.idpManager = null;
        }
    }
}

