/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.util.Map;
import javax.security.auth.spi.LoginModule;
import org.apache.felix.jaas.LoginModuleFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalLoginModule;

@Component(label="Apache Jackrabbit Oak External Login Module", metatype=true, policy=ConfigurationPolicy.REQUIRE, configurationFactory=true)
@Service
public class ExternalLoginModuleFactory
implements LoginModuleFactory {
    @Property(intValue={150}, label="JAAS Ranking", description="Specifying the ranking (i.e. sort order) of this login module entry. The entries are sorted in a descending order (i.e. higher value ranked configurations come first).")
    public static final String JAAS_RANKING = "jaas.ranking";
    @Property(value={"SUFFICIENT"}, label="JAAS Control Flag", description="Property specifying whether or not a LoginModule is REQUIRED, REQUISITE, SUFFICIENT or OPTIONAL.Refer to the JAAS configuration documentation for more details around the meaning of these flags.")
    public static final String JAAS_CONTROL_FLAG = "jaas.controlFlag";
    @Property(label="JAAS Realm", description="The realm name (or application name) against which the LoginModule  is be registered. If no realm name is provided then LoginModule is registered with a default realm as configured in the Felix JAAS configuration.")
    public static final String JAAS_REALM_NAME = "jaas.realmName";
    @Property(label="Identity Provider Name", description="Name of the identity provider (for example: 'ldap').")
    public static final String PARAM_IDP_NAME = "idp.name";
    @Property(value={"default"}, label="Sync Handler Name", description="Name of the sync handler.")
    public static final String PARAM_SYNC_HANDLER_NAME = "sync.handlerName";
    private ConfigurationParameters osgiConfig;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.osgiConfig = ConfigurationParameters.of(properties);
    }

    public LoginModule createLoginModule() {
        return new ExternalLoginModule(this.osgiConfig);
    }
}

