/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.util.Text;

public class ExternalIdentityRef {
    private final String id;
    private final String providerName;
    private final String string;

    public ExternalIdentityRef(@Nonnull String id, @CheckForNull String providerName) {
        this.id = id;
        this.providerName = providerName;
        StringBuilder b = new StringBuilder();
        b.append(Text.escape((String)id));
        if (providerName != null && providerName.length() > 0) {
            b.append('@').append(Text.escape((String)providerName));
        }
        this.string = b.toString();
    }

    @CheckForNull
    public String getProviderName() {
        return this.providerName;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getString() {
        return this.string;
    }

    public static ExternalIdentityRef fromString(@Nonnull String str) {
        int idx = str.indexOf(64);
        if (idx < 0) {
            return new ExternalIdentityRef(Text.unescape((String)str), null);
        }
        return new ExternalIdentityRef(Text.unescape((String)str.substring(0, idx)), Text.unescape((String)str.substring(idx + 1)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExternalIdentityRef{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", providerName='").append(this.providerName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        try {
            return this == o || this.string.equals(((ExternalIdentityRef)o).string);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

