/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsPowerPointTextExtractor
extends AbstractTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger((Class)MsPowerPointTextExtractor.class);

    public MsPowerPointTextExtractor() {
        super(new String[]{"application/vnd.ms-powerpoint", "application/mspowerpoint"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MsPowerPointListener listener = new MsPowerPointListener(baos);
            POIFSReader reader = new POIFSReader();
            reader.registerListener((POIFSReaderListener)listener);
            reader.read(stream);
            InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
            return inputStreamReader;
        }
        catch (RuntimeException e) {
            logger.warn("Failed to extract PowerPoint text content", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }

    static {
        POIFSReader.class.getName();
    }

    private class MsPowerPointListener
    implements POIFSReaderListener {
        private OutputStream os;

        MsPowerPointListener(OutputStream os) {
            this.os = os;
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            try {
                if (!event.getName().equalsIgnoreCase("PowerPoint Document")) {
                    return;
                }
                DocumentInputStream input = event.getStream();
                byte[] buffer = new byte[input.available()];
                input.read(buffer, 0, input.available());
                for (int i = 0; i < buffer.length - 20; ++i) {
                    long type = LittleEndian.getUShort((byte[])buffer, (int)(i + 2));
                    long size = LittleEndian.getUInt((byte[])buffer, (int)(i + 4));
                    if (type != 4008L) continue;
                    this.os.write(buffer, i + 4 + 1, (int)size + 3);
                    i = i + 4 + 1 + (int)size - 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

