/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.mojo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.filevault.maven.packaging.impl.ValidationMessagePrinter;
import org.apache.jackrabbit.filevault.maven.packaging.mojo.AbstractValidateMojo;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ZipArchive;
import org.apache.jackrabbit.vault.fs.io.ZipStreamArchive;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.context.ArchiveValidationContext;
import org.apache.jackrabbit.vault.validation.context.DependencyResolver;
import org.apache.jackrabbit.vault.validation.context.SubPackageInArchiveValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.jetbrains.annotations.Nullable;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.SAXException;

@Mojo(name="validate-package", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=false, threadSafe=true)
public class ValidatePackageMojo
extends AbstractValidateMojo {
    @Parameter(property="vault.packageToValidate", defaultValue="${project.artifact.file}")
    private File packageFile;
    @Parameter(property="vault.skipPackageFile")
    private boolean skipPackageFile;
    @Parameter(required=true, defaultValue="false")
    private boolean enforceRecursiveSubpackageValidation;
    @Parameter(required=true, defaultValue="false")
    private boolean skipSubPackageValidation;
    @Parameter(readonly=true, defaultValue="${project.attachedArtifacts}")
    private List<Artifact> attachedArtifacts;
    @Parameter(property="vault.classifiers")
    private List<String> classifiers;
    @Parameter(property="vault.classifier")
    protected String classifier = "";

    @Inject
    public ValidatePackageMojo(RepositorySystem repositorySystem, BuildContext buildContext) {
        super(repositorySystem, buildContext);
    }

    @Override
    public void doExecute(ValidationMessagePrinter validationHelper) throws MojoExecutionException, MojoFailureException {
        boolean foundPackage = false;
        if (!this.skipPackageFile && this.packageFile != null && this.packageFile.isFile()) {
            this.validatePackage(validationHelper, this.packageFile.toPath());
            foundPackage = true;
        }
        if (!this.attachedArtifacts.isEmpty()) {
            ArrayList<String> classifiersToCompare = new ArrayList<String>();
            if (this.classifiers != null) {
                classifiersToCompare.addAll(this.classifiers);
            }
            if (StringUtils.isNotBlank((String)this.classifier)) {
                classifiersToCompare.add(this.classifier);
            }
            for (Artifact attached : this.attachedArtifacts) {
                if (!classifiersToCompare.contains(attached.getClassifier()) || !"content-package".equals(attached.getType())) continue;
                this.validatePackage(validationHelper, attached.getFile().toPath());
                foundPackage = true;
            }
        }
        if (!foundPackage) {
            throw new MojoFailureException("No packages found to validate.");
        }
        validationHelper.failBuildInCaseOfViolations(this.failOnValidationWarnings);
    }

    private void validatePackage(ValidationMessagePrinter validationHelper, Path file) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Start validating package " + this.getProjectRelativeFilePath(file) + "..."));
        try (ZipArchive archive = new ZipArchive(file.toFile());){
            archive.open(true);
            ArchiveValidationContext context = new ArchiveValidationContext((Archive)archive, file, (DependencyResolver)this.resolver);
            ValidationExecutor executor = this.validationExecutorFactory.createValidationExecutor((ValidationContext)context, false, this.enforceRecursiveSubpackageValidation, this.getEffectiveValidatorSettingsForPackage(context.getProperties().getId(), false));
            if (executor == null) {
                throw new MojoExecutionException("No registered validators found!");
            }
            validationHelper.printUsedValidators(this.getLog(), executor, (ValidationContext)context, true);
            this.validateArchive(validationHelper, (Archive)archive, file, context, executor);
            this.getLog().debug((CharSequence)("End validating package " + this.getProjectRelativeFilePath(file) + "."));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Could not validate package '" + file + "': " + e.getMessage(), e);
        }
    }

    private void validateArchive(ValidationMessagePrinter validationHelper, Archive archive, Path path, ArchiveValidationContext context, ValidationExecutor executor) throws IOException, SAXException, ParserConfigurationException, MojoFailureException {
        this.validateEntry(validationHelper, archive, archive.getRoot(), Paths.get("", new String[0]), path, context, executor);
        validationHelper.printMessages(executor.done(), this.buildContext, path);
    }

    private void validateEntry(ValidationMessagePrinter validationHelper, Archive archive, Archive.Entry entry, Path entryPath, Path packagePath, ArchiveValidationContext context, ValidationExecutor executor) throws IOException, SAXException, ParserConfigurationException, MojoFailureException {
        ArrayList<Archive.Entry> sortedEntryList = new ArrayList<Archive.Entry>(entry.getChildren());
        sortedEntryList.sort(Comparator.comparing(Archive.Entry::getName, new AbstractValidateMojo.DotContentXmlFirstComparator()));
        for (Archive.Entry childEntry : sortedEntryList) {
            if (childEntry.isDirectory()) {
                this.validateInputStream(validationHelper, null, entryPath.resolve(childEntry.getName()), packagePath, context, executor);
                this.validateEntry(validationHelper, archive, childEntry, entryPath.resolve(childEntry.getName()), packagePath, context, executor);
                continue;
            }
            InputStream input = archive.openInputStream(childEntry);
            try {
                this.validateInputStream(validationHelper, input, entryPath.resolve(childEntry.getName()), packagePath, context, executor);
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
    }

    private void validateInputStream(ValidationMessagePrinter validationHelper, @Nullable InputStream inputStream, Path entryPath, Path packagePath, ArchiveValidationContext context, ValidationExecutor executor) throws IOException, SAXException, ParserConfigurationException, MojoFailureException {
        LinkedList<ValidationViolation> messages = new LinkedList<ValidationViolation>();
        if (entryPath.startsWith("META-INF")) {
            messages.addAll(executor.validateMetaInf(inputStream, Paths.get("META-INF", new String[0]).relativize(entryPath), packagePath.resolve("META-INF")));
        } else if (entryPath.startsWith("jcr_root")) {
            Path relativeJcrPath = Paths.get("jcr_root", new String[0]).relativize(entryPath);
            messages.addAll(executor.validateJcrRoot(inputStream, relativeJcrPath, packagePath.resolve("jcr_root")));
            if (inputStream != null && entryPath.getFileName().toString().endsWith(".zip") && !this.skipSubPackageValidation) {
                Path subPackagePath = context.getPackageRootPath().resolve(entryPath);
                try (ZipStreamArchive subArchive = new ZipStreamArchive(inputStream);){
                    subArchive.open(true);
                    if (subArchive.getJcrRoot() == null) {
                        this.getLog().debug((CharSequence)("ZIP entry " + subPackagePath + " is no subpackage as it is lacking the mandatory jcr_root entry"));
                    }
                    this.getLog().info((CharSequence)("Start validating sub package '" + subPackagePath + "'..."));
                    SubPackageInArchiveValidationContext subPackageValidationContext = new SubPackageInArchiveValidationContext(context, (Archive)subArchive, subPackagePath, (DependencyResolver)this.resolver);
                    ValidationExecutor subPackageValidationExecutor = this.validationExecutorFactory.createValidationExecutor((ValidationContext)subPackageValidationContext, true, this.enforceRecursiveSubpackageValidation, this.getEffectiveValidatorSettingsForPackage(subPackageValidationContext.getProperties().getId(), true));
                    if (subPackageValidationExecutor != null) {
                        validationHelper.printUsedValidators(this.getLog(), executor, (ValidationContext)subPackageValidationContext, false);
                        this.validateArchive(validationHelper, (Archive)subArchive, subPackagePath, (ArchiveValidationContext)subPackageValidationContext, subPackageValidationExecutor);
                    } else {
                        this.getLog().debug((CharSequence)"Skip validating sub package as no validator is interested in it.");
                    }
                    this.getLog().info((CharSequence)"End validating sub package.");
                }
            }
        } else {
            messages.add(new ValidationViolation(ValidationMessageSeverity.WARN, "Found unexpected file outside of jcr_root and META-INF", entryPath, packagePath, null, 0, 0, null));
        }
        validationHelper.printMessages(messages, this.buildContext, packagePath);
    }
}

