/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.filevault.maven.packaging.impl.StringFilterSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;

public class SimpleEmbedded {
    private final StringFilterSet groupId = new StringFilterSet();
    private final StringFilterSet artifactId = new StringFilterSet();
    private ScopeArtifactFilter scope;
    private StringFilterSet type = new StringFilterSet();
    private StringFilterSet classifier = new StringFilterSet();
    private boolean filter;
    private boolean excludeTransitive;

    public void setGroupId(String groupId) {
        this.groupId.addEntries(groupId);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId.addEntries(artifactId);
    }

    public void setScope(String scope) {
        this.scope = new ScopeArtifactFilter(scope);
    }

    public void setType(String type) {
        this.type.addEntries(type);
    }

    public void setClassifier(String classifier) {
        this.classifier.addEntries(classifier);
    }

    public void setAddFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setExcludeTransitive(boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
    }

    public boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    public Collection<Artifact> getMatchingArtifacts(MavenProject project) {
        Set deps = this.excludeTransitive ? project.getDependencyArtifacts() : project.getArtifacts();
        return this.getMatchingArtifacts(deps);
    }

    public Collection<Artifact> getMatchingArtifacts(Collection<Artifact> deps) {
        ArrayList<Artifact> matches = new ArrayList<Artifact>();
        for (Artifact artifact : deps) {
            if (!this.groupId.contains(artifact.getGroupId()) || !this.artifactId.contains(artifact.getArtifactId()) || this.scope != null && !this.scope.include(artifact) || this.type != null && !this.type.contains(artifact.getType()) || this.classifier != null && !this.classifier.contains(artifact.getClassifier())) continue;
            matches.add(artifact);
        }
        return matches;
    }

    @Nonnull
    public StringBuilder toString(@Nullable StringBuilder builder) {
        if (builder == null) {
            builder = new StringBuilder();
        }
        builder.append("groupId=").append((Object)this.groupId).append(",");
        builder.append("artifactId=").append((Object)this.artifactId).append(",");
        if (this.scope != null) {
            builder.append("scope=").append(this.scope).append(",");
        }
        if (this.type != null) {
            builder.append("type=").append((Object)this.type).append(",");
        }
        if (this.classifier != null) {
            builder.append("classifier=").append((Object)this.classifier).append(",");
        }
        builder.append("filter=").append(this.filter);
        builder.append(",excludeTransitive=").append(this.excludeTransitive);
        return builder;
    }

    public String toString() {
        return this.toString(null).toString();
    }
}

