/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import org.apache.ignite.internal.processors.query.h2.opt.H2ScanIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractReduceIndexAdapter;
import org.apache.ignite.internal.processors.query.h2.twostep.Reducer;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.table.IndexColumn;
import org.h2.table.TableBase;
import org.h2.table.TableType;

public class ReduceTable
extends TableBase {
    private ArrayList<Index> idxs;

    public ReduceTable(CreateTableData data) {
        super(data);
    }

    public void indexes(ArrayList<Index> idxs) {
        assert (!F.isEmpty(idxs));
        this.idxs = idxs;
    }

    public Reducer getReducer() {
        Index idx = this.idxs.get(this.idxs.size() - 1);
        assert (idx instanceof AbstractReduceIndexAdapter) : "Reducer index not found.";
        return ((AbstractReduceIndexAdapter)idx).reducer();
    }

    public static H2ScanIndex<AbstractReduceIndexAdapter> createScanIndex(AbstractReduceIndexAdapter idx) {
        return new H2ScanIndex<AbstractReduceIndexAdapter>(idx);
    }

    public boolean lock(Session session, boolean exclusive, boolean force) {
        return false;
    }

    public void close(Session ses) {
    }

    public void unlock(Session s) {
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException((String)"addIndex");
    }

    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException((String)"removeRow");
    }

    public void truncate(Session session) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException((String)"addRow");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"alter");
    }

    public TableType getTableType() {
        return TableType.TABLE;
    }

    public Index getScanIndex(Session session) {
        return this.idxs.get(0);
    }

    public Index getUniqueIndex() {
        return null;
    }

    public ArrayList<Index> getIndexes() {
        return this.idxs;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(Session ses) {
        return this.getScanIndex(ses).getRowCount(ses);
    }

    public long getRowCountApproximation() {
        return this.getScanIndex(null).getRowCountApproximation();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }
}

