/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.running.TrackableQuery;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.jetbrains.annotations.Nullable;

public class H2QueryInfo
implements TrackableQuery {
    private final QueryType type;
    private final long beginTs;
    private final String schema;
    private final String sql;
    private final boolean enforceJoinOrder;
    private final boolean distributedJoin;
    private final boolean lazy;
    private final Prepared stmt;
    private final UUID nodeId;
    private final long queryId;

    public H2QueryInfo(QueryType type, PreparedStatement stmt, String sql, UUID nodeId, long queryId) {
        try {
            assert (stmt != null);
            this.type = type;
            this.sql = sql;
            this.nodeId = nodeId;
            this.queryId = queryId;
            this.beginTs = U.currentTimeMillis();
            this.schema = stmt.getConnection().getSchema();
            Session s = H2Utils.session(stmt.getConnection());
            this.enforceJoinOrder = s.isForceJoinOrder();
            this.distributedJoin = s.isJoinBatchEnabled();
            this.lazy = s.isLazyQueryExecution();
            this.stmt = GridSqlQueryParser.prepared(stmt);
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Cannot collect query info", 1, (Throwable)e);
        }
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public long queryId() {
        return this.queryId;
    }

    public String plan() {
        return this.stmt.getPlanSQL();
    }

    protected void printInfo(StringBuilder msg) {
    }

    public long time() {
        return U.currentTimeMillis() - this.beginTs;
    }

    public String queryInfo(@Nullable String additionalInfo) {
        StringBuilder msgSb = new StringBuilder();
        if (this.queryId == 0L) {
            msgSb.append(" [globalQueryId=(undefined), node=").append(this.nodeId);
        } else {
            msgSb.append(" [globalQueryId=").append(QueryUtils.globalQueryId((UUID)this.nodeId, (long)this.queryId));
        }
        if (additionalInfo != null) {
            msgSb.append(", ").append(additionalInfo);
        }
        msgSb.append(", duration=").append(this.time()).append("ms").append(", type=").append((Object)this.type).append(", distributedJoin=").append(this.distributedJoin).append(", enforceJoinOrder=").append(this.enforceJoinOrder).append(", lazy=").append(this.lazy).append(", schema=").append(this.schema).append(", sql='").append(this.sql).append("', plan=").append(this.stmt.getPlanSQL());
        this.printInfo(msgSb);
        msgSb.append(']');
        return msgSb.toString();
    }

    public static enum QueryType {
        LOCAL,
        MAP,
        REDUCE;

    }
}

