/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BaseStatement
implements MappedStatement {
    private String id;
    private Integer resultSetType;
    private Integer fetchSize;
    private ResultMap resultMap;
    private ParameterMap parameterMap;
    private Class parameterClass;
    private Sql sql;
    private int baseCacheKey;
    private ExtendedSqlMapClient sqlMapClient;
    private Integer timeout;
    private ResultMap[] additionalResultMaps = new ResultMap[0];
    private List executeListeners = new ArrayList();
    private String resource;

    public String getId() {
        return this.id;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(Integer resultSetType) {
        this.resultSetType = resultSetType;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Sql getSql() {
        return this.sql;
    }

    public void setSql(Sql sql) {
        this.sql = sql;
    }

    public ResultMap getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(ResultMap resultMap) {
        this.resultMap = resultMap;
    }

    public ParameterMap getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Class getParameterClass() {
        return this.parameterClass;
    }

    public void setParameterClass(Class parameterClass) {
        this.parameterClass = parameterClass;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public CacheKey getCacheKey(RequestScope request, Object parameterObject) {
        Sql sql = request.getSql();
        ParameterMap pmap = sql.getParameterMap(request, parameterObject);
        CacheKey cacheKey = pmap.getCacheKey(request, parameterObject);
        cacheKey.update(this.id);
        cacheKey.update(this.baseCacheKey);
        cacheKey.update(sql.getSql(request, parameterObject));
        return cacheKey;
    }

    public void setBaseCacheKey(int base) {
        this.baseCacheKey = base;
    }

    public void addExecuteListener(ExecuteListener listener) {
        this.executeListeners.add(listener);
    }

    public void notifyListeners() {
        int n = this.executeListeners.size();
        for (int i = 0; i < n; ++i) {
            ((ExecuteListener)this.executeListeners.get(i)).onExecuteStatement(this);
        }
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlMapClient.getSqlExecutor();
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = (ExtendedSqlMapClient)sqlMapClient;
    }

    public void initRequest(RequestScope request) {
        request.setStatement(this);
        request.setParameterMap(this.parameterMap);
        request.setResultMap(this.resultMap);
        request.setSql(this.sql);
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void addResultMap(ResultMap resultMap) {
        List<ResultMap> resultMapList = Arrays.asList(this.additionalResultMaps);
        resultMapList = new ArrayList<ResultMap>(resultMapList);
        resultMapList.add(resultMap);
        this.additionalResultMaps = resultMapList.toArray(new ResultMap[resultMapList.size()]);
    }

    public boolean hasMultipleResultMaps() {
        return this.additionalResultMaps.length > 0;
    }

    public ResultMap[] getAdditionalResultMaps() {
        return this.additionalResultMaps;
    }
}

