/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.IdleConnectionEvictor;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.util.EntityUtils;
import org.junit.Test;

public class TestIdleConnectionEviction
extends LocalServerTestBase {
    @Test
    public void testIdleConnectionEviction() throws Exception {
        this.connManager.setDefaultMaxPerRoute(10);
        this.connManager.setMaxTotal(50);
        HttpHost target = this.start();
        IdleConnectionEvictor idleConnectionMonitor = new IdleConnectionEvictor((HttpClientConnectionManager)this.connManager, 50L, TimeUnit.MILLISECONDS);
        idleConnectionMonitor.start();
        URI requestUri = new URI("/random/1024");
        WorkerThread[] workers = new WorkerThread[5];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread(this.httpclient, target, requestUri, 200);
        }
        for (WorkerThread worker : workers) {
            worker.start();
        }
        for (WorkerThread worker : workers) {
            worker.join();
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        idleConnectionMonitor.shutdown();
    }

    static class WorkerThread
    extends Thread {
        private final CloseableHttpClient httpclient;
        private final HttpHost target;
        private final URI requestUri;
        private final int count;
        private volatile Exception ex;

        public WorkerThread(CloseableHttpClient httpclient, HttpHost target, URI requestUri, int count) {
            this.httpclient = httpclient;
            this.target = target;
            this.requestUri = requestUri;
            this.count = count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (int i = 0; i < this.count; ++i) {
                    HttpGet httpget = new HttpGet(this.requestUri);
                    CloseableHttpResponse response = this.httpclient.execute(this.target, (HttpRequest)httpget);
                    try {
                        int status = response.getStatusLine().getStatusCode();
                        if (status != 200) {
                            throw new ClientProtocolException("Unexpected status code: " + status);
                        }
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        Thread.sleep(10L);
                        continue;
                    }
                    finally {
                        response.close();
                    }
                }
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

