/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.LlapSliderUtils;
import org.apache.hadoop.hive.llap.cli.LlapStatusOptionsProcessor;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.hive.llap.registry.ServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.client.SliderClient;
import org.apache.slider.core.exceptions.SliderException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapStatusServiceDriver {
    private static final Logger LOG = LoggerFactory.getLogger(LlapStatusServiceDriver.class);
    private static final String CONF_PREFIX = "hive.llapcli.";
    @InterfaceAudience.Private
    private static final String CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS = "hive.llapcli.yarn.rm.connect.max-wait-ms";
    private static final long CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS_DEFAULT = 10000L;
    @InterfaceAudience.Private
    private static final String CONFIG_YARN_RM_RETRY_INTERVAL_MS = "hive.llapcli.yarn.rm.connect.retry-interval.ms";
    private static final long CONFIG_YARN_RM_RETRY_INTERVAL_MS_DEFAULT = 5000L;
    @InterfaceAudience.Private
    private static final String CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES = "hive.llapcli.ipc.client.max-retries";
    private static final int CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES_DEFAULT = 2;
    @InterfaceAudience.Private
    private static final String CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS = "hive.llapcli.ipc.client.connect.retry-interval-ms";
    private static final long CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS_DEFAULT = 1500L;
    @InterfaceAudience.Private
    private static final String CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC = "hive.llapcli.timeline.service.fs-store.retry.policy.spec";
    private static final String CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC_DEFAULT = "2000, 1";
    private static final String CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS = "hive.llapcli.zk-registry.timeout-ms";
    private static final long CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS_DEFAULT = 20000L;
    private static final String LLAP_KEY = "LLAP";
    private final Configuration conf;
    private final Clock clock = new SystemClock();
    private String appName = null;
    private SliderClient sliderClient = null;
    private Configuration llapRegistryConf = null;
    private LlapRegistryService llapRegistry = null;
    @VisibleForTesting
    AppStatusBuilder appStatusBuilder;

    public LlapStatusServiceDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new HiveConf(SessionState.class);
        this.setupConf();
    }

    private void setupConf() {
        for (String f : LlapDaemonConfiguration.DAEMON_CONFIGS) {
            this.conf.addResource(f);
        }
        this.conf.reloadConfiguration();
        this.conf.set("yarn.timeline-service.entity-group-fs-store.retry-policy-spec", this.conf.get(CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC, CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC_DEFAULT));
        this.conf.setLong("yarn.resourcemanager.connect.max-wait.ms", this.conf.getLong(CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS, 10000L));
        this.conf.setLong("yarn.resourcemanager.connect.retry-interval.ms", this.conf.getLong(CONFIG_YARN_RM_RETRY_INTERVAL_MS, 5000L));
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt(CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES, 2));
        this.conf.setLong("ipc.client.connect.retry.interval", this.conf.getLong(CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS, 1500L));
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, (String)(this.conf.getLong(CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS, 20000L) + "ms"));
        this.llapRegistryConf = new Configuration(this.conf);
    }

    public LlapStatusOptionsProcessor.LlapStatusOptions parseOptions(String[] args) throws LlapStatusCliException {
        LlapStatusOptionsProcessor optionsProcessor = new LlapStatusOptionsProcessor();
        try {
            LlapStatusOptionsProcessor.LlapStatusOptions options = optionsProcessor.processOptions(args);
            return options;
        }
        catch (Exception e) {
            LOG.info("Failed to parse arguments", (Throwable)e);
            throw new LlapStatusCliException(ExitCode.INCORRECT_USAGE, "Incorrect usage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(LlapStatusOptionsProcessor.LlapStatusOptions options, long watchTimeoutMs) {
        this.appStatusBuilder = new AppStatusBuilder();
        try {
            ExitCode ret;
            ApplicationReport appReport;
            if (this.appName == null) {
                for (Map.Entry<Object, Object> props : options.getConf().entrySet()) {
                    this.conf.set((String)props.getKey(), (String)props.getValue());
                }
                this.appName = options.getName();
                if (StringUtils.isEmpty((CharSequence)this.appName)) {
                    this.appName = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
                    this.appName = this.appName.startsWith("@") && this.appName.length() > 1 ? this.appName.substring(1) : null;
                }
                if (StringUtils.isEmpty((CharSequence)this.appName)) {
                    String message = "Invalid app name. This must be setup via config or passed in as a parameter. This tool works with clusters deployed by Slider/YARN";
                    LOG.info(message);
                    int props = ExitCode.INCORRECT_USAGE.getInt();
                    return props;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using appName: {}", (Object)this.appName);
                }
                this.llapRegistryConf.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + this.appName);
            }
            try {
                this.sliderClient = this.createSliderClient();
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int props = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return props;
            }
            try {
                appReport = this.getAppReport(this.appName, this.sliderClient, options.getFindAppTimeoutMs());
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            try {
                ret = this.processAppReport(appReport, this.appStatusBuilder);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            if (ret != ExitCode.SUCCESS) {
                int e = ret.getInt();
                return e;
            }
            if (EnumSet.of(State.APP_NOT_FOUND, State.COMPLETE, State.LAUNCHING).contains((Object)this.appStatusBuilder.getState())) {
                int e = ExitCode.SUCCESS.getInt();
                return e;
            }
            try {
                ret = this.populateAppStatusFromSlider(this.appName, this.sliderClient, this.appStatusBuilder);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            if (ret != ExitCode.SUCCESS) {
                int e = ret.getInt();
                return e;
            }
            try {
                ret = this.populateAppStatusFromLlapRegistry(this.appStatusBuilder, watchTimeoutMs);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            int n = ret.getInt();
            return n;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
            }
        }
    }

    public void outputJson(PrintWriter writer) throws LlapStatusCliException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        try {
            writer.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.appStatusBuilder));
        }
        catch (IOException e) {
            LOG.warn("Failed to create JSON", (Throwable)e);
            throw new LlapStatusCliException(ExitCode.LLAP_JSON_GENERATION_ERROR, "Failed to create JSON", e);
        }
    }

    private SliderClient createSliderClient() throws LlapStatusCliException {
        if (this.sliderClient != null) {
            return this.sliderClient;
        }
        try {
            this.sliderClient = LlapSliderUtils.createSliderClient(this.conf);
        }
        catch (Exception e) {
            throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_CREATE_FAILED, "Failed to create slider client", e);
        }
        return this.sliderClient;
    }

    private ApplicationReport getAppReport(String appName, SliderClient sliderClient, long timeoutMs) throws LlapStatusCliException {
        long startTime = this.clock.getTime();
        long timeoutTime = timeoutMs < 0L ? Long.MAX_VALUE : startTime + timeoutMs;
        ApplicationReport appReport = null;
        while (appReport == null) {
            try {
                appReport = sliderClient.getYarnAppListClient().findInstance(appName);
                if (timeoutMs == 0L) break;
                if (appReport != null) continue;
                long remainingTime = Math.min(timeoutTime - this.clock.getTime(), 500L);
                if (remainingTime <= 0L) break;
                Thread.sleep(remainingTime);
            }
            catch (Exception e) {
                throw new LlapStatusCliException(ExitCode.YARN_ERROR, "Failed to get Yarn AppReport", e);
            }
        }
        return appReport;
    }

    private ExitCode processAppReport(ApplicationReport appReport, AppStatusBuilder appStatusBuilder) throws LlapStatusCliException {
        if (appReport == null) {
            appStatusBuilder.setState(State.APP_NOT_FOUND);
            LOG.info("No Application Found");
            return ExitCode.SUCCESS;
        }
        appStatusBuilder.setAmInfo(new AmInfo().setAppName(appReport.getName()).setAppType(appReport.getApplicationType()));
        appStatusBuilder.setAppStartTime(appReport.getStartTime());
        switch (appReport.getYarnApplicationState()) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: {
                appStatusBuilder.setState(State.LAUNCHING);
                return ExitCode.SUCCESS;
            }
            case ACCEPTED: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                appStatusBuilder.setState(State.LAUNCHING);
                return ExitCode.SUCCESS;
            }
            case RUNNING: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                return ExitCode.SUCCESS;
            }
            case FINISHED: 
            case FAILED: 
            case KILLED: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                appStatusBuilder.setAppFinishTime(appReport.getFinishTime());
                appStatusBuilder.setState(State.COMPLETE);
                return ExitCode.SUCCESS;
            }
        }
        throw new LlapStatusCliException(ExitCode.INTERNAL_ERROR, "Unknown Yarn Application State: " + appReport.getYarnApplicationState());
    }

    private ExitCode populateAppStatusFromSlider(String appName, SliderClient sliderClient, AppStatusBuilder appStatusBuilder) throws LlapStatusCliException {
        Map liveEntity;
        Map llapEntity;
        Object liveObject;
        Map llapStats;
        ClusterDescription clusterDescription;
        try {
            clusterDescription = sliderClient.getClusterDescription(appName);
        }
        catch (SliderException e) {
            throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_OTHER, "Failed to get cluster description from slider. SliderErrorCode=" + e.getExitCode(), e);
        }
        catch (Exception e) {
            throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_OTHER, "Failed to get cluster description from slider", e);
        }
        if (clusterDescription == null) {
            LOG.info("Slider ClusterDescription not available");
            return ExitCode.SLIDER_CLIENT_ERROR_OTHER;
        }
        appStatusBuilder.setOriginalConfigurationPath(clusterDescription.originConfigurationPath);
        appStatusBuilder.setGeneratedConfigurationPath(clusterDescription.generatedConfigurationPath);
        appStatusBuilder.setAppStartTime(clusterDescription.createTime);
        appStatusBuilder.maybeCreateAndGetAmInfo().setAmWebUrl(clusterDescription.getInfo("info.am.web.url"));
        appStatusBuilder.maybeCreateAndGetAmInfo().setHostname(clusterDescription.getInfo("info.am.hostname"));
        appStatusBuilder.maybeCreateAndGetAmInfo().setContainerId(clusterDescription.getInfo("info.am.container.id"));
        if (clusterDescription.statistics != null) {
            llapStats = (Map)clusterDescription.statistics.get(LLAP_KEY);
            if (llapStats == null) {
                throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_OTHER, "Failed to get statistics for LLAP");
            }
        } else {
            throw new LlapStatusCliException(ExitCode.SLIDER_CLIENT_ERROR_OTHER, "Failed to get statistics");
        }
        int desiredContainers = (Integer)llapStats.get("containers.desired");
        int liveContainers = (Integer)llapStats.get("containers.live");
        appStatusBuilder.setDesiredInstances(desiredContainers);
        appStatusBuilder.setLiveInstances(liveContainers);
        if (clusterDescription.status != null && (liveObject = clusterDescription.status.get("live")) != null && (llapEntity = (Map)(liveEntity = (Map)liveObject).get(LLAP_KEY)) != null) {
            for (Map.Entry containerEntry : llapEntity.entrySet()) {
                String containerIdString = (String)containerEntry.getKey();
                Map containerParams = (Map)containerEntry.getValue();
                String host = (String)containerParams.get("host");
                LlapInstance llapInstance = new LlapInstance(host, containerIdString);
                appStatusBuilder.addNewLlapInstance(llapInstance);
            }
        }
        return ExitCode.SUCCESS;
    }

    private ExitCode populateAppStatusFromLlapRegistry(AppStatusBuilder appStatusBuilder, long watchTimeoutMs) throws LlapStatusCliException {
        Collection serviceInstances;
        if (this.llapRegistry == null) {
            try {
                this.llapRegistry = LlapRegistryService.getClient((Configuration)this.llapRegistryConf);
            }
            catch (Exception e) {
                throw new LlapStatusCliException(ExitCode.LLAP_REGISTRY_ERROR, "Failed to create llap registry client", e);
            }
        }
        try {
            serviceInstances = this.llapRegistry.getInstances(watchTimeoutMs).getAll();
        }
        catch (Exception e) {
            throw new LlapStatusCliException(ExitCode.LLAP_REGISTRY_ERROR, "Failed to get instances from llap registry", e);
        }
        if (serviceInstances == null || serviceInstances.isEmpty()) {
            LOG.info("No information found in the LLAP registry");
            appStatusBuilder.setLiveInstances(0);
            appStatusBuilder.setState(State.LAUNCHING);
            appStatusBuilder.clearLlapInstances();
            return ExitCode.SUCCESS;
        }
        LinkedList<LlapInstance> validatedInstances = new LinkedList<LlapInstance>();
        LinkedList<String> llapExtraInstances = new LinkedList<String>();
        for (ServiceInstance serviceInstance : serviceInstances) {
            String containerIdString = (String)serviceInstance.getProperties().get(HiveConf.ConfVars.LLAP_DAEMON_CONTAINER_ID.varname);
            LlapInstance llapInstance = appStatusBuilder.removeAndgetLlapInstanceForContainer(containerIdString);
            if (llapInstance != null) {
                llapInstance.setMgmtPort(serviceInstance.getManagementPort());
                llapInstance.setRpcPort(serviceInstance.getRpcPort());
                llapInstance.setShufflePort(serviceInstance.getShufflePort());
                llapInstance.setWebUrl(serviceInstance.getServicesAddress());
                llapInstance.setStatusUrl(serviceInstance.getServicesAddress() + "/status");
                validatedInstances.add(llapInstance);
                continue;
            }
            llapExtraInstances.add(containerIdString);
        }
        appStatusBuilder.setLiveInstances(validatedInstances.size());
        if (validatedInstances.size() >= appStatusBuilder.getDesiredInstances()) {
            appStatusBuilder.setState(State.RUNNING_ALL);
            if (validatedInstances.size() > appStatusBuilder.getDesiredInstances()) {
                LOG.warn("Found more entries in LLAP registry, as compared to desired entries");
            }
        } else if (validatedInstances.size() > 0) {
            appStatusBuilder.setState(State.RUNNING_PARTIAL);
        } else {
            appStatusBuilder.setState(State.LAUNCHING);
        }
        if (appStatusBuilder.allInstances().size() > 0) {
            LOG.debug("Potential instances starting up: {}", appStatusBuilder.allInstances());
        }
        if (llapExtraInstances.size() > 0) {
            LOG.debug("Instances likely to shutdown soon: {}", llapExtraInstances);
        }
        appStatusBuilder.clearAndAddPreviouslyKnownInstances(validatedInstances);
        return ExitCode.SUCCESS;
    }

    private static void logError(Throwable t) {
        LOG.error("FAILED: " + t.getMessage(), t);
        System.err.println("FAILED: " + t.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        LOG.info("LLAP status invoked with arguments = {}", (Object)Arrays.toString(args));
        int ret = ExitCode.SUCCESS.getInt();
        LlapStatusServiceDriver statusServiceDriver = null;
        LlapStatusOptionsProcessor.LlapStatusOptions options = null;
        try {
            statusServiceDriver = new LlapStatusServiceDriver();
            options = statusServiceDriver.parseOptions(args);
        }
        catch (Throwable t) {
            statusServiceDriver.close();
            LlapStatusServiceDriver.logError(t);
            if (t instanceof LlapStatusCliException) {
                LlapStatusCliException ce = (LlapStatusCliException)t;
                ret = ce.getExitCode().getInt();
            }
            ret = ExitCode.INTERNAL_ERROR.getInt();
        }
        if (ret != 0 || options == null) {
            if (statusServiceDriver != null) {
                statusServiceDriver.close();
            }
            System.exit(ret);
        }
        long refreshInterval = options.getRefreshIntervalMs();
        boolean watchMode = options.isWatchMode();
        long watchTimeout = options.getWatchTimeoutMs();
        long numAttempts = watchTimeout / refreshInterval;
        State launchingState = null;
        State currentState = null;
        boolean desiredStateAttained = false;
        float runningNodesThreshold = options.getRunningNodesThreshold();
        try (FilterOutputStream os = options.getOutputFile() == null ? System.out : new BufferedOutputStream(new FileOutputStream(options.getOutputFile()));
             PrintWriter pw = new PrintWriter(os);){
            LOG.info("Configured refresh interval: {}s. Watch timeout: {}s. Attempts remaining: {}. Watch mode: {}. Running nodes threshold: {}.", new Object[]{TimeUnit.SECONDS.convert(refreshInterval, TimeUnit.MILLISECONDS), TimeUnit.SECONDS.convert(watchTimeout, TimeUnit.MILLISECONDS), numAttempts, watchMode, new DecimalFormat("#.###").format(runningNodesThreshold)});
            while (numAttempts > 0L) {
                try {
                    ret = statusServiceDriver.run(options, watchMode ? watchTimeout : 0L);
                    if (ret == ExitCode.SUCCESS.getInt()) {
                        if (!watchMode) break;
                        currentState = statusServiceDriver.appStatusBuilder.state;
                        if (launchingState == null && (currentState.equals((Object)State.LAUNCHING) || currentState.equals((Object)State.RUNNING_PARTIAL))) {
                            launchingState = currentState;
                        }
                        if (launchingState != null && currentState.equals((Object)State.COMPLETE)) {
                            LOG.warn("Application stopped while launching. COMPLETE state reached while waiting for RUNNING state. Failing fast..");
                            break;
                        }
                        if (!currentState.equals((Object)State.RUNNING_PARTIAL) && !currentState.equals((Object)State.RUNNING_ALL)) {
                            LOG.warn("Current state: {}. Desired state: {}. {}/{} instances.", new Object[]{currentState, runningNodesThreshold == 1.0f ? State.RUNNING_ALL : State.RUNNING_PARTIAL, statusServiceDriver.appStatusBuilder.getLiveInstances(), statusServiceDriver.appStatusBuilder.getDesiredInstances()});
                            --numAttempts;
                            continue;
                        }
                        int liveInstances = statusServiceDriver.appStatusBuilder.getLiveInstances();
                        int desiredInstances = statusServiceDriver.appStatusBuilder.getDesiredInstances();
                        if (desiredInstances > 0) {
                            float ratio = (float)liveInstances / (float)desiredInstances;
                            if (ratio < runningNodesThreshold) {
                                LOG.warn("Waiting until running nodes threshold is reached. Current: {} Desired: {}. {}/{} instances.", new Object[]{new DecimalFormat("#.###").format(ratio), new DecimalFormat("#.###").format(runningNodesThreshold), statusServiceDriver.appStatusBuilder.getLiveInstances(), statusServiceDriver.appStatusBuilder.getDesiredInstances()});
                                --numAttempts;
                                continue;
                            }
                        } else {
                            --numAttempts;
                            continue;
                        }
                        desiredStateAttained = true;
                        statusServiceDriver.appStatusBuilder.setRunningThresholdAchieved(true);
                        break;
                    }
                    if (ret == ExitCode.YARN_ERROR.getInt() && watchMode) {
                        LOG.warn("Watch mode enabled and got YARN error. Retrying..");
                        --numAttempts;
                        continue;
                    }
                    if (ret == ExitCode.SLIDER_CLIENT_ERROR_CREATE_FAILED.getInt() && watchMode) {
                        LOG.warn("Watch mode enabled and slider client creation failed. Retrying..");
                        --numAttempts;
                        continue;
                    }
                    if (ret == ExitCode.SLIDER_CLIENT_ERROR_OTHER.getInt() && watchMode) {
                        LOG.warn("Watch mode enabled and got slider client error. Retrying..");
                        --numAttempts;
                        continue;
                    }
                    if (ret != ExitCode.LLAP_REGISTRY_ERROR.getInt() || !watchMode) break;
                    LOG.warn("Watch mode enabled and got LLAP registry error. Retrying..");
                    --numAttempts;
                }
                finally {
                    if (!watchMode) continue;
                    try {
                        Thread.sleep(refreshInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            statusServiceDriver.outputJson(pw);
            ((OutputStream)os).flush();
            pw.flush();
            if (numAttempts == 0L && watchMode && !desiredStateAttained) {
                LOG.warn("Watch timeout {}s exhausted before desired state RUNNING is attained.", (Object)TimeUnit.SECONDS.convert(watchTimeout, TimeUnit.MILLISECONDS));
            }
        }
        catch (Throwable t) {
            LlapStatusServiceDriver.logError(t);
            if (t instanceof LlapStatusCliException) {
                LlapStatusCliException ce = (LlapStatusCliException)t;
                ret = ce.getExitCode().getInt();
            } else {
                ret = ExitCode.INTERNAL_ERROR.getInt();
            }
        }
        finally {
            LOG.info("LLAP status finished");
            statusServiceDriver.close();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed processing - exiting with " + ret);
        }
        System.exit(ret);
    }

    private void close() {
        if (this.sliderClient != null) {
            this.sliderClient.stop();
        }
        if (this.llapRegistry != null) {
            this.llapRegistry.stop();
        }
    }

    public static enum ExitCode {
        SUCCESS(0),
        INCORRECT_USAGE(10),
        YARN_ERROR(20),
        SLIDER_CLIENT_ERROR_CREATE_FAILED(30),
        SLIDER_CLIENT_ERROR_OTHER(31),
        LLAP_REGISTRY_ERROR(40),
        LLAP_JSON_GENERATION_ERROR(50),
        INTERNAL_ERROR(100);

        private final int exitCode;

        private ExitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getInt() {
            return this.exitCode;
        }
    }

    static enum State {
        APP_NOT_FOUND,
        LAUNCHING,
        RUNNING_PARTIAL,
        RUNNING_ALL,
        COMPLETE,
        UNKNOWN;

    }

    static class LlapStatusCliException
    extends Exception {
        final ExitCode exitCode;

        public LlapStatusCliException(ExitCode exitCode, String message) {
            super(exitCode.getInt() + ": " + message);
            this.exitCode = exitCode;
        }

        public LlapStatusCliException(ExitCode exitCode, String message, Throwable cause) {
            super(message, cause);
            this.exitCode = exitCode;
        }

        public ExitCode getExitCode() {
            return this.exitCode;
        }
    }

    static class LlapInstance {
        private final String hostname;
        private final String containerId;
        private String statusUrl;
        private String webUrl;
        private Integer rpcPort;
        private Integer mgmtPort;
        private Integer shufflePort;

        public LlapInstance(String hostname, String containerId) {
            this.hostname = hostname;
            this.containerId = containerId;
        }

        public LlapInstance setWebUrl(String webUrl) {
            this.webUrl = webUrl;
            return this;
        }

        public LlapInstance setStatusUrl(String statusUrl) {
            this.statusUrl = statusUrl;
            return this;
        }

        public LlapInstance setRpcPort(int rpcPort) {
            this.rpcPort = rpcPort;
            return this;
        }

        public LlapInstance setMgmtPort(int mgmtPort) {
            this.mgmtPort = mgmtPort;
            return this;
        }

        public LlapInstance setShufflePort(int shufflePort) {
            this.shufflePort = shufflePort;
            return this;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getStatusUrl() {
            return this.statusUrl;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public Integer getRpcPort() {
            return this.rpcPort;
        }

        public Integer getMgmtPort() {
            return this.mgmtPort;
        }

        public Integer getShufflePort() {
            return this.shufflePort;
        }

        public String toString() {
            return "LlapInstance{hostname='" + this.hostname + '\'' + ", containerId='" + this.containerId + '\'' + ", statusUrl='" + this.statusUrl + '\'' + ", webUrl='" + this.webUrl + '\'' + ", rpcPort=" + this.rpcPort + ", mgmtPort=" + this.mgmtPort + ", shufflePort=" + this.shufflePort + '}';
        }
    }

    static class AmInfo {
        private String appName;
        private String appType;
        private String appId;
        private String containerId;
        private String hostname;
        private String amWebUrl;

        AmInfo() {
        }

        public AmInfo setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public AmInfo setAppType(String appType) {
            this.appType = appType;
            return this;
        }

        public AmInfo setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public AmInfo setContainerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public AmInfo setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public AmInfo setAmWebUrl(String amWebUrl) {
            this.amWebUrl = amWebUrl;
            return this;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getAppType() {
            return this.appType;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getAmWebUrl() {
            return this.amWebUrl;
        }

        public String toString() {
            return "AmInfo{appName='" + this.appName + '\'' + ", appType='" + this.appType + '\'' + ", appId='" + this.appId + '\'' + ", containerId='" + this.containerId + '\'' + ", hostname='" + this.hostname + '\'' + ", amWebUrl='" + this.amWebUrl + '\'' + '}';
        }
    }

    static final class AppStatusBuilder {
        private AmInfo amInfo;
        private State state = State.UNKNOWN;
        private String originalConfigurationPath;
        private String generatedConfigurationPath;
        private int desiredInstances = -1;
        private int liveInstances = -1;
        private Long appStartTime;
        private Long appFinishTime;
        private boolean runningThresholdAchieved = false;
        private final List<LlapInstance> llapInstances = new LinkedList<LlapInstance>();
        private transient Map<String, LlapInstance> containerToInstanceMap = new HashMap<String, LlapInstance>();

        AppStatusBuilder() {
        }

        public void setAmInfo(AmInfo amInfo) {
            this.amInfo = amInfo;
        }

        public AppStatusBuilder setState(State state) {
            this.state = state;
            return this;
        }

        public AppStatusBuilder setOriginalConfigurationPath(String originalConfigurationPath) {
            this.originalConfigurationPath = originalConfigurationPath;
            return this;
        }

        public AppStatusBuilder setGeneratedConfigurationPath(String generatedConfigurationPath) {
            this.generatedConfigurationPath = generatedConfigurationPath;
            return this;
        }

        public AppStatusBuilder setAppStartTime(long appStartTime) {
            this.appStartTime = appStartTime;
            return this;
        }

        public AppStatusBuilder setAppFinishTime(long finishTime) {
            this.appFinishTime = finishTime;
            return this;
        }

        public AppStatusBuilder setDesiredInstances(int desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public AppStatusBuilder setLiveInstances(int liveInstances) {
            this.liveInstances = liveInstances;
            return this;
        }

        public AppStatusBuilder addNewLlapInstance(LlapInstance llapInstance) {
            this.llapInstances.add(llapInstance);
            this.containerToInstanceMap.put(llapInstance.getContainerId(), llapInstance);
            return this;
        }

        public AppStatusBuilder setRunningThresholdAchieved(boolean thresholdAchieved) {
            this.runningThresholdAchieved = thresholdAchieved;
            return this;
        }

        public LlapInstance removeAndgetLlapInstanceForContainer(String containerIdString) {
            return this.containerToInstanceMap.remove(containerIdString);
        }

        public void clearLlapInstances() {
            this.llapInstances.clear();
            this.containerToInstanceMap.clear();
        }

        public AppStatusBuilder clearAndAddPreviouslyKnownInstances(List<LlapInstance> llapInstances) {
            this.clearLlapInstances();
            for (LlapInstance llapInstance : llapInstances) {
                this.addNewLlapInstance(llapInstance);
            }
            return this;
        }

        @JsonIgnore
        public List<LlapInstance> allInstances() {
            return this.llapInstances;
        }

        public AmInfo getAmInfo() {
            return this.amInfo;
        }

        public State getState() {
            return this.state;
        }

        public String getOriginalConfigurationPath() {
            return this.originalConfigurationPath;
        }

        public String getGeneratedConfigurationPath() {
            return this.generatedConfigurationPath;
        }

        public int getDesiredInstances() {
            return this.desiredInstances;
        }

        public int getLiveInstances() {
            return this.liveInstances;
        }

        public Long getAppStartTime() {
            return this.appStartTime;
        }

        public Long getAppFinishTime() {
            return this.appFinishTime;
        }

        public List<LlapInstance> getLlapInstances() {
            return this.llapInstances;
        }

        public boolean isRunningThresholdAchieved() {
            return this.runningThresholdAchieved;
        }

        @JsonIgnore
        public AmInfo maybeCreateAndGetAmInfo() {
            if (this.amInfo == null) {
                this.amInfo = new AmInfo();
            }
            return this.amInfo;
        }

        public String toString() {
            return "AppStatusBuilder{amInfo=" + this.amInfo + ", state=" + (Object)((Object)this.state) + ", originalConfigurationPath='" + this.originalConfigurationPath + '\'' + ", generatedConfigurationPath='" + this.generatedConfigurationPath + '\'' + ", desiredInstances=" + this.desiredInstances + ", liveInstances=" + this.liveInstances + ", appStartTime=" + this.appStartTime + ", appFinishTime=" + this.appFinishTime + ", llapInstances=" + this.llapInstances + ", containerToInstanceMap=" + this.containerToInstanceMap + '}';
        }
    }
}

