/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.functions.BuiltinFunctions;

public class FunctionDatetime
extends BuiltinFunctions {
    public FunctionDatetime(Exec e, QueryExecutor queryExecutor) {
        super(e, queryExecutor);
    }

    @Override
    public void register(BuiltinFunctions f) {
        f.map.put("DATE", this::date);
        f.map.put("FROM_UNIXTIME", this::fromUnixtime);
        f.map.put("NOW", ctx -> this.now(ctx));
        f.map.put("TIMESTAMP_ISO", this::timestampIso);
        f.map.put("TO_TIMESTAMP", this::toTimestamp);
        f.map.put("UNIX_TIMESTAMP", this::unixTimestamp);
        f.map.put("CURRENT_TIME_MILLIS", this::currentTimeMillis);
        f.specMap.put("CURRENT_DATE", this::currentDate);
        f.specMap.put("CURRENT_TIMESTAMP", this::currentTimestamp);
        f.specMap.put("SYSDATE", this::currentTimestamp);
        f.specSqlMap.put("CURRENT_DATE", this::currentDateSql);
        f.specSqlMap.put("CURRENT_TIMESTAMP", this::currentTimestampSql);
    }

    private static DateTimeFormatter createDateTimeFormatter(String format) {
        return DateTimeFormatter.ofPattern(format).withZone(TimeZone.getTimeZone("UTC").toZoneId()).withResolverStyle(ResolverStyle.STRICT);
    }

    public void currentDate(HplsqlParser.Expr_spec_funcContext ctx) {
        this.evalVar(FunctionDatetime.currentDate());
    }

    public static Var currentDate() {
        DateTimeFormatter formatter = FunctionDatetime.createDateTimeFormatter("yyyy-MM-dd");
        String date = formatter.format(new Date(System.currentTimeMillis()).toLocalDate());
        return new Var(Var.Type.DATE, Utils.toDate(date));
    }

    public void currentDateSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.exec.getConnectionType() == Conn.Type.HIVE) {
            this.evalSqlString("TO_DATE(FROM_UNIXTIME(UNIX_TIMESTAMP()))");
        } else {
            this.evalSqlString(Exec.getFormattedText(ctx));
        }
    }

    public void currentTimestamp(HplsqlParser.Expr_spec_funcContext ctx) {
        int precision = this.evalPop(ctx.expr(0), 3).intValue();
        this.evalVar(FunctionDatetime.currentTimestamp(precision));
    }

    public static Var currentTimestamp(int precision) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (precision > 0 && precision <= 3) {
            format = format + "." + StringUtils.repeat((String)"S", (int)precision);
        }
        DateTimeFormatter formatter = FunctionDatetime.createDateTimeFormatter(format);
        String timestamp = formatter.format(new Timestamp(System.currentTimeMillis()).toLocalDateTime());
        return new Var(Utils.toTimestamp(timestamp), precision);
    }

    public void currentTimestampSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.exec.getConnectionType() == Conn.Type.HIVE) {
            this.evalSqlString("FROM_UNIXTIME(UNIX_TIMESTAMP())");
        } else {
            this.evalSqlString(Exec.getFormattedText(ctx));
        }
    }

    void date(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        Var var = new Var(Var.Type.DATE);
        Var date = this.evalPop(ctx.func_param(0).expr());
        date.setValue(Utils.unquoteString(date.toString()));
        var.cast(date);
        this.evalVar(var);
    }

    void now(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx != null) {
            this.evalNull();
            return;
        }
        this.evalVar(FunctionDatetime.currentTimestamp(3));
    }

    void timestampIso(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        Var var = new Var(Var.Type.TIMESTAMP);
        Var val = this.evalPop(ctx.func_param(0).expr());
        val.setValue(Utils.unquoteString(val.toString()));
        var.cast(val);
        this.evalVar(var);
    }

    void toTimestamp(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 2) {
            this.evalNull();
            return;
        }
        String value = Utils.unquoteString(this.evalPop(ctx.func_param(0).expr()).toString());
        String sqlFormat = Utils.unquoteString(this.evalPop(ctx.func_param(1).expr()).toString());
        String format = Utils.convertSqlDatetimeFormat(sqlFormat);
        try {
            DateTimeFormatter formatter = FunctionDatetime.createDateTimeFormatter(format);
            LocalDateTime val = null;
            val = format.length() > 10 ? LocalDateTime.parse(value, formatter) : LocalDate.parse(value, formatter).atStartOfDay();
            this.evalVar(new Var(Var.Type.TIMESTAMP, Timestamp.valueOf(val)));
        }
        catch (Exception e) {
            this.exec.signal(e);
            this.evalNull();
        }
    }

    void fromUnixtime(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = BuiltinFunctions.getParamCount(ctx);
        if (cnt == 0) {
            this.evalNull();
            return;
        }
        Var value = this.evalPop(ctx.func_param(0).expr());
        if (value.type != Var.Type.BIGINT) {
            Var newVar = new Var(Var.Type.BIGINT);
            value = newVar.cast(value);
        }
        long epoch = value.longValue();
        String format = "yyyy-MM-dd HH:mm:ss";
        if (cnt > 1) {
            format = Utils.unquoteString(this.evalPop(ctx.func_param(1).expr()).toString());
        }
        DateTimeFormatter formatter = FunctionDatetime.createDateTimeFormatter(format);
        this.evalString(formatter.format(new Date(epoch * 1000L).toLocalDate()));
    }

    void unixTimestamp(HplsqlParser.Expr_func_paramsContext ctx) {
        this.evalVar(new Var(System.currentTimeMillis() / 1000L));
    }

    public void currentTimeMillis(HplsqlParser.Expr_func_paramsContext ctx) {
        this.evalVar(new Var(System.currentTimeMillis()));
    }
}

