/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.text.DecimalFormat;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="format_number", value="_FUNC_(X, D or F) - Formats the number X to a format like '#,###,###.##', rounded to D decimal places, Or Uses the format specified F to format, and returns the result as a string. If D is 0, the result has no decimal point or fractional part. This is supposed to function like MySQL's FORMAT", extended="Example:\n  > SELECT _FUNC_(12332.123456, 4) FROM src LIMIT 1;\n  '12,332.1235'\n  > SELECT _FUNC_(12332.123456, '##################.###') FROM src LIMIT 1;\n  '12332.123'")
public class GenericUDFFormatNumber
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private final transient Text resultText = new Text();
    private final transient StringBuilder pattern = new StringBuilder("");
    private final transient DecimalFormat numberFormat = new DecimalFormat("");
    private transient int lastDValue = -1;
    private transient PrimitiveObjectInspector.PrimitiveCategory dType;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function FORMAT_NUMBER(X, D or F) needs two arguments.");
        }
        switch (arguments[0].getCategory()) {
            case PRIMITIVE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Argument 1 of function FORMAT_NUMBER must be \"tinyint\" or \"smallint\" or \"int\" or \"bigint\" or \"double\" or \"float\" or \"decimal\", but \"" + arguments[0].getTypeName() + "\" was found.");
            }
        }
        switch (arguments[1].getCategory()) {
            case PRIMITIVE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(1, "Argument 2 of function FORMAT_NUMBER must be \"tinyint\" or \"smallint\" or \"int\" or \"bigint\" or \"string\", but \"" + arguments[1].getTypeName() + "\" was found.");
            }
        }
        PrimitiveObjectInspector xObjectInspector = (PrimitiveObjectInspector)arguments[0];
        PrimitiveObjectInspector dObjectInspector = (PrimitiveObjectInspector)arguments[1];
        switch (xObjectInspector.getPrimitiveCategory()) {
            case VOID: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Argument 1 of function FORMAT_NUMBER must be \"tinyint\" or \"smallint\" or \"int\" or \"bigint\" or \"double\" or \"float\" or \"decimal\", but \"" + arguments[0].getTypeName() + "\" was found.");
            }
        }
        this.dType = dObjectInspector.getPrimitiveCategory();
        switch (this.dType) {
            case VOID: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                break;
            }
            case STRING: {
                if (!(arguments[1] instanceof ConstantObjectInspector)) {
                    throw new UDFArgumentTypeException(1, "Format string passed must be a constant STRING." + arguments[1].toString());
                }
                ConstantObjectInspector constantOI = (ConstantObjectInspector)arguments[1];
                String fValue = constantOI.getWritableConstantValue().toString();
                DecimalFormat dFormat = new DecimalFormat(fValue);
                this.numberFormat.applyPattern(dFormat.toPattern());
                break;
            }
            default: {
                throw new UDFArgumentTypeException(1, "Argument 2 of function FORMAT_NUMBER must be \"tinyint\" or \"smallint\" or \"int\" or \"bigint\" or \"string\", but \"" + arguments[1].getTypeName() + "\" was found.");
            }
        }
        this.argumentOIs = arguments;
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object arg1;
        Object arg0 = arguments[0].get();
        if (arg0 == null || (arg1 = arguments[1].get()) == null) {
            return null;
        }
        if (!this.dType.equals((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING)) {
            int dValue = ((IntObjectInspector)this.argumentOIs[1]).get(arg1);
            if (dValue < 0) {
                throw new HiveException("Argument 2 of function FORMAT_NUMBER must be >= 0, but \"" + dValue + "\" was found");
            }
            if (dValue != this.lastDValue) {
                this.pattern.delete(0, this.pattern.length());
                this.pattern.append("#,###,###,###,###,###,##0");
                if (dValue > 0) {
                    this.pattern.append(".");
                    for (int i = 0; i < dValue; ++i) {
                        this.pattern.append("0");
                    }
                }
                DecimalFormat dFormat = new DecimalFormat(this.pattern.toString());
                this.lastDValue = dValue;
                this.numberFormat.applyPattern(dFormat.toPattern());
            }
        }
        double xDoubleValue = 0.0;
        float xFloatValue = 0.0f;
        HiveDecimal xDecimalValue = null;
        int xIntValue = 0;
        long xLongValue = 0L;
        PrimitiveObjectInspector xObjectInspector = (PrimitiveObjectInspector)this.argumentOIs[0];
        switch (xObjectInspector.getPrimitiveCategory()) {
            case VOID: 
            case DOUBLE: {
                xDoubleValue = ((DoubleObjectInspector)this.argumentOIs[0]).get(arg0);
                this.resultText.set(this.numberFormat.format(xDoubleValue));
                break;
            }
            case FLOAT: {
                xFloatValue = ((FloatObjectInspector)this.argumentOIs[0]).get(arg0);
                this.resultText.set(this.numberFormat.format(xFloatValue));
                break;
            }
            case DECIMAL: {
                xDecimalValue = ((HiveDecimalObjectInspector)this.argumentOIs[0]).getPrimitiveJavaObject(arg0);
                this.resultText.set(this.numberFormat.format(xDecimalValue.bigDecimalValue()));
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                xIntValue = ((IntObjectInspector)this.argumentOIs[0]).get(arg0);
                this.resultText.set(this.numberFormat.format(xIntValue));
                break;
            }
            case LONG: {
                xLongValue = ((LongObjectInspector)this.argumentOIs[0]).get(arg0);
                this.resultText.set(this.numberFormat.format(xLongValue));
                break;
            }
            default: {
                throw new HiveException("Argument 1 of function FORMAT_NUMBER must be tinyint\" or \"smallint\" or \"int\" or \"bigint\" or \"double\" or \"float\" or \"decimal\", but \"" + this.argumentOIs[0].getTypeName() + "\" was found.");
            }
        }
        return this.resultText;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return this.getStandardDisplayString("format_number", children);
    }
}

