/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.listbucketingpruner;

import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.PrunerOperatorFactory;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.LBOpPartitionWalkerCtx;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBPartitionProcFactory
extends PrunerOperatorFactory {
    static final Logger LOG = LoggerFactory.getLogger((String)ListBucketingPruner.class.getName());

    public static NodeProcessor getFilterProc() {
        return new LBPRPartitionFilterPruner();
    }

    private LBPartitionProcFactory() {
    }

    public static class LBPRPartitionFilterPruner
    extends PrunerOperatorFactory.FilterPruner {
        @Override
        protected void generatePredicate(NodeProcessorCtx procCtx, FilterOperator fop, TableScanOperator top) throws SemanticException, UDFArgumentException {
            LBOpPartitionWalkerCtx owc = (LBOpPartitionWalkerCtx)procCtx;
            Table tbl = ((TableScanDesc)top.getConf()).getTableMetadata();
            if (tbl.isPartitioned()) {
                PrunedPartitionList prunedPartList;
                ParseContext parseCtx = owc.getParseContext();
                try {
                    String alias = (String)parseCtx.getTopOps().keySet().toArray()[0];
                    prunedPartList = PartitionPruner.prune(top, parseCtx, alias);
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage(), e);
                }
                if (prunedPartList != null) {
                    owc.setPartitions(prunedPartList);
                }
            }
        }
    }
}

