/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.merge;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileKeyBufferWrapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileValueBufferWrapper;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

public class RCFileBlockMergeRecordReader
implements RecordReader<RCFileKeyBufferWrapper, RCFileValueBufferWrapper> {
    private final RCFile.Reader in;
    private final long start;
    private final long end;
    private boolean more = true;
    private final Path path;
    protected Configuration conf;

    public RCFileBlockMergeRecordReader(Configuration conf, FileSplit split) throws IOException {
        this.path = split.getPath();
        FileSystem fs = this.path.getFileSystem(conf);
        this.in = new RCFile.Reader(fs, this.path, conf);
        this.end = split.getStart() + split.getLength();
        this.conf = conf;
        if (split.getStart() > this.in.getPosition()) {
            this.in.sync(split.getStart());
        }
        this.start = this.in.getPosition();
        this.more = this.start < this.end;
    }

    public Class<?> getKeyClass() {
        return RCFileKeyBufferWrapper.class;
    }

    public Class<?> getValueClass() {
        return RCFileValueBufferWrapper.class;
    }

    public RCFileKeyBufferWrapper createKey() {
        return new RCFileKeyBufferWrapper();
    }

    public RCFileValueBufferWrapper createValue() {
        return new RCFileValueBufferWrapper();
    }

    public boolean next(RCFileKeyBufferWrapper key, RCFileValueBufferWrapper value) throws IOException {
        this.more = this.nextBlock(key, value);
        return this.more;
    }

    protected boolean nextBlock(RCFileKeyBufferWrapper keyWrapper, RCFileValueBufferWrapper valueWrapper) throws IOException {
        if (!this.more) {
            return false;
        }
        this.more = this.in.nextBlock();
        if (!this.more) {
            return false;
        }
        keyWrapper.keyBuffer = this.in.getCurrentKeyBufferObj();
        keyWrapper.recordLength = this.in.getCurrentBlockLength();
        keyWrapper.keyLength = this.in.getCurrentKeyLength();
        keyWrapper.compressedKeyLength = this.in.getCurrentCompressedKeyLen();
        keyWrapper.codec = this.in.getCompressionCodec();
        keyWrapper.inputPath = this.path;
        valueWrapper.valueBuffer = this.in.getCurrentValueBufferObj();
        long lastSeenSyncPos = this.in.lastSeenSyncPos();
        if (lastSeenSyncPos >= this.end) {
            this.more = false;
            return this.more;
        }
        return this.more;
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.getPosition() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.in.getPosition();
    }

    protected void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    public long getStart() {
        return this.start;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

