/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.com.google.common.collect.Sets;

public final class HiveJoinAddNotNullRule
extends RelOptRule {
    public static final HiveJoinAddNotNullRule INSTANCE_JOIN = new HiveJoinAddNotNullRule(HiveJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    public static final HiveJoinAddNotNullRule INSTANCE_SEMIJOIN = new HiveJoinAddNotNullRule(HiveSemiJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public HiveJoinAddNotNullRule(Class<? extends Join> clazz, RelFactories.FilterFactory filterFactory) {
        super(HiveJoinAddNotNullRule.operand(clazz, HiveJoinAddNotNullRule.any()));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode curr;
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo;
        Join join = (Join)call.rel(0);
        RelNode lChild = join.getLeft();
        RelNode rChild = join.getRight();
        HiveRulesRegistry registry = call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
        assert (registry != null);
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        try {
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join);
        }
        catch (CalciteSemanticException e) {
            return;
        }
        HashSet<Integer> joinLeftKeyPositions = new HashSet<Integer>();
        HashSet<Integer> joinRightKeyPositions = new HashSet<Integer>();
        for (int i = 0; i < joinPredInfo.getEquiJoinPredicateElements().size(); ++i) {
            HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(i);
            joinLeftKeyPositions.addAll(joinLeafPredInfo.getProjsFromLeftPartOfJoinKeysInChildSchema());
            joinRightKeyPositions.addAll(joinLeafPredInfo.getProjsFromRightPartOfJoinKeysInChildSchema());
        }
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        HashSet<String> leftPushedPredicates = Sets.newHashSet(registry.getPushedPredicates(join, 0));
        List<RexNode> newLeftConditions = HiveJoinAddNotNullRule.getNotNullConditions(cluster, rexBuilder, join.getLeft(), joinLeftKeyPositions, leftPushedPredicates);
        HashSet<String> rightPushedPredicates = Sets.newHashSet(registry.getPushedPredicates(join, 1));
        List<RexNode> newRightConditions = HiveJoinAddNotNullRule.getNotNullConditions(cluster, rexBuilder, join.getRight(), joinRightKeyPositions, rightPushedPredicates);
        RexNode newLeftPredicate = RexUtil.composeConjunction(rexBuilder, newLeftConditions, false);
        RexNode newRightPredicate = RexUtil.composeConjunction(rexBuilder, newRightConditions, false);
        if (newLeftPredicate.isAlwaysTrue() && newRightPredicate.isAlwaysTrue()) {
            return;
        }
        if (!newLeftPredicate.isAlwaysTrue()) {
            curr = lChild;
            lChild = this.filterFactory.createFilter(lChild, newLeftPredicate);
            call.getPlanner().onCopy(curr, lChild);
        }
        if (!newRightPredicate.isAlwaysTrue()) {
            curr = rChild;
            rChild = this.filterFactory.createFilter(rChild, newRightPredicate);
            call.getPlanner().onCopy(curr, rChild);
        }
        Join newJoin = join.copy(join.getTraitSet(), join.getCondition(), lChild, rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newJoin);
        registry.getPushedPredicates(newJoin, 0).addAll(leftPushedPredicates);
        registry.getPushedPredicates(newJoin, 1).addAll(rightPushedPredicates);
        call.transformTo(newJoin);
    }

    private static List<RexNode> getNotNullConditions(RelOptCluster cluster, RexBuilder rexBuilder, RelNode input, Set<Integer> inputKeyPositions, Set<String> pushedPredicates) {
        ArrayList<RexNode> newConditions = Lists.newArrayList();
        for (int pos : inputKeyPositions) {
            RelDataType keyType = input.getRowType().getFieldList().get(pos).getType();
            if (!keyType.isNullable()) continue;
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, rexBuilder.makeInputRef(input, pos));
            String digest = cond.toString();
            if (!pushedPredicates.add(digest)) continue;
            newConditions.add(cond);
        }
        return newConditions;
    }
}

