/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;

public class HiveFilterProjectTransposeRule
extends FilterProjectTransposeRule {
    public static final HiveFilterProjectTransposeRule INSTANCE_DETERMINISTIC_WINDOWING = new HiveFilterProjectTransposeRule(Filter.class, HiveProject.class, HiveRelFactories.HIVE_BUILDER, true, true);
    public static final HiveFilterProjectTransposeRule INSTANCE_DETERMINISTIC = new HiveFilterProjectTransposeRule(Filter.class, HiveProject.class, HiveRelFactories.HIVE_BUILDER, true, false);
    public static final HiveFilterProjectTransposeRule INSTANCE = new HiveFilterProjectTransposeRule(Filter.class, HiveProject.class, HiveRelFactories.HIVE_BUILDER, false, false);
    private final boolean onlyDeterministic;
    private final boolean pushThroughWindowing;

    private HiveFilterProjectTransposeRule(Class<? extends Filter> filterClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory, boolean onlyDeterministic, boolean pushThroughWindowing) {
        super(filterClass, projectClass, false, false, relBuilderFactory);
        this.onlyDeterministic = onlyDeterministic;
        this.pushThroughWindowing = pushThroughWindowing;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        RexNode condition = filterRel.getCondition();
        if (this.onlyDeterministic && !HiveCalciteUtil.isDeterministic(condition)) {
            return false;
        }
        return super.matches(call);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Project origproject = (Project)call.rel(1);
        RexNode filterCondToPushBelowProj = filter.getCondition();
        RexNode unPushedFilCondAboveProj = null;
        if (RexUtil.containsCorrelation(filterCondToPushBelowProj)) {
            return;
        }
        if (RexOver.containsOver(origproject.getProjects(), null)) {
            RexNode origFilterCond = filterCondToPushBelowProj;
            filterCondToPushBelowProj = null;
            if (this.pushThroughWindowing) {
                Set<Integer> commonPartitionKeys = HiveFilterProjectTransposeRule.getCommonPartitionCols(origproject.getProjects());
                ArrayList<RexNode> newPartKeyFilConds = new ArrayList<RexNode>();
                ArrayList<RexNode> unpushedFilConds = new ArrayList<RexNode>();
                if (!commonPartitionKeys.isEmpty()) {
                    for (RexNode ce : RelOptUtil.conjunctions(origFilterCond)) {
                        RexNode newCondition = RelOptUtil.pushPastProject(ce, origproject);
                        if (HiveCalciteUtil.isDeterministicFuncWithSingleInputRef(newCondition, commonPartitionKeys)) {
                            newPartKeyFilConds.add(newCondition);
                            continue;
                        }
                        unpushedFilConds.add(ce);
                    }
                    if (!newPartKeyFilConds.isEmpty()) {
                        filterCondToPushBelowProj = RexUtil.composeConjunction(filter.getCluster().getRexBuilder(), newPartKeyFilConds, true);
                    }
                    if (!unpushedFilConds.isEmpty()) {
                        unPushedFilCondAboveProj = RexUtil.composeConjunction(filter.getCluster().getRexBuilder(), unpushedFilConds, true);
                    }
                }
            }
        }
        if (filterCondToPushBelowProj != null) {
            RelNode newProjRel = HiveFilterProjectTransposeRule.getNewProject(filterCondToPushBelowProj, unPushedFilCondAboveProj, origproject, filter.getCluster().getTypeFactory(), call.builder());
            call.transformTo(newProjRel);
        }
    }

    private static RelNode getNewProject(RexNode filterCondToPushBelowProj, RexNode unPushedFilCondAboveProj, Project oldProj, RelDataTypeFactory typeFactory, RelBuilder relBuilder) {
        RexNode newPushedCondition = RelOptUtil.pushPastProject(filterCondToPushBelowProj, oldProj);
        if (RexUtil.isNullabilityCast(typeFactory, newPushedCondition)) {
            newPushedCondition = ((RexCall)newPushedCondition).getOperands().get(0);
        }
        RelNode newPushedFilterRel = relBuilder.push(oldProj.getInput()).filter(newPushedCondition).build();
        RelNode newProjRel = relBuilder.push(newPushedFilterRel).project(oldProj.getProjects(), oldProj.getRowType().getFieldNames()).build();
        if (unPushedFilCondAboveProj != null) {
            if (RexUtil.isNullabilityCast(typeFactory, newPushedCondition)) {
                unPushedFilCondAboveProj = ((RexCall)unPushedFilCondAboveProj).getOperands().get(0);
            }
            newProjRel = relBuilder.push(newProjRel).filter(unPushedFilCondAboveProj).build();
        }
        return newProjRel;
    }

    private static Set<Integer> getCommonPartitionCols(List<RexNode> projections) {
        boolean firstOverClause = true;
        HashSet<Integer> commonPartitionKeys = new HashSet<Integer>();
        for (RexNode expr : projections) {
            if (!(expr instanceof RexOver)) continue;
            RexOver overClause = (RexOver)expr;
            if (firstOverClause) {
                firstOverClause = false;
                commonPartitionKeys.addAll(HiveFilterProjectTransposeRule.getPartitionCols(overClause.getWindow().partitionKeys));
                continue;
            }
            commonPartitionKeys.retainAll(HiveFilterProjectTransposeRule.getPartitionCols(overClause.getWindow().partitionKeys));
        }
        return commonPartitionKeys;
    }

    private static List<Integer> getPartitionCols(List<RexNode> partitionKeys) {
        ArrayList<Integer> pCols = new ArrayList<Integer>();
        for (RexNode key : partitionKeys) {
            if (!(key instanceof RexInputRef)) continue;
            pCols.add(((RexInputRef)key).getIndex());
        }
        return pCols;
    }
}

