/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ExprNodeColumnDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String column;
    private String tabAlias;
    private boolean isPartitionColOrVirtualCol;
    private boolean isSkewedCol;
    private transient boolean isGenerated;

    public ExprNodeColumnDesc() {
    }

    public ExprNodeColumnDesc(ColumnInfo ci) {
        this(ci, false);
    }

    public ExprNodeColumnDesc(ColumnInfo ci, boolean isGenerated) {
        this(ci.getType(), ci.getInternalName(), ci.getTabAlias(), ci.getIsVirtualCol(), false, isGenerated);
    }

    public ExprNodeColumnDesc(TypeInfo typeInfo, String column, String tabAlias, boolean isPartitionColOrVirtualCol) {
        this(typeInfo, column, tabAlias, isPartitionColOrVirtualCol, false, false);
    }

    public ExprNodeColumnDesc(Class<?> c, String column, String tabAlias, boolean isPartitionColOrVirtualCol) {
        this(TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(c), column, tabAlias, isPartitionColOrVirtualCol, false, false);
    }

    public ExprNodeColumnDesc(TypeInfo typeInfo, String column, String tabAlias, boolean isPartitionColOrVirtualCol, boolean isSkewedCol) {
        this(typeInfo, column, tabAlias, isPartitionColOrVirtualCol, isSkewedCol, false);
    }

    public ExprNodeColumnDesc(TypeInfo typeInfo, String column, String tabAlias, boolean isPartitionColOrVirtualCol, boolean isSkewedCol, boolean isGenerated) {
        super(typeInfo);
        this.column = column;
        this.tabAlias = tabAlias;
        this.isPartitionColOrVirtualCol = isPartitionColOrVirtualCol;
        this.isSkewedCol = isSkewedCol;
        this.isGenerated = isGenerated;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getTabAlias() {
        return this.tabAlias;
    }

    public void setTabAlias(String tabAlias) {
        this.tabAlias = tabAlias;
    }

    public boolean getIsPartitionColOrVirtualCol() {
        return this.isPartitionColOrVirtualCol;
    }

    public void setIsPartitionColOrVirtualCol(boolean isPartitionCol) {
        this.isPartitionColOrVirtualCol = isPartitionCol;
    }

    public boolean getIsGenerated() {
        return this.isGenerated;
    }

    public void setIsGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    public String toString() {
        return "Column[" + this.column + "]";
    }

    @Override
    public String getExprString() {
        return this.getColumn();
    }

    @Override
    public List<String> getCols() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(this.column);
        return lst;
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeColumnDesc(this.typeInfo, this.column, this.tabAlias, this.isPartitionColOrVirtualCol, this.isSkewedCol);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeColumnDesc)) {
            return false;
        }
        ExprNodeColumnDesc dest = (ExprNodeColumnDesc)o;
        if (!this.column.equals(dest.getColumn())) {
            return false;
        }
        if (!this.typeInfo.equals(dest.getTypeInfo())) {
            return false;
        }
        return this.tabAlias == null || dest.tabAlias == null || this.tabAlias.equals(dest.tabAlias);
    }

    public boolean isSkewedCol() {
        return this.isSkewedCol;
    }

    public void setSkewedCol(boolean isSkewedCol) {
        this.isSkewedCol = isSkewedCol;
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(superHashCode);
        builder.append(this.column);
        builder.append(this.tabAlias);
        return builder.toHashCode();
    }
}

