/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;

public class HiveFilterProjectTSTransposeRule
extends RelOptRule {
    public static final HiveFilterProjectTSTransposeRule INSTANCE = new HiveFilterProjectTSTransposeRule(Filter.class, HiveRelFactories.HIVE_FILTER_FACTORY, HiveProject.class, HiveRelFactories.HIVE_PROJECT_FACTORY, TableScan.class);
    public static final HiveFilterProjectTSTransposeRule INSTANCE_DRUID = new HiveFilterProjectTSTransposeRule(Filter.class, HiveRelFactories.HIVE_FILTER_FACTORY, HiveProject.class, HiveRelFactories.HIVE_PROJECT_FACTORY, DruidQuery.class);
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.ProjectFactory projectFactory;

    private HiveFilterProjectTSTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Project> projectClass, RelFactories.ProjectFactory projectFactory, Class<? extends RelNode> tsClass) {
        super(HiveFilterProjectTSTransposeRule.operand(filterClass, HiveFilterProjectTSTransposeRule.operand(projectClass, HiveFilterProjectTSTransposeRule.operand(tsClass, HiveFilterProjectTSTransposeRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
        this.projectFactory = projectFactory;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        HiveProject projRel = (HiveProject)call.rel(1);
        if (!projRel.isSynthetic()) {
            return false;
        }
        return super.matches(call);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Project project = (Project)call.rel(1);
        if (RexOver.containsOver(project.getProjects(), null)) {
            return;
        }
        if (RexUtil.containsCorrelation(filter.getCondition())) {
            return;
        }
        RexNode newCondition = RelOptUtil.pushPastProject(filter.getCondition(), project);
        RelDataTypeFactory typeFactory = filter.getCluster().getTypeFactory();
        if (RexUtil.isNullabilityCast(typeFactory, newCondition)) {
            newCondition = ((RexCall)newCondition).getOperands().get(0);
        }
        RelNode newFilterRel = this.filterFactory == null ? filter.copy(filter.getTraitSet(), project.getInput(), newCondition) : this.filterFactory.createFilter(project.getInput(), newCondition);
        RelNode newProjRel = this.projectFactory == null ? project.copy(project.getTraitSet(), newFilterRel, project.getProjects(), project.getRowType()) : this.projectFactory.createProject(newFilterRel, project.getProjects(), project.getRowType().getFieldNames());
        call.transformTo(newProjRel);
    }
}

