/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.keyseries;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerialized;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerializedImpl;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorKeySeriesMultiSerialized<T extends SerializeWrite>
extends VectorKeySeriesSerializedImpl<T>
implements VectorKeySeriesSerialized {
    private static final Logger LOG = LoggerFactory.getLogger(VectorKeySeriesMultiSerialized.class.getName());
    private VectorSerializeRow<T> keySerializeRow;
    private boolean[] hasAnyNulls;

    public VectorKeySeriesMultiSerialized(T serializeWrite) {
        super(serializeWrite);
    }

    public void init(TypeInfo[] typeInfos, int[] columnNums) throws HiveException {
        this.keySerializeRow = new VectorSerializeRow<SerializeWrite>(this.serializeWrite);
        this.keySerializeRow.init(typeInfos, columnNums);
        this.hasAnyNulls = new boolean[1024];
    }

    @Override
    public void processBatch(VectorizedRowBatch batch) throws IOException {
        this.currentBatchSize = batch.size;
        Preconditions.checkState(this.currentBatchSize > 0);
        int prevKeyStart = 0;
        int currentKeyStart = 0;
        this.output.reset();
        this.seriesCount = 0;
        this.duplicateCounts[0] = 1;
        if (batch.selectedInUse) {
            int prevKeyLength;
            boolean prevKeyIsNull;
            int[] selected = batch.selected;
            int index = selected[0];
            this.keySerializeRow.setOutputAppend(this.output);
            this.keySerializeRow.serializeWrite(batch, index);
            if (this.keySerializeRow.getIsAllNulls()) {
                prevKeyIsNull = true;
                this.seriesIsAllNull[0] = true;
                prevKeyLength = 0;
                this.output.setWritePosition(0);
                this.nonNullKeyCount = 0;
            } else {
                prevKeyIsNull = false;
                this.seriesIsAllNull[0] = false;
                currentKeyStart = prevKeyLength = this.output.getLength();
                this.serializedKeyLengths[0] = prevKeyLength;
                this.hasAnyNulls[0] = this.keySerializeRow.getHasAnyNulls();
                this.nonNullKeyCount = 1;
            }
            for (int logical = 1; logical < this.currentBatchSize; ++logical) {
                index = selected[logical];
                this.keySerializeRow.setOutputAppend(this.output);
                this.keySerializeRow.serializeWrite(batch, index);
                if (this.keySerializeRow.getIsAllNulls()) {
                    if (prevKeyIsNull) {
                        int n = this.seriesCount;
                        this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                    } else {
                        this.duplicateCounts[++this.seriesCount] = 1;
                        prevKeyIsNull = true;
                        this.seriesIsAllNull[this.seriesCount] = true;
                    }
                    this.output.setWritePosition(currentKeyStart);
                    continue;
                }
                int keyLength = this.output.getLength() - currentKeyStart;
                if (!prevKeyIsNull && StringExpr.equal(this.output.getData(), prevKeyStart, prevKeyLength, this.output.getData(), currentKeyStart, keyLength)) {
                    int n = this.seriesCount;
                    this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                    this.output.setWritePosition(currentKeyStart);
                    continue;
                }
                this.duplicateCounts[++this.seriesCount] = 1;
                prevKeyIsNull = false;
                this.seriesIsAllNull[this.seriesCount] = false;
                prevKeyStart = currentKeyStart;
                this.serializedKeyLengths[this.nonNullKeyCount] = prevKeyLength = keyLength;
                currentKeyStart += keyLength;
                this.hasAnyNulls[this.nonNullKeyCount] = this.keySerializeRow.getHasAnyNulls();
                ++this.nonNullKeyCount;
            }
            ++this.seriesCount;
            Preconditions.checkState(this.seriesCount <= this.currentBatchSize);
        } else {
            int prevKeyLength;
            boolean prevKeyIsNull;
            this.keySerializeRow.setOutputAppend(this.output);
            this.keySerializeRow.serializeWrite(batch, 0);
            if (this.keySerializeRow.getIsAllNulls()) {
                prevKeyIsNull = true;
                this.seriesIsAllNull[0] = true;
                prevKeyLength = 0;
                this.output.setWritePosition(0);
                this.nonNullKeyCount = 0;
            } else {
                prevKeyIsNull = false;
                this.seriesIsAllNull[0] = false;
                currentKeyStart = prevKeyLength = this.output.getLength();
                this.serializedKeyLengths[0] = prevKeyLength;
                this.hasAnyNulls[0] = this.keySerializeRow.getHasAnyNulls();
                this.nonNullKeyCount = 1;
            }
            for (int index = 1; index < this.currentBatchSize; ++index) {
                this.keySerializeRow.setOutputAppend(this.output);
                this.keySerializeRow.serializeWrite(batch, index);
                if (this.keySerializeRow.getIsAllNulls()) {
                    if (prevKeyIsNull) {
                        int n = this.seriesCount;
                        this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                    } else {
                        this.duplicateCounts[++this.seriesCount] = 1;
                        prevKeyIsNull = true;
                        this.seriesIsAllNull[this.seriesCount] = true;
                    }
                    this.output.setWritePosition(currentKeyStart);
                    continue;
                }
                int keyLength = this.output.getLength() - currentKeyStart;
                if (!prevKeyIsNull && StringExpr.equal(this.output.getData(), prevKeyStart, prevKeyLength, this.output.getData(), currentKeyStart, keyLength)) {
                    int n = this.seriesCount;
                    this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                    this.output.setWritePosition(currentKeyStart);
                    continue;
                }
                this.duplicateCounts[++this.seriesCount] = 1;
                prevKeyIsNull = false;
                this.seriesIsAllNull[this.seriesCount] = false;
                prevKeyStart = currentKeyStart;
                this.serializedKeyLengths[this.nonNullKeyCount] = prevKeyLength = keyLength;
                currentKeyStart += keyLength;
                this.hasAnyNulls[this.nonNullKeyCount] = this.keySerializeRow.getHasAnyNulls();
                ++this.nonNullKeyCount;
            }
            ++this.seriesCount;
            Preconditions.checkState(this.seriesCount <= this.currentBatchSize);
        }
        this.computeSerializedHashCodes();
        this.positionToFirst();
        Preconditions.checkState(this.validate());
    }

    @Override
    public void setNextNonNullKey(int nonNullKeyPosition) {
        super.setNextNonNullKey(nonNullKeyPosition);
        this.currentHasAnyNulls = this.hasAnyNulls[nonNullKeyPosition];
    }
}

