/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSort;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveGBOpConvUtil;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.WindowingComponentizer;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;

public class HiveOpConverter {
    private static final Log LOG = LogFactory.getLog(HiveOpConverter.class);
    private final SemanticAnalyzer semanticAnalyzer;
    private final HiveConf hiveConf;
    private final UnparseTranslator unparseTranslator;
    private final Map<String, Operator<? extends OperatorDesc>> topOps;
    private final boolean strictMode;

    public HiveOpConverter(SemanticAnalyzer semanticAnalyzer, HiveConf hiveConf, UnparseTranslator unparseTranslator, Map<String, Operator<? extends OperatorDesc>> topOps, boolean strictMode) {
        this.semanticAnalyzer = semanticAnalyzer;
        this.hiveConf = hiveConf;
        this.unparseTranslator = unparseTranslator;
        this.topOps = topOps;
        this.strictMode = strictMode;
    }

    public Operator convert(RelNode root) throws SemanticException {
        OpAttr opAf = this.dispatch(root);
        return (Operator)opAf.inputs.get(0);
    }

    OpAttr dispatch(RelNode rn) throws SemanticException {
        if (rn instanceof HiveTableScan) {
            return this.visit((HiveTableScan)rn);
        }
        if (rn instanceof HiveProject) {
            return this.visit((HiveProject)rn);
        }
        if (rn instanceof MultiJoin) {
            return this.visit((MultiJoin)rn);
        }
        if (rn instanceof HiveJoin) {
            return this.visit((HiveJoin)rn);
        }
        if (rn instanceof SemiJoin) {
            SemiJoin sj = (SemiJoin)rn;
            HiveJoin hj = HiveJoin.getJoin(sj.getCluster(), sj.getLeft(), sj.getRight(), sj.getCondition(), sj.getJoinType(), true);
            return this.visit(hj);
        }
        if (rn instanceof HiveFilter) {
            return this.visit((HiveFilter)rn);
        }
        if (rn instanceof HiveSort) {
            return this.visit((HiveSort)rn);
        }
        if (rn instanceof HiveUnion) {
            return this.visit((HiveUnion)rn);
        }
        if (rn instanceof HiveSortExchange) {
            return this.visit((HiveSortExchange)rn);
        }
        if (rn instanceof HiveAggregate) {
            return this.visit((HiveAggregate)rn);
        }
        LOG.error((Object)(rn.getClass().getCanonicalName() + "operator translation not supported" + " yet in return path."));
        return null;
    }

    OpAttr visit(HiveTableScan scanRel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Translating operator rel#" + scanRel.getId() + ":" + scanRel.getRelTypeName() + " with row type: [" + scanRel.getRowType() + "]"));
        }
        RelOptHiveTable ht = (RelOptHiveTable)scanRel.getTable();
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        ArrayList<VirtualColumn> virtualCols = new ArrayList<VirtualColumn>();
        ArrayList<Integer> neededColumnIDs = new ArrayList<Integer>();
        ArrayList<String> neededColumnNames = new ArrayList<String>();
        HashSet<Integer> vcolsInCalcite = new HashSet<Integer>();
        ArrayList<String> partColNames = new ArrayList<String>();
        ImmutableMap<Integer, VirtualColumn> VColsMap = HiveCalciteUtil.getVColsMap(ht.getVirtualCols(), ht.getNoOfNonVirtualCols());
        Map<Integer, ColumnInfo> posToPartColInfo = ht.getPartColInfoMap();
        Map<Integer, ColumnInfo> posToNonPartColInfo = ht.getNonPartColInfoMap();
        List<Integer> neededColIndxsFrmReloptHT = scanRel.getNeededColIndxsFrmReloptHT();
        List scanColNames = scanRel.getRowType().getFieldNames();
        String tableAlias = scanRel.getTableAlias();
        for (int index = 0; index < scanRel.getRowType().getFieldList().size(); ++index) {
            ColumnInfo colInfo;
            String colName = (String)scanColNames.get(index);
            if (VColsMap.containsKey(index)) {
                VirtualColumn vc = (VirtualColumn)VColsMap.get(index);
                virtualCols.add(vc);
                colInfo = new ColumnInfo(vc.getName(), vc.getTypeInfo(), tableAlias, true, vc.getIsHidden());
                vcolsInCalcite.add(index);
            } else if (posToPartColInfo.containsKey(index)) {
                partColNames.add(colName);
                colInfo = posToPartColInfo.get(index);
                vcolsInCalcite.add(index);
            } else {
                colInfo = posToNonPartColInfo.get(index);
            }
            colInfos.add(colInfo);
            if (!neededColIndxsFrmReloptHT.contains(index)) continue;
            neededColumnIDs.add(index);
            neededColumnNames.add(colName);
        }
        TableScanDesc tsd = new TableScanDesc(tableAlias, virtualCols, ht.getHiveTableMD());
        tsd.setPartColumns(partColNames);
        tsd.setNeededColumnIDs(neededColumnIDs);
        tsd.setNeededColumns(neededColumnNames);
        TableScanOperator ts = (TableScanOperator)OperatorFactory.get(tsd, new RowSchema(colInfos), new Operator[0]);
        this.topOps.put(scanRel.getConcatQbIDAlias(), ts);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + ts + " with row schema: [" + ts.getSchema() + "]"));
        }
        return new OpAttr(tableAlias, vcolsInCalcite, ts);
    }

    OpAttr visit(HiveProject projectRel) throws SemanticException {
        OpAttr inputOpAf = this.dispatch(projectRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Translating operator rel#" + projectRel.getId() + ":" + projectRel.getRelTypeName() + " with row type: [" + projectRel.getRowType() + "]"));
        }
        WindowingSpec windowingSpec = new WindowingSpec();
        ArrayList<String> exprNames = new ArrayList<String>(projectRel.getRowType().getFieldNames());
        ArrayList<ExprNodeDesc> exprCols = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int pos = 0; pos < projectRel.getChildExps().size(); ++pos) {
            ExprNodeConverter converter = new ExprNodeConverter(inputOpAf.tabAlias, (String)projectRel.getRowType().getFieldNames().get(pos), projectRel.getInput().getRowType(), projectRel.getRowType(), inputOpAf.vcolsInCalcite, projectRel.getCluster().getTypeFactory());
            ExprNodeDesc exprCol = (ExprNodeDesc)((RexNode)projectRel.getChildExps().get(pos)).accept((RexVisitor)converter);
            colExprMap.put((String)exprNames.get(pos), exprCol);
            exprCols.add(exprCol);
            if (converter.getWindowFunctionSpec() == null) continue;
            windowingSpec.addWindowFunction(converter.getWindowFunctionSpec());
        }
        if (windowingSpec.getWindowExpressions() != null && !windowingSpec.getWindowExpressions().isEmpty()) {
            inputOpAf = this.genPTF(inputOpAf, windowingSpec);
        }
        SelectDesc sd = new SelectDesc(exprCols, exprNames);
        Pair<ArrayList<ColumnInfo>, Set<Integer>> colInfoVColPair = HiveOpConverter.createColInfos(projectRel.getChildExps(), exprCols, exprNames, inputOpAf);
        SelectOperator selOp = (SelectOperator)OperatorFactory.getAndMakeChild(sd, new RowSchema((ArrayList)colInfoVColPair.getKey()), (Operator)inputOpAf.inputs.get(0));
        selOp.setColumnExprMap(colExprMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + selOp + " with row schema: [" + selOp.getSchema() + "]"));
        }
        return new OpAttr(inputOpAf.tabAlias, (Set)colInfoVColPair.getValue(), selOp);
    }

    OpAttr visit(MultiJoin joinRel) throws SemanticException {
        return this.translateJoin((RelNode)joinRel);
    }

    OpAttr visit(HiveJoin joinRel) throws SemanticException {
        return this.translateJoin(joinRel);
    }

    private OpAttr translateJoin(RelNode joinRel) throws SemanticException {
        OpAttr[] inputs = new OpAttr[joinRel.getInputs().size()];
        ArrayList children = new ArrayList(joinRel.getInputs().size());
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = this.dispatch(joinRel.getInput(i));
            children.add((Operator<?>)inputs[i].inputs.get(0));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Translating operator rel#" + joinRel.getId() + ":" + joinRel.getRelTypeName() + " with row type: [" + joinRel.getRowType() + "]"));
        }
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo = joinRel instanceof HiveJoin ? HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo((HiveJoin)joinRel) : HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo((MultiJoin)joinRel);
        ExprNodeDesc[][] joinExpressions = new ExprNodeDesc[inputs.length][];
        for (int i = 0; i < inputs.length; ++i) {
            joinExpressions[i] = ((HiveSortExchange)joinRel.getInput(i)).getJoinExpressions();
        }
        for (int tag = 0; tag < children.size(); ++tag) {
            ReduceSinkOperator reduceSinkOp = (ReduceSinkOperator)children.get(tag);
            ((ReduceSinkDesc)reduceSinkOp.getConf()).setTag(tag);
        }
        JoinOperator joinOp = HiveOpConverter.genJoin(joinRel, joinPredInfo, children, joinExpressions);
        HashSet<Integer> newVcolsInCalcite = new HashSet<Integer>();
        newVcolsInCalcite.addAll(inputs[0].vcolsInCalcite);
        if (joinRel instanceof MultiJoin || HiveOpConverter.extractJoinType((HiveJoin)joinRel) != JoinType.LEFTSEMI) {
            int shift = ((Operator)inputs[0].inputs.get(0)).getSchema().getSignature().size();
            for (int i = 1; i < inputs.length; ++i) {
                newVcolsInCalcite.addAll(HiveCalciteUtil.shiftVColsSet(inputs[i].vcolsInCalcite, shift));
                shift += ((Operator)inputs[i].inputs.get(0)).getSchema().getSignature().size();
            }
        }
        return new OpAttr(null, newVcolsInCalcite, joinOp);
    }

    OpAttr visit(HiveAggregate aggRel) throws SemanticException {
        OpAttr inputOpAf = this.dispatch(aggRel.getInput());
        return HiveGBOpConvUtil.translateGB(inputOpAf, aggRel, this.hiveConf);
    }

    OpAttr visit(HiveSort sortRel) throws SemanticException {
        OpAttr inputOpAf = this.dispatch(sortRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Translating operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " with row type: [" + sortRel.getRowType() + "]"));
            if (sortRel.getCollation() == RelCollations.EMPTY) {
                LOG.debug((Object)("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of limit"));
            } else if (sortRel.fetch == null) {
                LOG.debug((Object)("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of sort"));
            } else {
                LOG.debug((Object)("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of sort+limit"));
            }
        }
        Operator inputOp = (Operator)inputOpAf.inputs.get(0);
        SelectOperator resultOp = (SelectOperator)inputOpAf.inputs.get(0);
        if (sortRel.getCollation() != RelCollations.EMPTY) {
            if (this.strictMode && sortRel.fetch == null) {
                throw new SemanticException(ErrorMsg.NO_LIMIT_WITH_ORDERBY.getMsg());
            }
            ImmutableBitSet.Builder sortColsPosBuilder = new ImmutableBitSet.Builder();
            ImmutableBitSet.Builder sortOutputColsPosBuilder = new ImmutableBitSet.Builder();
            Map<Integer, RexNode> obRefToCallMap = sortRel.getInputRefToCallMap();
            ArrayList<ExprNodeColumnDesc> sortCols = new ArrayList<ExprNodeColumnDesc>();
            StringBuilder order = new StringBuilder();
            for (RelFieldCollation sortInfo : sortRel.getCollation().getFieldCollations()) {
                int sortColumnPos = sortInfo.getFieldIndex();
                ColumnInfo columnInfo = new ColumnInfo(inputOp.getSchema().getSignature().get(sortColumnPos));
                ExprNodeColumnDesc sortColumn = new ExprNodeColumnDesc(columnInfo.getType(), columnInfo.getInternalName(), columnInfo.getTabAlias(), columnInfo.getIsVirtualCol());
                sortCols.add(sortColumn);
                if (sortInfo.getDirection() == RelFieldCollation.Direction.DESCENDING) {
                    order.append("-");
                } else {
                    order.append("+");
                }
                if (obRefToCallMap == null) continue;
                RexNode obExpr = obRefToCallMap.get(sortColumnPos);
                sortColsPosBuilder.set(sortColumnPos);
                if (obExpr != null) continue;
                sortOutputColsPosBuilder.set(sortColumnPos);
            }
            int numReducers = 1;
            ArrayList<String> keepColumns = new ArrayList<String>();
            ImmutableBitSet sortColsPos = sortColsPosBuilder.build();
            ImmutableBitSet sortOutputColsPos = sortOutputColsPosBuilder.build();
            ArrayList<ColumnInfo> inputSchema = inputOp.getSchema().getSignature();
            for (int pos = 0; pos < inputSchema.size(); ++pos) {
                if ((!sortColsPos.get(pos) || !sortOutputColsPos.get(pos)) && (sortColsPos.get(pos) || sortOutputColsPos.get(pos))) continue;
                keepColumns.add(inputSchema.get(pos).getInternalName());
            }
            resultOp = HiveOpConverter.genReduceSinkAndBacktrackSelect(resultOp, sortCols.toArray(new ExprNodeDesc[sortCols.size()]), 0, new ArrayList<ExprNodeDesc>(), order.toString(), numReducers, AcidUtils.Operation.NOT_ACID, this.strictMode, keepColumns);
        }
        if (sortRel.fetch != null) {
            int limit = RexLiteral.intValue((RexNode)sortRel.fetch);
            LimitDesc limitDesc = new LimitDesc(limit);
            ArrayList<ColumnInfo> cinfoLst = HiveOpConverter.createColInfos(inputOp);
            resultOp = OperatorFactory.getAndMakeChild(limitDesc, new RowSchema(cinfoLst), resultOp);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Generated " + resultOp + " with row schema: [" + resultOp.getSchema() + "]"));
            }
        }
        return inputOpAf.clone(new Operator[]{resultOp});
    }

    OpAttr visit(HiveFilter filterRel) throws SemanticException {
        OpAttr inputOpAf = this.dispatch(filterRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Translating operator rel#" + filterRel.getId() + ":" + filterRel.getRelTypeName() + " with row type: [" + filterRel.getRowType() + "]"));
        }
        ExprNodeDesc filCondExpr = (ExprNodeDesc)filterRel.getCondition().accept((RexVisitor)new ExprNodeConverter(inputOpAf.tabAlias, filterRel.getInput().getRowType(), inputOpAf.vcolsInCalcite, filterRel.getCluster().getTypeFactory()));
        FilterDesc filDesc = new FilterDesc(filCondExpr, false);
        ArrayList<ColumnInfo> cinfoLst = HiveOpConverter.createColInfos((Operator)inputOpAf.inputs.get(0));
        FilterOperator filOp = (FilterOperator)OperatorFactory.getAndMakeChild(filDesc, new RowSchema(cinfoLst), (Operator)inputOpAf.inputs.get(0));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + filOp + " with row schema: [" + filOp.getSchema() + "]"));
        }
        return inputOpAf.clone(new Operator[]{filOp});
    }

    OpAttr visit(HiveUnion unionRel) throws SemanticException {
        OpAttr[] inputs = new OpAttr[unionRel.getInputs().size()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = this.dispatch(unionRel.getInput(i));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Translating operator rel#" + unionRel.getId() + ":" + unionRel.getRelTypeName() + " with row type: [" + unionRel.getRowType() + "]"));
        }
        UnionDesc unionDesc = new UnionDesc();
        unionDesc.setNumInputs(inputs.length);
        ArrayList<ColumnInfo> cinfoLst = HiveOpConverter.createColInfos((Operator)inputs[0].inputs.get(0));
        Operator[] children = new Operator[inputs.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = (Operator)inputs[i].inputs.get(0);
        }
        Operator<UnionDesc> unionOp = OperatorFactory.getAndMakeChild(unionDesc, new RowSchema(cinfoLst), children);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + unionOp + " with row schema: [" + unionOp.getSchema() + "]"));
        }
        return inputs[0].clone(new Operator[]{unionOp});
    }

    OpAttr visit(HiveSortExchange exchangeRel) throws SemanticException {
        RelDistribution distribution;
        OpAttr inputOpAf = this.dispatch(exchangeRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Translating operator rel#" + exchangeRel.getId() + ":" + exchangeRel.getRelTypeName() + " with row type: [" + exchangeRel.getRowType() + "]"));
        }
        if ((distribution = exchangeRel.getDistribution()).getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            throw new SemanticException("Only hash distribution supported for LogicalExchange");
        }
        ExprNodeDesc[] expressions = new ExprNodeDesc[exchangeRel.getJoinKeys().size()];
        for (int index = 0; index < exchangeRel.getJoinKeys().size(); ++index) {
            expressions[index] = HiveOpConverter.convertToExprNode((RexNode)exchangeRel.getJoinKeys().get(index), exchangeRel.getInput(), null, inputOpAf);
        }
        exchangeRel.setJoinExpressions(expressions);
        ReduceSinkOperator rsOp = HiveOpConverter.genReduceSink((Operator)inputOpAf.inputs.get(0), expressions, -1, -1, AcidUtils.Operation.NOT_ACID, this.strictMode);
        return inputOpAf.clone(new Operator[]{rsOp});
    }

    private OpAttr genPTF(OpAttr inputOpAf, WindowingSpec wSpec) throws SemanticException {
        Operator<PTFDesc> input = (Operator<PTFDesc>)inputOpAf.inputs.get(0);
        wSpec.validateAndMakeEffective();
        WindowingComponentizer groups = new WindowingComponentizer(wSpec);
        RowResolver rr = new RowResolver();
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            rr.put(ci.getTabAlias(), ci.getInternalName(), ci);
        }
        while (groups.hasNext()) {
            wSpec = groups.next(this.hiveConf, this.semanticAnalyzer, this.unparseTranslator, rr);
            ArrayList<ExprNodeDesc> keyCols = new ArrayList<ExprNodeDesc>();
            ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
            StringBuilder order = new StringBuilder();
            for (PTFInvocationSpec.PartitionExpression partCol : wSpec.getQueryPartitionSpec().getExpressions()) {
                ExprNodeDesc partExpr = this.semanticAnalyzer.genExprNodeDesc(partCol.getExpression(), rr);
                if (ExprNodeDescUtils.indexOf(partExpr, partCols) >= 0) continue;
                keyCols.add(partExpr);
                partCols.add(partExpr);
                order.append('+');
            }
            if (wSpec.getQueryOrderSpec() != null) {
                for (PTFInvocationSpec.OrderExpression orderCol : wSpec.getQueryOrderSpec().getExpressions()) {
                    ExprNodeDesc orderExpr = this.semanticAnalyzer.genExprNodeDesc(orderCol.getExpression(), rr);
                    char orderChar = orderCol.getOrder() == PTFInvocationSpec.Order.ASC ? (char)'+' : '-';
                    int index = ExprNodeDescUtils.indexOf(orderExpr, keyCols);
                    if (index >= 0) {
                        order.setCharAt(index, orderChar);
                        continue;
                    }
                    keyCols.add(orderExpr);
                    order.append(orderChar);
                }
            }
            SelectOperator selectOp = HiveOpConverter.genReduceSinkAndBacktrackSelect(input, keyCols.toArray(new ExprNodeDesc[keyCols.size()]), 0, partCols, order.toString(), -1, AcidUtils.Operation.NOT_ACID, this.strictMode);
            PTFTranslator translator = new PTFTranslator();
            PTFDesc ptfDesc = translator.translate(wSpec, this.semanticAnalyzer, this.hiveConf, rr, this.unparseTranslator);
            RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
            Operator<PTFDesc> ptfOp = OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), selectOp);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Generated " + ptfOp + " with row schema: [" + ptfOp.getSchema() + "]"));
            }
            rr = ptfOpRR;
            input = ptfOp;
        }
        return inputOpAf.clone(new Operator[]{input});
    }

    private ExprNodeDesc[][] extractJoinKeys(HiveCalciteUtil.JoinPredicateInfo joinPredInfo, List<RelNode> inputs, OpAttr[] inputAttr) {
        ExprNodeDesc[][] joinKeys = new ExprNodeDesc[inputs.size()][];
        for (int i = 0; i < inputs.size(); ++i) {
            joinKeys[i] = new ExprNodeDesc[joinPredInfo.getEquiJoinPredicateElements().size()];
            for (int j = 0; j < joinPredInfo.getEquiJoinPredicateElements().size(); ++j) {
                HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(j);
                RexNode key = joinLeafPredInfo.getJoinKeyExprs(j).get(0);
                joinKeys[i][j] = HiveOpConverter.convertToExprNode(key, inputs.get(j), null, inputAttr[i]);
            }
        }
        return joinKeys;
    }

    private static SelectOperator genReduceSinkAndBacktrackSelect(Operator<?> input, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, int numReducers, AcidUtils.Operation acidOperation, boolean strictMode) throws SemanticException {
        return HiveOpConverter.genReduceSinkAndBacktrackSelect(input, keys, tag, partitionCols, order, numReducers, acidOperation, strictMode, input.getSchema().getColumnNames());
    }

    private static SelectOperator genReduceSinkAndBacktrackSelect(Operator<?> input, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, int numReducers, AcidUtils.Operation acidOperation, boolean strictMode, List<String> keepColNames) throws SemanticException {
        ReduceSinkOperator rsOp = HiveOpConverter.genReduceSink(input, keys, tag, partitionCols, order, numReducers, acidOperation, strictMode);
        Map<String, ExprNodeDesc> descriptors = HiveOpConverter.buildBacktrackFromReduceSink(keepColNames, ((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames(), ((ReduceSinkDesc)rsOp.getConf()).getOutputValueColumnNames(), rsOp.getValueIndex(), input);
        SelectDesc selectDesc = new SelectDesc(new ArrayList<ExprNodeDesc>(descriptors.values()), new ArrayList<String>(descriptors.keySet()));
        ArrayList<ColumnInfo> cinfoLst = HiveOpConverter.createColInfosSubset(input, keepColNames);
        SelectOperator selectOp = (SelectOperator)OperatorFactory.getAndMakeChild(selectDesc, new RowSchema(cinfoLst), rsOp);
        selectOp.setColumnExprMap(descriptors);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + selectOp + " with row schema: [" + selectOp.getSchema() + "]"));
        }
        return selectOp;
    }

    private static ReduceSinkOperator genReduceSink(Operator<?> input, ExprNodeDesc[] keys, int tag, int numReducers, AcidUtils.Operation acidOperation, boolean strictMode) throws SemanticException {
        return HiveOpConverter.genReduceSink(input, keys, tag, new ArrayList<ExprNodeDesc>(), "", numReducers, acidOperation, strictMode);
    }

    private static ReduceSinkOperator genReduceSink(Operator<?> input, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, int numReducers, AcidUtils.Operation acidOperation, boolean strictMode) throws SemanticException {
        Operator dummy = Operator.createDummy();
        dummy.setParentOperators(Arrays.asList(input));
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceKeysBack = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc key : keys) {
            reduceKeys.add(key);
            reduceKeysBack.add(ExprNodeDescUtils.backtrack(key, dummy, input));
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceValuesBack = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ColumnInfo> inputColumns = input.getSchema().getSignature();
        ArrayList<ColumnInfo> outputColumns = new ArrayList<ColumnInfo>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        int[] index = new int[inputColumns.size()];
        for (int i = 0; i < inputColumns.size(); ++i) {
            int vindex;
            int kindex;
            ColumnInfo colInfo = (ColumnInfo)inputColumns.get(i);
            String outputColName = colInfo.getInternalName();
            ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo);
            ExprNodeDesc exprBack = ExprNodeDescUtils.backtrack((ExprNodeDesc)expr, dummy, input);
            int n = kindex = exprBack == null ? -1 : ExprNodeDescUtils.indexOf(exprBack, reduceKeysBack);
            if (kindex >= 0) {
                ColumnInfo newColInfo = new ColumnInfo(colInfo);
                newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.KEY) + ".reducesinkkey" + kindex);
                newColInfo.setAlias(outputColName);
                newColInfo.setTabAlias(colInfo.getTabAlias());
                outputColumns.add(newColInfo);
                index[i] = kindex;
                continue;
            }
            int n2 = vindex = exprBack == null ? -1 : ExprNodeDescUtils.indexOf(exprBack, reduceValuesBack);
            if (kindex >= 0) {
                index[i] = -vindex - 1;
                continue;
            }
            index[i] = -reduceValues.size() - 1;
            reduceValues.add(expr);
            reduceValuesBack.add(exprBack);
            ColumnInfo newColInfo = new ColumnInfo(colInfo);
            newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.VALUE) + "." + outputColName);
            newColInfo.setAlias(outputColName);
            newColInfo.setTabAlias(colInfo.getTabAlias());
            outputColumns.add(newColInfo);
            outputColumnNames.add(outputColName);
        }
        dummy.setParentOperators(null);
        if (reduceKeys.size() == 0) {
            numReducers = 1;
            if (strictMode) {
                throw new SemanticException(ErrorMsg.NO_CARTESIAN_PRODUCT.getMsg());
            }
        }
        ReduceSinkDesc rsDesc = order.isEmpty() ? PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, false, tag, reduceKeys.size(), numReducers, acidOperation) : PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, false, tag, partitionCols, order, numReducers, acidOperation);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsDesc, new RowSchema(outputColumns), input);
        ArrayList<String> keyColNames = rsDesc.getOutputKeyColumnNames();
        for (int i = 0; i < keyColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + "." + (String)keyColNames.get(i), reduceKeys.get(i));
        }
        ArrayList<String> valColNames = rsDesc.getOutputValueColumnNames();
        for (int i = 0; i < valColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.VALUE) + "." + (String)valColNames.get(i), reduceValues.get(i));
        }
        rsOp.setValueIndex(index);
        rsOp.setColumnExprMap(colExprMap);
        rsOp.setInputAliases(input.getSchema().getColumnNames().toArray(new String[input.getSchema().getColumnNames().size()]));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + rsOp + " with row schema: [" + rsOp.getSchema() + "]"));
        }
        return rsOp;
    }

    private static JoinOperator genJoin(RelNode join, HiveCalciteUtil.JoinPredicateInfo joinPredInfo, List<Operator<?>> children, ExprNodeDesc[][] joinKeys) throws SemanticException {
        JoinType joinType = join instanceof MultiJoin ? JoinType.INNER : HiveOpConverter.extractJoinType((HiveJoin)join);
        JoinCondDesc[] joinCondns = new JoinCondDesc[children.size() - 1];
        for (int i = 1; i < children.size(); ++i) {
            joinCondns[i - 1] = new JoinCondDesc(new JoinCond(0, i, joinType));
        }
        ArrayList<ColumnInfo> outputColumns = new ArrayList<ColumnInfo>();
        ArrayList<String> outputColumnNames = new ArrayList<String>(join.getRowType().getFieldNames());
        Operator[] childOps = new Operator[children.size()];
        HashMap<String, Byte> reversedExprs = new HashMap<String, Byte>();
        HashMap<Byte, List<ExprNodeDesc>> exprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<Integer, Set<String>> posToAliasMap = new HashMap<Integer, Set<String>>();
        int outputPos = 0;
        for (int pos = 0; pos < children.size(); ++pos) {
            ReduceSinkOperator inputRS = (ReduceSinkOperator)children.get(pos);
            if (inputRS.getNumParent() != 1) {
                throw new SemanticException("RS should have single parent");
            }
            Operator<OperatorDesc> parent = inputRS.getParentOperators().get(0);
            ReduceSinkDesc rsDesc = (ReduceSinkDesc)inputRS.getConf();
            int[] index = inputRS.getValueIndex();
            Byte tag = (byte)rsDesc.getTag();
            if (joinType == JoinType.LEFTSEMI && pos != 0) {
                exprMap.put(tag, new ArrayList());
                childOps[pos] = inputRS;
                continue;
            }
            ArrayList<String> keyColNames = rsDesc.getOutputKeyColumnNames();
            ArrayList<String> valColNames = rsDesc.getOutputValueColumnNames();
            posToAliasMap.put(pos, new HashSet<String>(inputRS.getSchema().getTableNames()));
            Map<String, ExprNodeDesc> descriptors = HiveOpConverter.buildBacktrackFromReduceSinkForJoin(outputPos, outputColumnNames, keyColNames, valColNames, index, parent);
            ArrayList<ColumnInfo> parentColumns = parent.getSchema().getSignature();
            for (int i = 0; i < index.length; ++i) {
                ColumnInfo info = new ColumnInfo((ColumnInfo)parentColumns.get(i));
                info.setInternalName(outputColumnNames.get(outputPos));
                outputColumns.add(info);
                reversedExprs.put(outputColumnNames.get(outputPos), tag);
                ++outputPos;
            }
            exprMap.put(tag, new ArrayList<ExprNodeDesc>(descriptors.values()));
            colExprMap.putAll(descriptors);
            childOps[pos] = inputRS;
        }
        boolean noOuterJoin = joinType != JoinType.FULLOUTER && joinType != JoinType.LEFTOUTER && joinType != JoinType.RIGHTOUTER;
        JoinDesc desc = new JoinDesc(exprMap, outputColumnNames, noOuterJoin, joinCondns, joinKeys);
        desc.setReversedExprs(reversedExprs);
        JoinOperator joinOp = (JoinOperator)OperatorFactory.getAndMakeChild(desc, new RowSchema(outputColumns), childOps);
        joinOp.setColumnExprMap(colExprMap);
        joinOp.setPosToAliasMap(posToAliasMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + joinOp + " with row schema: [" + joinOp.getSchema() + "]"));
        }
        return joinOp;
    }

    private static JoinType extractJoinType(HiveJoin join) {
        JoinType resultJoinType;
        if (join.isDistinct()) {
            return JoinType.UNIQUE;
        }
        if (join.isLeftSemiJoin()) {
            return JoinType.LEFTSEMI;
        }
        switch (join.getJoinType()) {
            case FULL: {
                resultJoinType = JoinType.FULLOUTER;
                break;
            }
            case LEFT: {
                resultJoinType = JoinType.LEFTOUTER;
                break;
            }
            case RIGHT: {
                resultJoinType = JoinType.RIGHTOUTER;
                break;
            }
            default: {
                resultJoinType = JoinType.INNER;
            }
        }
        return resultJoinType;
    }

    private static Map<String, ExprNodeDesc> buildBacktrackFromReduceSinkForJoin(int initialPos, List<String> outputColumnNames, List<String> keyColNames, List<String> valueColNames, int[] index, Operator<?> inputOp) {
        LinkedHashMap<String, ExprNodeDesc> columnDescriptors = new LinkedHashMap<String, ExprNodeDesc>();
        for (int i = 0; i < index.length; ++i) {
            ColumnInfo info = new ColumnInfo(inputOp.getSchema().getSignature().get(i));
            String field = index[i] >= 0 ? (Object)((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(index[i]) : (Object)((Object)Utilities.ReduceField.VALUE) + "." + valueColNames.get(-index[i] - 1);
            ExprNodeColumnDesc desc = new ExprNodeColumnDesc(info.getType(), field, info.getTabAlias(), info.getIsVirtualCol());
            columnDescriptors.put(outputColumnNames.get(initialPos + i), desc);
        }
        return columnDescriptors;
    }

    private static Map<String, ExprNodeDesc> buildBacktrackFromReduceSink(List<String> keepColNames, List<String> keyColNames, List<String> valueColNames, int[] index, Operator<?> inputOp) {
        LinkedHashMap<String, ExprNodeDesc> columnDescriptors = new LinkedHashMap<String, ExprNodeDesc>();
        int pos = 0;
        for (int i = 0; i < index.length; ++i) {
            ColumnInfo info = inputOp.getSchema().getSignature().get(i);
            if (pos >= keepColNames.size() || !info.getInternalName().equals(keepColNames.get(pos))) continue;
            String field = index[i] >= 0 ? (Object)((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(index[i]) : (Object)((Object)Utilities.ReduceField.VALUE) + "." + valueColNames.get(-index[i] - 1);
            ExprNodeColumnDesc desc = new ExprNodeColumnDesc(info.getType(), field, info.getTabAlias(), info.getIsVirtualCol());
            columnDescriptors.put(keepColNames.get(pos), desc);
            ++pos;
        }
        return columnDescriptors;
    }

    private static ExprNodeDesc convertToExprNode(RexNode rn, RelNode inputRel, String tabAlias, OpAttr inputAttr) {
        return (ExprNodeDesc)rn.accept((RexVisitor)new ExprNodeConverter(tabAlias, inputRel.getRowType(), inputAttr.vcolsInCalcite, inputRel.getCluster().getTypeFactory()));
    }

    private static ArrayList<ColumnInfo> createColInfos(Operator<?> input) {
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            cInfoLst.add(new ColumnInfo(ci));
        }
        return cInfoLst;
    }

    private static ArrayList<ColumnInfo> createColInfosSubset(Operator<?> input, List<String> keepColNames) {
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        int pos = 0;
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            if (pos >= keepColNames.size() || !ci.getInternalName().equals(keepColNames.get(pos))) continue;
            cInfoLst.add(new ColumnInfo(ci));
            ++pos;
        }
        return cInfoLst;
    }

    private static Pair<ArrayList<ColumnInfo>, Set<Integer>> createColInfos(List<RexNode> calciteExprs, List<ExprNodeDesc> hiveExprs, List<String> projNames, OpAttr inpOpAf) {
        if (hiveExprs.size() != projNames.size()) {
            throw new RuntimeException("Column expressions list doesn't match Column Names list");
        }
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        HashSet<Integer> newVColSet = new HashSet<Integer>();
        for (int i = 0; i < hiveExprs.size(); ++i) {
            ExprNodeDesc pe = hiveExprs.get(i);
            RexNode rexN = calciteExprs.get(i);
            boolean vc = false;
            if (rexN instanceof RexInputRef && inpOpAf.vcolsInCalcite.contains(((RexInputRef)rexN).getIndex())) {
                newVColSet.add(i);
                vc = true;
            }
            colInfos.add(new ColumnInfo(projNames.get(i), pe.getTypeInfo(), inpOpAf.tabAlias, vc));
        }
        return new Pair(colInfos, newVColSet);
    }

    static class OpAttr {
        final String tabAlias;
        ImmutableList<Operator> inputs;
        ImmutableSet<Integer> vcolsInCalcite;

        OpAttr(String tabAlias, Set<Integer> vcols, Operator ... inputs) {
            this.tabAlias = tabAlias;
            this.inputs = ImmutableList.copyOf(inputs);
            this.vcolsInCalcite = ImmutableSet.copyOf(vcols);
        }

        private OpAttr clone(Operator ... inputs) {
            return new OpAttr(this.tabAlias, this.vcolsInCalcite, inputs);
        }
    }

    public static enum HIVEAGGOPMODE {
        NO_SKEW_NO_MAP_SIDE_AGG,
        SKEW_NO_MAP_SIDE_AGG,
        NO_SKEW_MAP_SIDE_AGG,
        SKEW_MAP_SIDE_AGG;

    }
}

