/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationKillRS
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationKillRS.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationKillRS.class);

    public void loadTableAndKillRS(HBaseTestingUtility util) throws Exception {
        Result[] res;
        Throwable throwable;
        int initialCount;
        int rsToKill1 = util.getHBaseCluster().getServerWithMeta() == 0 ? 1 : 0;
        Thread killer = TestReplicationKillRS.killARegionServer(util, 5000L, rsToKill1);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf1);
             Table table = conn.getTable(tableName);){
            LOG.info("Start loading table");
            initialCount = utility1.loadTable(table, famName);
            LOG.info("Done loading table");
            killer.join(5000L);
            LOG.info("Done waiting for threads");
            while (true) {
                try {
                    throwable = null;
                    try (ResultScanner scanner = table.getScanner(new Scan());){
                        res = scanner.next(initialCount);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (UnknownScannerException ex) {
                    LOG.info("Cluster wasn't ready yet, restarting scanner");
                    continue;
                }
                break;
            }
        }
        if (res.length != initialCount) {
            LOG.warn("We lost some rows on the master cluster!");
            initialCount = res.length;
        }
        int lastCount = 0;
        long start = System.currentTimeMillis();
        int i = 0;
        throwable = null;
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf2);
             Table table = conn.getTable(tableName);){
            while (true) {
                Result[] res2;
                if (i == 49) {
                    Assert.fail((String)("Waited too much time for queueFailover replication. Waited " + (System.currentTimeMillis() - start) + "ms."));
                }
                try (ResultScanner scanner = table.getScanner(new Scan());){
                    res2 = scanner.next(initialCount * 2);
                }
                if (res2.length < initialCount) {
                    i = lastCount < res2.length ? --i : ++i;
                    lastCount = res2.length;
                    LOG.info("Only got " + lastCount + " rows instead of " + initialCount + " current i=" + i);
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private static Thread killARegionServer(final HBaseTestingUtility utility, final long timeout, final int rs) {
        Thread killer = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                    utility.getHBaseCluster().getRegionServer(rs).stop("Stopping as part of the test");
                }
                catch (Exception e) {
                    LOG.error("Couldn't kill a region server", (Throwable)e);
                }
            }
        };
        killer.setDaemon(true);
        killer.start();
        return killer;
    }
}

