/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.RegionServerProcedureManager;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.procedure.SubprocedureFactory;
import org.apache.hadoop.hbase.procedure.ZKProcedureMemberRpcs;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRSProcedureManager
extends RegionServerProcedureManager {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRSProcedureManager.class);
    private RegionServerServices rss;
    private ProcedureMemberRpcs memberRpcs;
    private ProcedureMember member;

    public void initialize(RegionServerServices rss) throws KeeperException {
        this.rss = rss;
        ZKWatcher zkw = rss.getZooKeeper();
        this.memberRpcs = new ZKProcedureMemberRpcs(zkw, this.getProcedureSignature());
        ThreadPoolExecutor pool = ProcedureMember.defaultPool((String)rss.getServerName().toString(), (int)1);
        this.member = new ProcedureMember(this.memberRpcs, pool, (SubprocedureFactory)new SimleSubprocedureBuilder());
        LOG.info("Initialized: " + rss.getServerName().toString());
    }

    public void start() {
        this.memberRpcs.start(this.rss.getServerName().toString(), this.member);
        LOG.info("Started.");
    }

    public void stop(boolean force) throws IOException {
        LOG.info("stop: " + force);
        try {
            this.member.close();
        }
        finally {
            this.memberRpcs.close();
        }
    }

    public String getProcedureSignature() {
        return "simple_test";
    }

    public Subprocedure buildSubprocedure(String name) {
        if (this.rss.isStopping() || this.rss.isStopped()) {
            throw new IllegalStateException("Can't start procedure on RS: " + this.rss.getServerName() + ", because stopping/stopped!");
        }
        LOG.info("Attempting to run a procedure.");
        ForeignExceptionDispatcher errorDispatcher = new ForeignExceptionDispatcher();
        Configuration conf = this.rss.getConfiguration();
        SimpleSubprocedurePool taskManager = new SimpleSubprocedurePool(this.rss.getServerName().toString(), conf);
        return new SimpleSubprocedure(this.rss, this.member, errorDispatcher, taskManager, name);
    }

    public class SimpleSubprocedure
    extends Subprocedure {
        private final RegionServerServices rss;
        private final SimpleSubprocedurePool taskManager;

        public SimpleSubprocedure(RegionServerServices rss, ProcedureMember member, ForeignExceptionDispatcher errorListener, SimpleSubprocedurePool taskManager, String name) {
            super(member, name, errorListener, 500L, 60000L);
            LOG.info("Constructing a SimpleSubprocedure.");
            this.rss = rss;
            this.taskManager = taskManager;
        }

        private void execute() throws ForeignException {
            this.monitor.rethrowException();
            this.taskManager.submitTask(new RSSimpleTask());
            this.monitor.rethrowException();
            this.taskManager.waitForOutstandingTasks();
            this.monitor.rethrowException();
        }

        public void acquireBarrier() throws ForeignException {
        }

        public byte[] insideBarrier() throws ForeignException {
            this.execute();
            return "simple_test_data".getBytes();
        }

        public void cleanup(Exception e) {
            this.taskManager.abort("Aborting simple subprocedure tasks due to error", e);
        }

        class RSSimpleTask
        implements Callable<Void> {
            RSSimpleTask() {
            }

            @Override
            public Void call() throws Exception {
                LOG.info("Execute subprocedure on " + SimpleSubprocedure.this.rss.getServerName().toString());
                return null;
            }
        }
    }

    public class SimpleSubprocedurePool
    implements Closeable,
    Abortable {
        private final ExecutorCompletionService<Void> taskPool;
        private final ThreadPoolExecutor executor;
        private volatile boolean aborted;
        private final List<Future<Void>> futures = new ArrayList<Future<Void>>();
        private final String name;

        public SimpleSubprocedurePool(String name, Configuration conf) {
            this.name = name;
            this.executor = new ThreadPoolExecutor(1, 1, 500L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory("rs(" + name + ")-procedure-pool-"));
            this.taskPool = new ExecutorCompletionService(this.executor);
        }

        public void submitTask(Callable<Void> task) {
            Future<Void> f = this.taskPool.submit(task);
            this.futures.add(f);
        }

        public boolean waitForOutstandingTasks() throws ForeignException {
            LOG.debug("Waiting for procedure to finish.");
            try {
                for (Future<Void> future : this.futures) {
                    future.get();
                }
                boolean bl = true;
                return bl;
            }
            catch (InterruptedException e) {
                if (this.aborted) {
                    throw new ForeignException("Interrupted and found to be aborted while waiting for tasks!", (Throwable)e);
                }
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ForeignException) {
                    throw (ForeignException)e.getCause();
                }
                throw new ForeignException(this.name, e.getCause());
            }
            finally {
                for (Future<Void> future : this.futures) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
            }
            return false;
        }

        @Override
        public void close() {
            this.executor.shutdown();
        }

        public void abort(String why, Throwable e) {
            if (this.aborted) {
                return;
            }
            this.aborted = true;
            LOG.warn("Aborting because: " + why, e);
            this.executor.shutdownNow();
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }

    public class SimleSubprocedureBuilder
    implements SubprocedureFactory {
        public Subprocedure buildSubprocedure(String name, byte[] data) {
            LOG.info("Building procedure: " + name);
            return SimpleRSProcedureManager.this.buildSubprocedure(name);
        }
    }
}

