/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.compactions;

import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.compactions.PartitionedMobCompactor;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMobCompactor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCompactor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMobCompactor.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf = null;
    private TableName tableName;
    private static Connection conn;
    private BufferedMutator bufMut;
    private Table table;
    private static Admin admin;
    private HTableDescriptor desc;
    private HColumnDescriptor hcd1;
    private HColumnDescriptor hcd2;
    private static FileSystem fs;
    private static final String family1 = "family1";
    private static final String family2 = "family2";
    private static final String qf1 = "qualifier1";
    private static final String qf2 = "qualifier2";
    private static long tsFor20150907Monday;
    private static long tsFor20151120Sunday;
    private static long tsFor20151128Saturday;
    private static long tsFor20151130Monday;
    private static long tsFor20151201Tuesday;
    private static long tsFor20151205Saturday;
    private static long tsFor20151228Monday;
    private static long tsFor20151231Thursday;
    private static long tsFor20160101Friday;
    private static long tsFor20160103Sunday;
    private static final byte[] mobKey01;
    private static final byte[] mobKey02;
    private static final byte[] mobKey03;
    private static final byte[] mobKey04;
    private static final byte[] mobKey05;
    private static final byte[] mobKey06;
    private static final byte[] mobKey1;
    private static final byte[] mobKey2;
    private static final byte[] mobKey3;
    private static final byte[] mobKey4;
    private static final byte[] mobKey5;
    private static final byte[] mobKey6;
    private static final byte[] mobKey7;
    private static final byte[] mobKey8;
    private static final String mobValue0 = "mobValue00000000000000000000000000";
    private static final String mobValue1 = "mobValue00000111111111111111111111";
    private static final String mobValue2 = "mobValue00000222222222222222222222";
    private static final String mobValue3 = "mobValue00000333333333333333333333";
    private static final String mobValue4 = "mobValue00000444444444444444444444";
    private static final String mobValue5 = "mobValue00000666666666666666666666";
    private static final String mobValue6 = "mobValue00000777777777777777777777";
    private static final String mobValue7 = "mobValue00000888888888888888888888";
    private static final String mobValue8 = "mobValue00000888888888888888888899";
    private static byte[] KEYS;
    private static int regionNum;
    private static int delRowNum;
    private static int delCellNum;
    private static int cellNumPerRow;
    private static int rowNumPerFile;
    private static ExecutorService pool;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setLong("hbase.mob.compaction.mergeable.threshold", 5000L);
        TEST_UTIL.getConfiguration().set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.crypto.master.key.name", "hbase");
        TEST_UTIL.getConfiguration().setLong("hbase.master.hfilecleaner.ttl", 0L);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.hfile.compaction.discharger.interval", 100);
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.startMiniCluster(1);
        pool = TestMobCompactor.createThreadPool(TEST_UTIL.getConfiguration());
        conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration(), (ExecutorService)pool);
        fs = TEST_UTIL.getTestFileSystem();
        conf = TEST_UTIL.getConfiguration();
        admin = TEST_UTIL.getAdmin();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2015, 8, 7, 10, 20);
        tsFor20150907Monday = calendar.getTimeInMillis();
        calendar.set(2015, 10, 20, 10, 20);
        tsFor20151120Sunday = calendar.getTimeInMillis();
        calendar.set(2015, 10, 28, 10, 20);
        tsFor20151128Saturday = calendar.getTimeInMillis();
        calendar.set(2015, 10, 30, 10, 20);
        tsFor20151130Monday = calendar.getTimeInMillis();
        calendar.set(2015, 11, 1, 10, 20);
        tsFor20151201Tuesday = calendar.getTimeInMillis();
        calendar.set(2015, 11, 5, 10, 20);
        tsFor20151205Saturday = calendar.getTimeInMillis();
        calendar.set(2015, 11, 28, 10, 20);
        tsFor20151228Monday = calendar.getTimeInMillis();
        calendar.set(2015, 11, 31, 10, 20);
        tsFor20151231Thursday = calendar.getTimeInMillis();
        calendar.set(2016, 0, 1, 10, 20);
        tsFor20160101Friday = calendar.getTimeInMillis();
        calendar.set(2016, 0, 3, 10, 20);
        tsFor20160103Sunday = calendar.getTimeInMillis();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        pool.shutdown();
        conn.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    public void setUp(String tableNameAsString) throws IOException {
        this.tableName = TableName.valueOf((String)tableNameAsString);
        this.hcd1 = new HColumnDescriptor(family1);
        this.hcd1.setMobEnabled(true);
        this.hcd1.setMobThreshold(5L);
        this.hcd2 = new HColumnDescriptor(family2);
        this.hcd2.setMobEnabled(true);
        this.hcd2.setMobThreshold(5L);
        this.desc = new HTableDescriptor(this.tableName);
        this.desc.addFamily(this.hcd1);
        this.desc.addFamily(this.hcd2);
        admin.createTable((TableDescriptor)this.desc, this.getSplitKeys());
        this.table = conn.getTable(this.tableName);
        this.bufMut = conn.getBufferedMutator(this.tableName);
    }

    private void setUpForPolicyTest(String tableNameAsString, MobCompactPartitionPolicy type) throws IOException {
        this.tableName = TableName.valueOf((String)tableNameAsString);
        this.hcd1 = new HColumnDescriptor(family1);
        this.hcd1.setMobEnabled(true);
        this.hcd1.setMobThreshold(10L);
        this.hcd1.setMobCompactPartitionPolicy(type);
        this.desc = new HTableDescriptor(this.tableName);
        this.desc.addFamily(this.hcd1);
        admin.createTable((TableDescriptor)this.desc);
        this.table = conn.getTable(this.tableName);
        this.bufMut = conn.getBufferedMutator(this.tableName);
    }

    private void alterForPolicyTest(MobCompactPartitionPolicy type) throws Exception {
        Pair st;
        this.hcd1.setMobCompactPartitionPolicy(type);
        this.desc.modifyFamily(this.hcd1);
        admin.modifyTable(this.tableName, (TableDescriptor)this.desc);
        while (null != (st = admin.getAlterStatus(this.tableName)) && (Integer)st.getFirst() > 0) {
            LOG.debug(st.getFirst() + " regions left to update");
            Thread.sleep(40L);
        }
        LOG.info("alter status finished");
    }

    @Test
    public void testMinorCompaction() throws Exception {
        this.resetConf();
        int mergeSize = 5000;
        conf.setLong("hbase.mob.compaction.mergeable.threshold", (long)mergeSize);
        NamespaceDescriptor namespaceDescriptor = NamespaceDescriptor.create((String)"ns").build();
        String tableNameAsString = "ns:testMinorCompaction";
        admin.createNamespace(namespaceDescriptor);
        this.setUp(tableNameAsString);
        int count = 4;
        this.loadData(admin, this.bufMut, this.tableName, count, rowNumPerFile);
        int rowNumPerRegion = count * rowNumPerFile;
        Assert.assertEquals((String)"Before deleting: mob rows count", (long)(regionNum * rowNumPerRegion), (long)this.countMobRows(this.table));
        Assert.assertEquals((String)"Before deleting: mob cells count", (long)(regionNum * cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.table));
        Assert.assertEquals((String)"Before deleting: mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family1));
        int largeFilesCount = this.countLargeFiles(mergeSize, this.tableName, family1);
        this.createDelFile(this.table, this.tableName, Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1));
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(regionNum * (rowNumPerRegion - delRowNum)), (long)this.countMobRows(this.table));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(regionNum * (cellNumPerRow * rowNumPerRegion - delCellNum)), (long)this.countMobCells(this.table));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family1));
        Assert.assertEquals((String)"Before compaction: family2 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family2));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)regionNum, (long)this.countFiles(this.tableName, false, family1));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)regionNum, (long)this.countFiles(this.tableName, false, family2));
        PartitionedMobCompactor compactor = new PartitionedMobCompactor(conf, fs, this.tableName, (ColumnFamilyDescriptor)this.hcd1, pool);
        compactor.compact();
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(regionNum * (rowNumPerRegion - delRowNum)), (long)this.countMobRows(this.table));
        Assert.assertEquals((String)"After compaction: mob cells count", (long)(regionNum * (cellNumPerRow * rowNumPerRegion - delCellNum)), (long)this.countMobCells(this.table));
        Assert.assertEquals((String)"After compaction: family1 mob file count", (long)(largeFilesCount + regionNum), (long)this.countFiles(this.tableName, true, family1));
        Assert.assertEquals((String)"After compaction: family2 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family2));
        Assert.assertEquals((String)"After compaction: family1 del file count", (long)regionNum, (long)this.countFiles(this.tableName, false, family1));
        Assert.assertEquals((String)"After compaction: family2 del file count", (long)regionNum, (long)this.countFiles(this.tableName, false, family2));
    }

    @Test
    public void testMinorCompactionWithWeeklyPolicy() throws Exception {
        this.resetConf();
        int mergeSize = 5000;
        conf.setLong("hbase.mob.compaction.mergeable.threshold", (long)mergeSize);
        this.commonPolicyTestLogic("testMinorCompactionWithWeeklyPolicy", MobCompactPartitionPolicy.WEEKLY, false, 6, new String[]{"20150907", "20151120", "20151128", "20151130", "20151205", "20160103"}, true);
    }

    @Test
    public void testMajorCompactionWithWeeklyPolicy() throws Exception {
        this.resetConf();
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyPolicy", MobCompactPartitionPolicy.WEEKLY, true, 5, new String[]{"20150907", "20151120", "20151128", "20151205", "20160103"}, true);
    }

    @Test
    public void testMinorCompactionWithMonthlyPolicy() throws Exception {
        this.resetConf();
        int mergeSize = 5000;
        conf.setLong("hbase.mob.compaction.mergeable.threshold", (long)mergeSize);
        this.commonPolicyTestLogic("testMinorCompactionWithMonthlyPolicy", MobCompactPartitionPolicy.MONTHLY, false, 4, new String[]{"20150907", "20151130", "20151231", "20160103"}, true);
    }

    @Test
    public void testMajorCompactionWithMonthlyPolicy() throws Exception {
        this.resetConf();
        this.commonPolicyTestLogic("testMajorCompactionWithMonthlyPolicy", MobCompactPartitionPolicy.MONTHLY, true, 4, new String[]{"20150907", "20151130", "20151231", "20160103"}, true);
    }

    @Test
    public void testMajorCompactionWithWeeklyFollowedByMonthly() throws Exception {
        this.resetConf();
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyFollowedByMonthly", MobCompactPartitionPolicy.WEEKLY, true, 5, new String[]{"20150907", "20151120", "20151128", "20151205", "20160103"}, true);
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyFollowedByMonthly", MobCompactPartitionPolicy.MONTHLY, true, 4, new String[]{"20150907", "20151128", "20151205", "20160103"}, false);
    }

    @Test
    public void testMajorCompactionWithWeeklyFollowedByMonthlyFollowedByWeekly() throws Exception {
        this.resetConf();
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyFollowedByMonthlyFollowedByWeekly", MobCompactPartitionPolicy.WEEKLY, true, 5, new String[]{"20150907", "20151120", "20151128", "20151205", "20160103"}, true);
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyFollowedByMonthlyFollowedByWeekly", MobCompactPartitionPolicy.MONTHLY, true, 4, new String[]{"20150907", "20151128", "20151205", "20160103"}, false);
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyFollowedByMonthlyFollowedByWeekly", MobCompactPartitionPolicy.WEEKLY, true, 4, new String[]{"20150907", "20151128", "20151205", "20160103"}, false);
    }

    @Test
    public void testMajorCompactionWithWeeklyFollowedByMonthlyFollowedByDaily() throws Exception {
        this.resetConf();
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyFollowedByMonthlyFollowedByDaily", MobCompactPartitionPolicy.WEEKLY, true, 5, new String[]{"20150907", "20151120", "20151128", "20151205", "20160103"}, true);
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyFollowedByMonthlyFollowedByDaily", MobCompactPartitionPolicy.MONTHLY, true, 4, new String[]{"20150907", "20151128", "20151205", "20160103"}, false);
        this.commonPolicyTestLogic("testMajorCompactionWithWeeklyFollowedByMonthlyFollowedByDaily", MobCompactPartitionPolicy.DAILY, true, 4, new String[]{"20150907", "20151128", "20151205", "20160103"}, false);
    }

    @Test
    public void testCompactionWithHFileLink() throws IOException, InterruptedException {
        this.resetConf();
        String tableNameAsString = "testCompactionWithHFileLink";
        this.setUp(tableNameAsString);
        int count = 4;
        this.loadData(admin, this.bufMut, this.tableName, count, rowNumPerFile);
        int rowNumPerRegion = count * rowNumPerFile;
        long tid = System.currentTimeMillis();
        byte[] snapshotName1 = Bytes.toBytes((String)("snaptb-" + tid));
        admin.snapshot(snapshotName1, this.tableName);
        this.createDelFile(this.table, this.tableName, Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1));
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(regionNum * (rowNumPerRegion - delRowNum)), (long)this.countMobRows(this.table));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(regionNum * (cellNumPerRow * rowNumPerRegion - delCellNum)), (long)this.countMobCells(this.table));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family1));
        Assert.assertEquals((String)"Before compaction: family2 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family2));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)regionNum, (long)this.countFiles(this.tableName, false, family1));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)regionNum, (long)this.countFiles(this.tableName, false, family2));
        PartitionedMobCompactor compactor = new PartitionedMobCompactor(conf, fs, this.tableName, (ColumnFamilyDescriptor)this.hcd1, pool);
        compactor.compact();
        Assert.assertEquals((String)"After first compaction: mob rows count", (long)(regionNum * (rowNumPerRegion - delRowNum)), (long)this.countMobRows(this.table));
        Assert.assertEquals((String)"After first compaction: mob cells count", (long)(regionNum * (cellNumPerRow * rowNumPerRegion - delCellNum)), (long)this.countMobCells(this.table));
        Assert.assertEquals((String)"After first compaction: family1 mob file count", (long)regionNum, (long)this.countFiles(this.tableName, true, family1));
        Assert.assertEquals((String)"After first compaction: family2 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family2));
        Assert.assertEquals((String)"After first compaction: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, family1));
        Assert.assertEquals((String)"After first compaction: family2 del file count", (long)regionNum, (long)this.countFiles(this.tableName, false, family2));
        Assert.assertEquals((String)"After first compaction: family1 hfilelink count", (long)0L, (long)this.countHFileLinks(family1));
        Assert.assertEquals((String)"After first compaction: family2 hfilelink count", (long)0L, (long)this.countHFileLinks(family2));
        admin.disableTable(this.tableName);
        admin.restoreSnapshot(snapshotName1);
        admin.enableTable(this.tableName);
        Assert.assertEquals((String)"After restoring snapshot: mob rows count", (long)(regionNum * rowNumPerRegion), (long)this.countMobRows(this.table));
        Assert.assertEquals((String)"After restoring snapshot: mob cells count", (long)(regionNum * cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.table));
        Assert.assertEquals((String)"After restoring snapshot: family1 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family1));
        Assert.assertEquals((String)"After restoring snapshot: family2 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family2));
        Assert.assertEquals((String)"After restoring snapshot: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, family1));
        Assert.assertEquals((String)"After restoring snapshot: family2 del file count", (long)0L, (long)this.countFiles(this.tableName, false, family2));
        Assert.assertEquals((String)"After restoring snapshot: family1 hfilelink count", (long)(regionNum * count), (long)this.countHFileLinks(family1));
        Assert.assertEquals((String)"After restoring snapshot: family2 hfilelink count", (long)0L, (long)this.countHFileLinks(family2));
        compactor.compact();
        Assert.assertEquals((String)"After second compaction: mob rows count", (long)(regionNum * rowNumPerRegion), (long)this.countMobRows(this.table));
        Assert.assertEquals((String)"After second compaction: mob cells count", (long)(regionNum * cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.table));
        Assert.assertEquals((String)"After second compaction: family1 mob file count", (long)regionNum, (long)this.countFiles(this.tableName, true, family1));
        Assert.assertEquals((String)"After second compaction: family2 mob file count", (long)(regionNum * count), (long)this.countFiles(this.tableName, true, family2));
        Assert.assertEquals((String)"After second compaction: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, family1));
        Assert.assertEquals((String)"After second compaction: family2 del file count", (long)0L, (long)this.countFiles(this.tableName, false, family2));
        Assert.assertEquals((String)"After second compaction: family1 hfilelink count", (long)0L, (long)this.countHFileLinks(family1));
        Assert.assertEquals((String)"After second compaction: family2 hfilelink count", (long)0L, (long)this.countHFileLinks(family2));
        this.assertRefFileNameEqual(family1);
    }

    @Test
    public void testMajorCompactionFromAdmin() throws Exception {
        this.resetConf();
        int mergeSize = 5000;
        conf.setLong("hbase.mob.compaction.mergeable.threshold", (long)mergeSize);
        SecureRandom rng = new SecureRandom();
        byte[] keyBytes = new byte[16];
        rng.nextBytes(keyBytes);
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        SecretKeySpec cfKey = new SecretKeySpec(keyBytes, algorithm);
        byte[] encryptionKey = EncryptionUtil.wrapKey((Configuration)conf, (String)conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), (Key)cfKey);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd1 = new HColumnDescriptor(family1);
        hcd1.setMobEnabled(true);
        hcd1.setMobThreshold(0L);
        hcd1.setEncryptionType(algorithm);
        hcd1.setEncryptionKey(encryptionKey);
        HColumnDescriptor hcd2 = new HColumnDescriptor(family2);
        hcd2.setMobEnabled(true);
        hcd2.setMobThreshold(0L);
        desc.addFamily(hcd1);
        desc.addFamily(hcd2);
        admin.createTable((TableDescriptor)desc, this.getSplitKeys());
        Table table = conn.getTable(tableName);
        BufferedMutator bufMut = conn.getBufferedMutator(tableName);
        int count = 4;
        this.loadData(admin, bufMut, tableName, count, rowNumPerFile);
        int rowNumPerRegion = count * rowNumPerFile;
        Assert.assertEquals((String)"Before deleting: mob rows count", (long)(regionNum * rowNumPerRegion), (long)this.countMobRows(table));
        Assert.assertEquals((String)"Before deleting: mob cells count", (long)(regionNum * cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(table));
        Assert.assertEquals((String)"Before deleting: mob file count", (long)(regionNum * count), (long)this.countFiles(tableName, true, family1));
        this.createDelFile(table, tableName, Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1));
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(regionNum * (rowNumPerRegion - delRowNum)), (long)this.countMobRows(table));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(regionNum * (cellNumPerRow * rowNumPerRegion - delCellNum)), (long)this.countMobCells(table));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(regionNum * count), (long)this.countFiles(tableName, true, family1));
        Assert.assertEquals((String)"Before compaction: family2 mob file count", (long)(regionNum * count), (long)this.countFiles(tableName, true, family2));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)regionNum, (long)this.countFiles(tableName, false, family1));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)regionNum, (long)this.countFiles(tableName, false, family2));
        admin.majorCompact(tableName, hcd1.getName(), CompactType.MOB);
        this.waitUntilMobCompactionFinished(tableName);
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(regionNum * (rowNumPerRegion - delRowNum)), (long)this.countMobRows(table));
        Assert.assertEquals((String)"After compaction: mob cells count", (long)(regionNum * (cellNumPerRow * rowNumPerRegion - delCellNum)), (long)this.countMobCells(table));
        Assert.assertEquals((String)"After compaction: family1 mob file count", (long)regionNum, (long)this.countFiles(tableName, true, family1));
        Assert.assertEquals((String)"After compaction: family2 mob file count", (long)(regionNum * count), (long)this.countFiles(tableName, true, family2));
        Assert.assertEquals((String)"After compaction: family1 del file count", (long)0L, (long)this.countFiles(tableName, false, family1));
        Assert.assertEquals((String)"After compaction: family2 del file count", (long)regionNum, (long)this.countFiles(tableName, false, family2));
        Assert.assertTrue((boolean)this.verifyEncryption(tableName, family1));
        table.close();
    }

    @Test
    public void testScannerOnBulkLoadRefHFiles() throws Exception {
        this.resetConf();
        this.setUp("testScannerOnBulkLoadRefHFiles");
        long ts = EnvironmentEdgeManager.currentTime();
        byte[] key0 = Bytes.toBytes((String)"k0");
        byte[] key1 = Bytes.toBytes((String)"k1");
        String value0 = "mobValue0";
        String value1 = "mobValue1";
        String newValue0 = "new";
        Put put0 = new Put(key0);
        put0.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), ts, Bytes.toBytes((String)value0));
        this.loadData(admin, this.bufMut, this.tableName, new Put[]{put0});
        put0 = new Put(key0);
        put0.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), ts, Bytes.toBytes((String)newValue0));
        Put put1 = new Put(key1);
        put1.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), ts, Bytes.toBytes((String)value1));
        this.loadData(admin, this.bufMut, this.tableName, new Put[]{put0, put1});
        Get get = new Get(key0);
        Result result = this.table.get(get);
        Cell cell = result.getColumnLatestCell(this.hcd1.getName(), Bytes.toBytes((String)qf1));
        Assert.assertEquals((String)"Before compaction: mob value of k0", (Object)newValue0, (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell)));
        admin.majorCompact(this.tableName, this.hcd1.getName(), CompactType.MOB);
        this.waitUntilMobCompactionFinished(this.tableName);
        result = this.table.get(get);
        cell = result.getColumnLatestCell(this.hcd1.getName(), Bytes.toBytes((String)qf1));
        Assert.assertEquals((String)"After compaction: mob value of k0", (Object)newValue0, (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell)));
        get = new Get(key1);
        get.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)true));
        result = this.table.get(get);
        cell = result.getColumnLatestCell(this.hcd1.getName(), Bytes.toBytes((String)qf1));
        Path mobFamilyPath = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)this.tableName, (String)this.hcd1.getNameAsString());
        ArrayList<Path> paths = new ArrayList<Path>();
        if (fs.exists(mobFamilyPath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(mobFamilyPath)) {
                if (StoreFileInfo.isDelFile((Path)file.getPath())) continue;
                paths.add(file.getPath());
            }
        }
        Assert.assertEquals((String)"After compaction: number of mob files:", (long)1L, (long)paths.size());
        Assert.assertEquals((String)"After compaction: mob file name:", (Object)MobUtils.getMobFileName((Cell)cell), (Object)((Path)paths.get(0)).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAfterCompaction() throws Exception {
        this.resetConf();
        conf.setLong("hbase.master.hfilecleaner.ttl", 0L);
        String famStr = "f1";
        byte[] fam = Bytes.toBytes((String)famStr);
        byte[] qualifier = Bytes.toBytes((String)"q1");
        byte[] mobVal = Bytes.toBytes((String)"01234567890");
        HTableDescriptor hdt = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        hdt.addCoprocessor(CompactTwoLatestHfilesCopro.class.getName());
        HColumnDescriptor hcd = new HColumnDescriptor(fam);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(10L);
        hcd.setMaxVersions(1);
        hdt.addFamily(hcd);
        try {
            Table table = TEST_UTIL.createTable((TableDescriptor)hdt, (byte[][])null);
            HRegion r = TEST_UTIL.getMiniHBaseCluster().getRegions(hdt.getTableName()).get(0);
            Put p = new Put(Bytes.toBytes((String)"r1"));
            p.addColumn(fam, qualifier, mobVal);
            table.put(p);
            TEST_UTIL.flush(table.getName());
            FileSystem fs = r.getRegionFileSystem().getFileSystem();
            Path path = r.getRegionFileSystem().getStoreDir(famStr);
            this.waitUntilFilesShowup(fs, path, 1);
            p = new Put(Bytes.toBytes((String)"r2"));
            p.addColumn(fam, qualifier, mobVal);
            table.put(p);
            TEST_UTIL.flush(table.getName());
            this.waitUntilFilesShowup(fs, path, 2);
            TEST_UTIL.getAdmin().compact(hdt.getTableName(), fam, CompactType.MOB);
            this.waitUntilFilesShowup(fs, path, 3);
            TEST_UTIL.getAdmin().compact(hdt.getTableName(), fam);
            this.waitUntilFilesShowup(fs, path, 2);
            Thread.sleep(100L);
            TEST_UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
            Get get = new Get(Bytes.toBytes((String)"r2"));
            try {
                Result result = table.get(get);
                Assert.assertTrue((boolean)Arrays.equals(result.getValue(fam, qualifier), mobVal));
            }
            catch (IOException e) {
                Assert.assertTrue((String)"The MOB file doesn't exist", (boolean)false);
            }
        }
        finally {
            TEST_UTIL.deleteTable(hdt.getTableName());
        }
    }

    private void waitUntilFilesShowup(FileSystem fs, Path path, int num) throws InterruptedException, IOException {
        FileStatus[] fileList = fs.listStatus(path);
        while (fileList.length != num) {
            Thread.sleep(50L);
            for (FileStatus fileStatus : fileList = fs.listStatus(path)) {
                LOG.info(Objects.toString(fileStatus));
            }
        }
    }

    private void waitUntilMobCompactionFinished(TableName tableName) throws IOException, InterruptedException {
        long finished = EnvironmentEdgeManager.currentTime() + 60000L;
        CompactionState state = admin.getCompactionState(tableName, CompactType.MOB);
        while (EnvironmentEdgeManager.currentTime() < finished && state != CompactionState.NONE) {
            state = admin.getCompactionState(tableName, CompactType.MOB);
            Thread.sleep(10L);
        }
        Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
    }

    private int countMobRows(Table table) throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        return TEST_UTIL.countRows(table, scan);
    }

    private int countMobCells(Table table) throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            count += res.size();
        }
        results.close();
        return count;
    }

    private int countFiles(TableName tableName, boolean isMobFile, String familyName) throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)familyName);
        int count = 0;
        if (fs.exists(mobDirPath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(mobDirPath)) {
                if (isMobFile) {
                    if (StoreFileInfo.isDelFile((Path)file.getPath())) continue;
                    ++count;
                    continue;
                }
                if (!StoreFileInfo.isDelFile((Path)file.getPath())) continue;
                ++count;
            }
        }
        return count;
    }

    private boolean verifyEncryption(TableName tableName, String familyName) throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)familyName);
        boolean hasFiles = false;
        if (fs.exists(mobDirPath)) {
            FileStatus[] files = fs.listStatus(mobDirPath);
            hasFiles = files != null && files.length > 0;
            Assert.assertTrue((boolean)hasFiles);
            Path path = files[0].getPath();
            CacheConfig cacheConf = new CacheConfig(conf);
            HStoreFile sf = new HStoreFile(TEST_UTIL.getTestFileSystem(), path, conf, cacheConf, BloomType.NONE, true);
            sf.initReader();
            HFile.Reader reader = sf.getReader().getHFileReader();
            byte[] encryptionKey = reader.getTrailer().getEncryptionKey();
            Assert.assertTrue((null != encryptionKey ? 1 : 0) != 0);
            Assert.assertTrue((boolean)reader.getFileContext().getEncryptionContext().getCipher().getName().equals("AES"));
        }
        return hasFiles;
    }

    private int countHFileLinks(String familyName) throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)this.tableName, (String)familyName);
        int count = 0;
        if (fs.exists(mobDirPath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(mobDirPath)) {
                if (!HFileLink.isHFileLink((Path)file.getPath())) continue;
                ++count;
            }
        }
        return count;
    }

    private int countLargeFiles(int size, TableName tableName, String familyName) throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)familyName);
        int count = 0;
        if (fs.exists(mobDirPath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(mobDirPath)) {
                if (StoreFileInfo.isDelFile((Path)file.getPath()) || file.getLen() <= (long)size) continue;
                ++count;
            }
        }
        return count;
    }

    private void loadData(Admin admin, BufferedMutator table, TableName tableName, int fileNum, int rowNumPerFile) throws IOException, InterruptedException {
        if (fileNum <= 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < fileNum * rowNumPerFile; ++i) {
            for (byte k0 : KEYS) {
                byte[] k = new byte[]{k0};
                byte[] key = Bytes.add((byte[])k, (byte[])Bytes.toBytes((int)i));
                byte[] mobVal = this.makeDummyData(10 * (i + 1));
                Put put = new Put(key);
                put.setDurability(Durability.SKIP_WAL);
                put.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), mobVal);
                put.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf2), mobVal);
                put.addColumn(Bytes.toBytes((String)family2), Bytes.toBytes((String)qf1), mobVal);
                table.mutate((Mutation)put);
            }
            if ((i + 1) % rowNumPerFile != 0) continue;
            table.flush();
            admin.flush(tableName);
        }
    }

    private void loadData(Admin admin, BufferedMutator table, TableName tableName, Put[] puts) throws IOException {
        table.mutate(Arrays.asList(puts));
        table.flush();
        admin.flush(tableName);
    }

    private void loadDataForPartitionPolicy(Admin admin, BufferedMutator table, TableName tableName) throws IOException {
        Put[] pArray = new Put[1000];
        for (int i = 0; i < 1000; ++i) {
            Put put0 = new Put(Bytes.toBytes((String)("r0" + i)));
            put0.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20151130Monday, Bytes.toBytes((String)mobValue0));
            pArray[i] = put0;
        }
        this.loadData(admin, this.bufMut, tableName, pArray);
        Put put06 = new Put(mobKey06);
        put06.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20151128Saturday, Bytes.toBytes((String)mobValue0));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put06});
        Put put1 = new Put(mobKey1);
        put1.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20151201Tuesday, Bytes.toBytes((String)mobValue1));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put1});
        Put put2 = new Put(mobKey2);
        put2.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20151205Saturday, Bytes.toBytes((String)mobValue2));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put2});
        Put put3 = new Put(mobKey3);
        put3.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20151228Monday, Bytes.toBytes((String)mobValue3));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put3});
        Put put4 = new Put(mobKey4);
        put4.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20151231Thursday, Bytes.toBytes((String)mobValue4));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put4});
        Put put5 = new Put(mobKey5);
        put5.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20160101Friday, Bytes.toBytes((String)mobValue5));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put5});
        Put put6 = new Put(mobKey6);
        put6.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20160103Sunday, Bytes.toBytes((String)mobValue6));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put6});
        Put put7 = new Put(mobKey7);
        put7.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20150907Monday, Bytes.toBytes((String)mobValue7));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put7});
        Put put8 = new Put(mobKey8);
        put8.addColumn(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1), tsFor20151120Sunday, Bytes.toBytes((String)mobValue8));
        this.loadData(admin, this.bufMut, tableName, new Put[]{put8});
    }

    private void createDelFile(Table table, TableName tableName, byte[] family, byte[] qf) throws IOException, InterruptedException {
        for (byte k0 : KEYS) {
            byte[] k = new byte[]{k0};
            byte[] key1 = Bytes.add((byte[])k, (byte[])Bytes.toBytes((int)0));
            Delete delete1 = new Delete(key1);
            delete1.addFamily(family);
            table.delete(delete1);
            byte[] key2 = Bytes.add((byte[])k, (byte[])Bytes.toBytes((int)2));
            Delete delete2 = new Delete(key2);
            table.delete(delete2);
            byte[] key3 = Bytes.add((byte[])k, (byte[])Bytes.toBytes((int)4));
            Delete delete3 = new Delete(key3);
            delete3.addColumn(family, qf);
            table.delete(delete3);
        }
        admin.flush(tableName);
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
        for (HRegion region : regions) {
            region.waitForFlushesAndCompactions();
            region.compact(true);
        }
    }

    private byte[] makeDummyData(int size) {
        byte[] dummyData = new byte[size];
        new Random().nextBytes(dummyData);
        return dummyData;
    }

    private byte[][] getSplitKeys() {
        byte[][] splitKeys = new byte[KEYS.length - 1][];
        for (int i = 0; i < splitKeys.length; ++i) {
            splitKeys[i] = new byte[]{KEYS[i + 1]};
        }
        return splitKeys;
    }

    private static ExecutorService createThreadPool(Configuration conf) {
        int maxThreads = 10;
        long keepAliveTime = 60L;
        final SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, queue, Threads.newDaemonThreadFactory((String)"MobFileCompactionChore"), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    queue.put(r);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        });
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private void assertRefFileNameEqual(String familyName) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)familyName));
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner results = this.table.getScanner(scan);
        Path mobFamilyPath = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)this.tableName, (String)familyName);
        ArrayList<Path> actualFilePaths = new ArrayList<Path>();
        ArrayList<Path> expectFilePaths = new ArrayList<Path>();
        for (Result res : results) {
            for (Cell cell : res.listCells()) {
                byte[] referenceValue = CellUtil.cloneValue((Cell)cell);
                String fileName = Bytes.toString((byte[])referenceValue, (int)4, (int)(referenceValue.length - 4));
                Path targetPath = new Path(mobFamilyPath, fileName);
                if (actualFilePaths.contains(targetPath)) continue;
                actualFilePaths.add(targetPath);
            }
        }
        results.close();
        if (fs.exists(mobFamilyPath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(mobFamilyPath)) {
                if (StoreFileInfo.isDelFile((Path)file.getPath())) continue;
                expectFilePaths.add(file.getPath());
            }
        }
        Collections.sort(actualFilePaths);
        Collections.sort(expectFilePaths);
        Assert.assertEquals(expectFilePaths, actualFilePaths);
    }

    private void resetConf() {
        conf.setLong("hbase.mob.compaction.mergeable.threshold", 0x50000000L);
        conf.setInt("hbase.mob.compaction.batch.size", 100);
    }

    private void verifyPolicyValues() throws Exception {
        Get get = new Get(mobKey01);
        Result result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue0)));
        get = new Get(mobKey02);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue0)));
        get = new Get(mobKey03);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue0)));
        get = new Get(mobKey04);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue0)));
        get = new Get(mobKey05);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue0)));
        get = new Get(mobKey06);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue0)));
        get = new Get(mobKey1);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue1)));
        get = new Get(mobKey2);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue2)));
        get = new Get(mobKey3);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue3)));
        get = new Get(mobKey4);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue4)));
        get = new Get(mobKey5);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue5)));
        get = new Get(mobKey6);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue6)));
        get = new Get(mobKey7);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue7)));
        get = new Get(mobKey8);
        result = this.table.get(get);
        Assert.assertTrue((boolean)Arrays.equals(result.getValue(Bytes.toBytes((String)family1), Bytes.toBytes((String)qf1)), Bytes.toBytes((String)mobValue8)));
    }

    private void commonPolicyTestLogic(String tableNameAsString, MobCompactPartitionPolicy pType, boolean majorCompact, int expectedFileNumbers, String[] expectedFileNames, boolean setupAndLoadData) throws Exception {
        if (setupAndLoadData) {
            this.setUpForPolicyTest(tableNameAsString, pType);
            this.loadDataForPartitionPolicy(admin, this.bufMut, this.tableName);
        } else {
            this.alterForPolicyTest(pType);
        }
        if (majorCompact) {
            admin.majorCompact(this.tableName, this.hcd1.getName(), CompactType.MOB);
        } else {
            admin.compact(this.tableName, this.hcd1.getName(), CompactType.MOB);
        }
        this.waitUntilMobCompactionFinished(this.tableName);
        TEST_UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)this.tableName, (String)family1);
        FileStatus[] fileList = fs.listStatus(mobDirPath);
        Assert.assertTrue((fileList.length == expectedFileNumbers ? 1 : 0) != 0);
        ArrayList<String> fileNames = new ArrayList<String>(expectedFileNumbers);
        for (FileStatus file : fileList) {
            fileNames.add(MobFileName.getDateFromName((String)file.getPath().getName()));
        }
        int index = 0;
        for (String fileName : expectedFileNames) {
            index = fileNames.indexOf(fileName);
            Assert.assertTrue((index >= 0 ? 1 : 0) != 0);
            fileNames.remove(index);
        }
        this.verifyPolicyValues();
    }

    static {
        mobKey01 = Bytes.toBytes((String)"r01");
        mobKey02 = Bytes.toBytes((String)"r02");
        mobKey03 = Bytes.toBytes((String)"r03");
        mobKey04 = Bytes.toBytes((String)"r04");
        mobKey05 = Bytes.toBytes((String)"r05");
        mobKey06 = Bytes.toBytes((String)"r05");
        mobKey1 = Bytes.toBytes((String)"r1");
        mobKey2 = Bytes.toBytes((String)"r2");
        mobKey3 = Bytes.toBytes((String)"r3");
        mobKey4 = Bytes.toBytes((String)"r4");
        mobKey5 = Bytes.toBytes((String)"r5");
        mobKey6 = Bytes.toBytes((String)"r6");
        mobKey7 = Bytes.toBytes((String)"r7");
        mobKey8 = Bytes.toBytes((String)"r8");
        KEYS = Bytes.toBytes((String)"012");
        regionNum = KEYS.length;
        delRowNum = 1;
        delCellNum = 6;
        cellNumPerRow = 3;
        rowNumPerFile = 2;
    }

    public static class CompactTwoLatestHfilesCopro
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> candidates, CompactionLifeCycleTracker tracker) throws IOException {
            int count = candidates.size();
            if (count >= 2) {
                for (int i = 0; i < count - 2; ++i) {
                    candidates.remove(0);
                }
                c.bypass();
            }
        }
    }
}

