/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestTableDescriptorModificationFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableDescriptorModificationFromClient.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = null;
    private static final byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
    private static final byte[] FAMILY_1 = Bytes.toBytes((String)"cf1");

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @Before
    public void setup() {
        TABLE_NAME = TableName.valueOf((String)this.name.getMethodName());
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyTable() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            HTableDescriptor modifiedHtd = new HTableDescriptor(TABLE_NAME);
            modifiedHtd.addFamily(new HColumnDescriptor(FAMILY_0));
            modifiedHtd.addFamily(new HColumnDescriptor(FAMILY_1));
            admin.modifyTable(TABLE_NAME, (TableDescriptor)modifiedHtd);
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    @Test
    public void testAddColumn() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            admin.addColumnFamily(TABLE_NAME, (ColumnFamilyDescriptor)new HColumnDescriptor(FAMILY_1));
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSameColumnFamilyTwice() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            admin.addColumnFamily(TABLE_NAME, (ColumnFamilyDescriptor)new HColumnDescriptor(FAMILY_1));
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
            try {
                admin.addColumnFamily(TABLE_NAME, (ColumnFamilyDescriptor)new HColumnDescriptor(FAMILY_1));
                Assert.fail((String)"Delete a non-exist column family should fail");
            }
            catch (InvalidFamilyOperationException invalidFamilyOperationException) {
                // empty catch block
            }
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyColumnFamily() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HColumnDescriptor cfDescriptor = new HColumnDescriptor(FAMILY_0);
        int blockSize = cfDescriptor.getBlocksize();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(cfDescriptor);
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            int newBlockSize = 2 * blockSize;
            cfDescriptor.setBlocksize(newBlockSize);
            admin.modifyColumnFamily(TABLE_NAME, (ColumnFamilyDescriptor)cfDescriptor);
            HTableDescriptor htd = admin.getTableDescriptor(TABLE_NAME);
            HColumnDescriptor hcfd = htd.getFamily(FAMILY_0);
            Assert.assertTrue((hcfd.getBlocksize() == newBlockSize ? 1 : 0) != 0);
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyNonExistingColumnFamily() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HColumnDescriptor cfDescriptor = new HColumnDescriptor(FAMILY_1);
        int blockSize = cfDescriptor.getBlocksize();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            int newBlockSize = 2 * blockSize;
            cfDescriptor.setBlocksize(newBlockSize);
            try {
                admin.modifyColumnFamily(TABLE_NAME, (ColumnFamilyDescriptor)cfDescriptor);
                Assert.fail((String)"Modify a non-exist column family should fail");
            }
            catch (InvalidFamilyOperationException invalidFamilyOperationException) {
                // empty catch block
            }
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    @Test
    public void testDeleteColumn() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_1));
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
            admin.deleteColumnFamily(TABLE_NAME, FAMILY_1);
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteSameColumnFamilyTwice() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_1));
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
            admin.deleteColumnFamily(TABLE_NAME, FAMILY_1);
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            try {
                admin.deleteColumnFamily(TABLE_NAME, FAMILY_1);
                Assert.fail((String)"Delete a non-exist column family should fail");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    private void verifyTableDescriptor(TableName tableName, byte[] ... families) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor htd = admin.getTableDescriptor(tableName);
        this.verifyTableDescriptor((TableDescriptor)htd, tableName, families);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        TableDescriptor td = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)mfs.getFileSystem(), (Path)tableDir);
        this.verifyTableDescriptor(td, tableName, families);
    }

    private void verifyTableDescriptor(TableDescriptor htd, TableName tableName, byte[] ... families) {
        Set htdFamilies = htd.getColumnFamilyNames();
        Assert.assertEquals((Object)tableName, (Object)htd.getTableName());
        Assert.assertEquals((long)families.length, (long)htdFamilies.size());
        for (byte[] familyName : families) {
            Assert.assertTrue((String)("Expected family " + Bytes.toString((byte[])familyName)), (boolean)htdFamilies.contains(familyName));
        }
    }
}

