/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterShutdown {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterShutdown.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterShutdown.class);

    @Test
    public void testMasterShutdown() throws Exception {
        int NUM_MASTERS = 3;
        int NUM_RS = 3;
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtility htu = new HBaseTestingUtility(conf);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(3).numRegionServers(3).numDataNodes(3).build();
        htu.startMiniCluster(option);
        MiniHBaseCluster cluster = htu.getHBaseCluster();
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (JVMClusterUtil.MasterThread mt : masterThreads) {
            Assert.assertTrue((boolean)mt.isAlive());
        }
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            active = masterThreads.get(i).getMaster();
            break;
        }
        Assert.assertNotNull(active);
        ClusterMetrics status = active.getClusterMetrics();
        Assert.assertEquals((long)2L, (long)status.getBackupMasterNames().size());
        active.shutdown();
        for (int i = 2; i >= 0; --i) {
            cluster.waitOnMaster(i);
        }
        Assert.assertEquals((long)0L, (long)masterThreads.size());
        htu.shutdownMiniCluster();
    }

    @Test
    public void testMasterShutdownBeforeStartingAnyRegionServer() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = false;
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.ipc.client.failed.servers.expiry", 200);
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        final HBaseTestingUtility util = new HBaseTestingUtility(conf);
        util.startMiniDFSCluster(3);
        util.startMiniZKCluster();
        util.createRootDir();
        final LocalHBaseCluster cluster = new LocalHBaseCluster(conf, 1, 0, HMaster.class, MiniHBaseCluster.MiniHBaseClusterRegionServer.class);
        boolean MASTER_INDEX = false;
        JVMClusterUtil.MasterThread master = (JVMClusterUtil.MasterThread)cluster.getMasters().get(0);
        master.start();
        LOG.info("Called master start on " + master.getName());
        Thread shutdownThread = new Thread("Shutdown-Thread"){

            @Override
            public void run() {
                LOG.info("Before call to shutdown master");
                try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());
                     Admin admin = connection.getAdmin();){
                    admin.shutdown();
                }
                catch (Exception e) {
                    LOG.info("Error while calling Admin.shutdown, which is expected: " + e.getMessage());
                }
                LOG.info("After call to shutdown master");
                cluster.waitOnMaster(0);
            }
        };
        shutdownThread.start();
        LOG.info("Called master join on " + master.getName());
        master.join();
        shutdownThread.join();
        List masterThreads = cluster.getMasters();
        Assert.assertEquals((long)0L, (long)masterThreads.size());
        util.shutdownMiniZKCluster();
        util.shutdownMiniDFSCluster();
        util.cleanupTestDir();
    }
}

