/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCloseAnOpeningRegion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCloseAnOpeningRegion.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"race");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static volatile CountDownLatch ARRIVE;
    private static volatile CountDownLatch RESUME;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.rpc.shortoperation.timeout", 60000);
        UTIL.startMiniCluster(StartMiniClusterOption.builder().numRegionServers(2).masterClass(MockHMaster.class).build());
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws IOException, InterruptedException {
        ARRIVE = new CountDownLatch(1);
        RESUME = new CountDownLatch(1);
        RegionInfo region = (RegionInfo)UTIL.getAdmin().getRegions(TABLE_NAME).get(0);
        HRegionServer src = UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        HRegionServer dst = UTIL.getOtherRegionServer(src);
        Thread move0 = new Thread(() -> {
            try {
                UTIL.getAdmin().move(region.getEncodedNameAsBytes(), dst.getServerName());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        move0.start();
        ARRIVE.await();
        Thread move1 = new Thread(() -> {
            try {
                UTIL.getAdmin().move(region.getEncodedNameAsBytes(), src.getServerName());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        move1.start();
        Thread.sleep(10000L);
        RESUME.countDown();
        move0.join();
        move1.join();
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);){
            table.put(new Put(Bytes.toBytes((int)0)).addColumn(CF, Bytes.toBytes((String)"cq"), Bytes.toBytes((int)0)));
        }
    }

    public static final class MockHMaster
    extends HMaster {
        public MockHMaster(Configuration conf) throws IOException, KeeperException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master) {
            return new AssignmentManager(master){

                public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
                    RegionServerStatusProtos.ReportRegionStateTransitionResponse resp = super.reportRegionStateTransition(req);
                    RegionServerStatusProtos.RegionStateTransition.TransitionCode code = req.getTransition(0).getTransitionCode();
                    if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED && ARRIVE != null) {
                        ARRIVE.countDown();
                        try {
                            RESUME.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return resp;
                }
            };
        }
    }
}

