/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.SimpleRpcScheduler;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, SmallTests.class})
public class TestRpcHandlerException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcHandlerException.class);
    private static final Configuration CONF = HBaseConfiguration.create();
    @Parameterized.Parameter(value=0)
    public String rpcServerImpl;

    @Parameterized.Parameters(name="{index}: rpcServerImpl={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({SimpleRpcServer.class.getName()}, {NettyRpcServer.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testRpcScheduler() throws IOException, InterruptedException {
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        AbortServer abortable = new AbortServer();
        CONF.set("hbase.rpc.server.impl", this.rpcServerImpl);
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(CONF, 2, 0, 0, 0, qosFunction, (Abortable)abortable, 0);
        RpcServer rpcServer = RpcServerFactory.createRpcServer(null, (String)"testRpcServer", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), (InetSocketAddress)new InetSocketAddress("localhost", 0), (Configuration)CONF, (RpcScheduler)scheduler);
        try (BlockingRpcClient client = new BlockingRpcClient(CONF);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub((RpcClient)client, rpcServer.getListenerAddress());
            stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build());
        }
        catch (Throwable e) {
            assert (abortable.isAborted());
        }
        finally {
            rpcServer.stop();
        }
    }

    private class AbortServer
    implements Abortable {
        private boolean aborted = false;

        private AbortServer() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

