/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, MediumTests.class})
public class TestProtoBufRpc {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProtoBufRpc.class);
    public static final String ADDRESS = "localhost";
    public static int PORT = 0;
    private InetSocketAddress isa;
    private Configuration conf;
    private RpcServerInterface server;
    @Parameterized.Parameter(value=0)
    public String rpcServerImpl;

    @Parameterized.Parameters(name="{index}: rpcServerImpl={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({SimpleRpcServer.class.getName()}, {NettyRpcServer.class.getName()});
    }

    @Before
    public void setUp() throws IOException {
        this.conf = HBaseConfiguration.create();
        this.conf.set("hbase.rpc.server.impl", this.rpcServerImpl);
        Logger log = Logger.getLogger((String)"org.apache.hadoop.ipc.HBaseServer");
        log.setLevel(Level.DEBUG);
        log = Logger.getLogger((String)"org.apache.hadoop.ipc.HBaseServer.trace");
        log.setLevel(Level.TRACE);
        this.server = RpcServerFactory.createRpcServer(null, (String)"testrpc", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), (InetSocketAddress)new InetSocketAddress(ADDRESS, PORT), (Configuration)this.conf, (RpcScheduler)new FifoRpcScheduler(this.conf, 10));
        InetSocketAddress address = this.server.getListenerAddress();
        if (address == null) {
            throw new IOException("Listener channel is closed");
        }
        this.isa = address;
        this.server.start();
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ServiceException.class)
    public void testProtoBufRpc() throws Exception {
        try (RpcClient rpcClient = RpcClientFactory.createClient((Configuration)this.conf, (String)"default-cluster");){
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(rpcClient, this.isa);
            TestProtos.EmptyRequestProto emptyRequest = TestProtos.EmptyRequestProto.newBuilder().build();
            stub.ping(null, emptyRequest);
            TestProtos.EchoRequestProto echoRequest = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            TestProtos.EchoResponseProto echoResponse = stub.echo(null, echoRequest);
            Assert.assertEquals((Object)"hello", (Object)echoResponse.getMessage());
            stub.error(null, emptyRequest);
            Assert.fail((String)"Expected exception is not thrown");
        }
    }
}

