/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.Message;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.security.User;

public class MasterAnnotationReadingPriorityFunction
extends AnnotationReadingPriorityFunction {
    public MasterAnnotationReadingPriorityFunction(RSRpcServices rpcServices) {
        this(rpcServices, rpcServices.getClass());
    }

    public MasterAnnotationReadingPriorityFunction(RSRpcServices rpcServices, Class<? extends RSRpcServices> clz) {
        super(rpcServices, clz);
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        int priorityByAnnotation = this.getAnnotatedPriority(header);
        if (priorityByAnnotation >= 0) {
            return priorityByAnnotation;
        }
        if (param instanceof RegionServerStatusProtos.ReportRegionStateTransitionRequest) {
            RegionServerStatusProtos.ReportRegionStateTransitionRequest tRequest = (RegionServerStatusProtos.ReportRegionStateTransitionRequest)param;
            for (RegionServerStatusProtos.RegionStateTransition rst : tRequest.getTransitionList()) {
                for (HBaseProtos.RegionInfo info : rst.getRegionInfoList()) {
                    TableName tn = ProtobufUtil.toTableName((TableProtos.TableName)info.getTableName());
                    if (!tn.isSystemTable()) continue;
                    return 200;
                }
            }
            return 0;
        }
        return this.getBasePriority(header, param);
    }
}

