/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.metrics.impl.FastLongHistogram;
import org.apache.hadoop.hbase.util.Counter;

@InterfaceAudience.Private
public class CacheStats {
    static final int DEFAULT_WINDOW_PERIODS = 5;
    private final Counter hitCount = new Counter();
    private final Counter primaryHitCount = new Counter();
    private final Counter hitCachingCount = new Counter();
    private final Counter missCount = new Counter();
    private final Counter primaryMissCount = new Counter();
    private final Counter missCachingCount = new Counter();
    private final Counter evictionCount = new Counter();
    private final Counter evictedBlockCount = new Counter();
    private final Counter primaryEvictedBlockCount = new Counter();
    private final AtomicLong failedInserts = new AtomicLong(0L);
    private final Counter dataMissCount = new Counter(0L);
    private final Counter leafIndexMissCount = new Counter(0L);
    private final Counter bloomChunkMissCount = new Counter(0L);
    private final Counter metaMissCount = new Counter(0L);
    private final Counter rootIndexMissCount = new Counter(0L);
    private final Counter intermediateIndexMissCount = new Counter(0L);
    private final Counter fileInfoMissCount = new Counter(0L);
    private final Counter generalBloomMetaMissCount = new Counter(0L);
    private final Counter deleteFamilyBloomMissCount = new Counter(0L);
    private final Counter trailerMissCount = new Counter(0L);
    private final Counter dataHitCount = new Counter(0L);
    private final Counter leafIndexHitCount = new Counter(0L);
    private final Counter bloomChunkHitCount = new Counter(0L);
    private final Counter metaHitCount = new Counter(0L);
    private final Counter rootIndexHitCount = new Counter(0L);
    private final Counter intermediateIndexHitCount = new Counter(0L);
    private final Counter fileInfoHitCount = new Counter(0L);
    private final Counter generalBloomMetaHitCount = new Counter(0L);
    private final Counter deleteFamilyBloomHitCount = new Counter(0L);
    private final Counter trailerHitCount = new Counter(0L);
    private final int numPeriodsInWindow;
    private final long[] hitCounts;
    private final long[] hitCachingCounts;
    private final long[] requestCounts;
    private final long[] requestCachingCounts;
    private long lastHitCount = 0L;
    private long lastHitCachingCount = 0L;
    private long lastRequestCount = 0L;
    private long lastRequestCachingCount = 0L;
    private int windowIndex = 0;
    private FastLongHistogram ageAtEviction;
    private long startTime = System.nanoTime();

    public CacheStats(String name) {
        this(name, 5);
    }

    public CacheStats(String name, int numPeriodsInWindow) {
        this.numPeriodsInWindow = numPeriodsInWindow;
        this.hitCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.hitCachingCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.requestCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.requestCachingCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.ageAtEviction = new FastLongHistogram();
    }

    public String toString() {
        AgeSnapshot snapshot = this.getAgeAtEvictionSnapshot();
        return "hitCount=" + this.getHitCount() + ", hitCachingCount=" + this.getHitCachingCount() + ", missCount=" + this.getMissCount() + ", missCachingCount=" + this.getMissCachingCount() + ", evictionCount=" + this.getEvictionCount() + ", evictedBlockCount=" + this.getEvictedCount() + ", primaryMissCount=" + this.getPrimaryMissCount() + ", primaryHitCount=" + this.getPrimaryHitCount() + ", evictedAgeMean=" + snapshot.getMean();
    }

    public void miss(boolean caching, boolean primary, BlockType type) {
        this.missCount.increment();
        if (primary) {
            this.primaryMissCount.increment();
        }
        if (caching) {
            this.missCachingCount.increment();
        }
        if (type == null) {
            return;
        }
        switch (type) {
            case DATA: 
            case ENCODED_DATA: {
                this.dataMissCount.increment();
                break;
            }
            case LEAF_INDEX: {
                this.leafIndexMissCount.increment();
                break;
            }
            case BLOOM_CHUNK: {
                this.bloomChunkMissCount.increment();
                break;
            }
            case META: {
                this.metaMissCount.increment();
                break;
            }
            case INTERMEDIATE_INDEX: {
                this.intermediateIndexMissCount.increment();
                break;
            }
            case ROOT_INDEX: {
                this.rootIndexMissCount.increment();
                break;
            }
            case FILE_INFO: {
                this.fileInfoMissCount.increment();
                break;
            }
            case GENERAL_BLOOM_META: {
                this.generalBloomMetaMissCount.increment();
                break;
            }
            case DELETE_FAMILY_BLOOM_META: {
                this.deleteFamilyBloomMissCount.increment();
                break;
            }
            case TRAILER: {
                this.trailerMissCount.increment();
                break;
            }
        }
    }

    public void hit(boolean caching, boolean primary, BlockType type) {
        this.hitCount.increment();
        if (primary) {
            this.primaryHitCount.increment();
        }
        if (caching) {
            this.hitCachingCount.increment();
        }
        if (type == null) {
            return;
        }
        switch (type) {
            case DATA: 
            case ENCODED_DATA: {
                this.dataHitCount.increment();
                break;
            }
            case LEAF_INDEX: {
                this.leafIndexHitCount.increment();
                break;
            }
            case BLOOM_CHUNK: {
                this.bloomChunkHitCount.increment();
                break;
            }
            case META: {
                this.metaHitCount.increment();
                break;
            }
            case INTERMEDIATE_INDEX: {
                this.intermediateIndexHitCount.increment();
                break;
            }
            case ROOT_INDEX: {
                this.rootIndexHitCount.increment();
                break;
            }
            case FILE_INFO: {
                this.fileInfoHitCount.increment();
                break;
            }
            case GENERAL_BLOOM_META: {
                this.generalBloomMetaHitCount.increment();
                break;
            }
            case DELETE_FAMILY_BLOOM_META: {
                this.deleteFamilyBloomHitCount.increment();
                break;
            }
            case TRAILER: {
                this.trailerHitCount.increment();
                break;
            }
        }
    }

    public void evict() {
        this.evictionCount.increment();
    }

    public void evicted(long t, boolean primary) {
        if (t > this.startTime) {
            this.ageAtEviction.add((t - this.startTime) / 1000000000L, 1L);
        }
        this.evictedBlockCount.increment();
        if (primary) {
            this.primaryEvictedBlockCount.increment();
        }
    }

    public long failInsert() {
        return this.failedInserts.incrementAndGet();
    }

    public long getDataMissCount() {
        return this.dataMissCount.get();
    }

    public long getLeafIndexMissCount() {
        return this.leafIndexMissCount.get();
    }

    public long getBloomChunkMissCount() {
        return this.bloomChunkMissCount.get();
    }

    public long getMetaMissCount() {
        return this.metaMissCount.get();
    }

    public long getRootIndexMissCount() {
        return this.rootIndexMissCount.get();
    }

    public long getIntermediateIndexMissCount() {
        return this.intermediateIndexMissCount.get();
    }

    public long getFileInfoMissCount() {
        return this.fileInfoMissCount.get();
    }

    public long getGeneralBloomMetaMissCount() {
        return this.generalBloomMetaMissCount.get();
    }

    public long getDeleteFamilyBloomMissCount() {
        return this.deleteFamilyBloomMissCount.get();
    }

    public long getTrailerMissCount() {
        return this.trailerMissCount.get();
    }

    public long getDataHitCount() {
        return this.dataHitCount.get();
    }

    public long getLeafIndexHitCount() {
        return this.leafIndexHitCount.get();
    }

    public long getBloomChunkHitCount() {
        return this.bloomChunkHitCount.get();
    }

    public long getMetaHitCount() {
        return this.metaHitCount.get();
    }

    public long getRootIndexHitCount() {
        return this.rootIndexHitCount.get();
    }

    public long getIntermediateIndexHitCount() {
        return this.intermediateIndexHitCount.get();
    }

    public long getFileInfoHitCount() {
        return this.fileInfoHitCount.get();
    }

    public long getGeneralBloomMetaHitCount() {
        return this.generalBloomMetaHitCount.get();
    }

    public long getDeleteFamilyBloomHitCount() {
        return this.deleteFamilyBloomHitCount.get();
    }

    public long getTrailerHitCount() {
        return this.trailerHitCount.get();
    }

    public long getRequestCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public long getRequestCachingCount() {
        return this.getHitCachingCount() + this.getMissCachingCount();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    public long getPrimaryMissCount() {
        return this.primaryMissCount.get();
    }

    public long getMissCachingCount() {
        return this.missCachingCount.get();
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long getPrimaryHitCount() {
        return this.primaryHitCount.get();
    }

    public long getHitCachingCount() {
        return this.hitCachingCount.get();
    }

    public long getEvictionCount() {
        return this.evictionCount.get();
    }

    public long getEvictedCount() {
        return this.evictedBlockCount.get();
    }

    public long getPrimaryEvictedCount() {
        return this.primaryEvictedBlockCount.get();
    }

    public double getHitRatio() {
        return (float)this.getHitCount() / (float)this.getRequestCount();
    }

    public double getHitCachingRatio() {
        return (float)this.getHitCachingCount() / (float)this.getRequestCachingCount();
    }

    public double getMissRatio() {
        return (float)this.getMissCount() / (float)this.getRequestCount();
    }

    public double getMissCachingRatio() {
        return (float)this.getMissCachingCount() / (float)this.getRequestCachingCount();
    }

    public double evictedPerEviction() {
        return (float)this.getEvictedCount() / (float)this.getEvictionCount();
    }

    public long getFailedInserts() {
        return this.failedInserts.get();
    }

    public void rollMetricsPeriod() {
        this.hitCounts[this.windowIndex] = this.getHitCount() - this.lastHitCount;
        this.lastHitCount = this.getHitCount();
        this.hitCachingCounts[this.windowIndex] = this.getHitCachingCount() - this.lastHitCachingCount;
        this.lastHitCachingCount = this.getHitCachingCount();
        this.requestCounts[this.windowIndex] = this.getRequestCount() - this.lastRequestCount;
        this.lastRequestCount = this.getRequestCount();
        this.requestCachingCounts[this.windowIndex] = this.getRequestCachingCount() - this.lastRequestCachingCount;
        this.lastRequestCachingCount = this.getRequestCachingCount();
        this.windowIndex = (this.windowIndex + 1) % this.numPeriodsInWindow;
    }

    public long getSumHitCountsPastNPeriods() {
        return CacheStats.sum(this.hitCounts);
    }

    public long getSumRequestCountsPastNPeriods() {
        return CacheStats.sum(this.requestCounts);
    }

    public long getSumHitCachingCountsPastNPeriods() {
        return CacheStats.sum(this.hitCachingCounts);
    }

    public long getSumRequestCachingCountsPastNPeriods() {
        return CacheStats.sum(this.requestCachingCounts);
    }

    public double getHitRatioPastNPeriods() {
        double ratio = (double)this.getSumHitCountsPastNPeriods() / (double)this.getSumRequestCountsPastNPeriods();
        return Double.isNaN(ratio) ? 0.0 : ratio;
    }

    public double getHitCachingRatioPastNPeriods() {
        double ratio = (double)this.getSumHitCachingCountsPastNPeriods() / (double)this.getSumRequestCachingCountsPastNPeriods();
        return Double.isNaN(ratio) ? 0.0 : ratio;
    }

    public AgeSnapshot getAgeAtEvictionSnapshot() {
        return new AgeSnapshot(this.ageAtEviction);
    }

    private static long sum(long[] counts) {
        long sum = 0L;
        for (long count : counts) {
            sum += count;
        }
        return sum;
    }

    private static long[] initializeZeros(int n) {
        long[] zeros = new long[n];
        for (int i = 0; i < n; ++i) {
            zeros[i] = 0L;
        }
        return zeros;
    }
}

