/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestCleanerChore {
    private static final Log LOG = LogFactory.getLog(TestCleanerChore.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @After
    public void cleanup() throws Exception {
        UTIL.cleanupTestDir();
    }

    @Test
    public void testSavesFilesOnRequest() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, NeverDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey);
        Path parent = new Path(testDir, "parent");
        Path file = new Path(parent, "someFile");
        fs.mkdirs(parent);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        chore.chore();
        Assert.assertTrue((String)"File didn't get deleted", (boolean)fs.exists(file));
        Assert.assertTrue((String)"Empty directory didn't get deleted", (boolean)fs.exists(parent));
    }

    @Test
    public void testDeletesEmptyDirectories() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey);
        Path parent = new Path(testDir, "parent");
        Path child = new Path(parent, "child");
        Path emptyChild = new Path(parent, "emptyChild");
        Path file = new Path(child, "someFile");
        fs.mkdirs(child);
        fs.mkdirs(emptyChild);
        fs.create(file).close();
        Path topFile = new Path(testDir, "topFile");
        fs.create(topFile).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(topFile));
        chore.chore();
        Assert.assertFalse((String)"File didn't get deleted", (boolean)fs.exists(topFile));
        Assert.assertFalse((String)"File didn't get deleted", (boolean)fs.exists(file));
        Assert.assertFalse((String)"Empty directory didn't get deleted", (boolean)fs.exists(child));
        Assert.assertFalse((String)"Empty directory didn't get deleted", (boolean)fs.exists(parent));
    }

    @Test
    public void testDoesNotCheckDirectories() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey);
        AlwaysDelete delegate = (AlwaysDelete)((Object)chore.cleanersChain.get(0));
        AlwaysDelete spy = (AlwaysDelete)((Object)Mockito.spy((Object)((Object)delegate)));
        chore.cleanersChain.set(0, spy);
        Path parent = new Path(testDir, "parent");
        Path file = new Path(parent, "someFile");
        fs.mkdirs(parent);
        Assert.assertTrue((String)"Test parent didn't get created.", (boolean)fs.exists(parent));
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        FileStatus fStat = fs.getFileStatus(parent);
        chore.chore();
        ((AlwaysDelete)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.never()))).isFileDeletable(fStat);
        Mockito.reset((Object[])new AlwaysDelete[]{spy});
    }

    @Test
    public void testStoppedCleanerDoesNotDeleteFiles() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey);
        Path topFile = new Path(testDir, "topFile");
        fs.create(topFile).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(topFile));
        stop.stop("testing stop");
        chore.chore();
        Assert.assertTrue((String)"File got deleted while chore was stopped", (boolean)fs.exists(topFile));
    }

    @Test
    public void testCleanerDoesNotDeleteDirectoryWithLateAddedFiles() throws IOException {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        final Path testDir = UTIL.getDataTestDir();
        final FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey);
        AlwaysDelete delegate = (AlwaysDelete)((Object)chore.cleanersChain.get(0));
        AlwaysDelete spy = (AlwaysDelete)((Object)Mockito.spy((Object)((Object)delegate)));
        chore.cleanersChain.set(0, spy);
        Path parent = new Path(testDir, "parent");
        Path file = new Path(parent, "someFile");
        fs.mkdirs(parent);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        final Path addedFile = new Path(parent, "addedFile");
        ((AlwaysDelete)((Object)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                fs.create(addedFile).close();
                FSUtils.logFileSystemState((FileSystem)fs, (Path)testDir, (Log)LOG);
                return (Boolean)invocation.callRealMethod();
            }
        }).when((Object)spy))).isFileDeletable((FileStatus)Mockito.any(FileStatus.class));
        chore.chore();
        Assert.assertTrue((String)"Added file unexpectedly deleted", (boolean)fs.exists(addedFile));
        Assert.assertTrue((String)"Parent directory deleted unexpectedly", (boolean)fs.exists(parent));
        Assert.assertFalse((String)"Original file unexpectedly retained", (boolean)fs.exists(file));
        ((AlwaysDelete)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).isFileDeletable((FileStatus)Mockito.any(FileStatus.class));
        Mockito.reset((Object[])new AlwaysDelete[]{spy});
    }

    @Test
    public void testNoExceptionFromDirectoryWithRacyChildren() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        HBaseTestingUtility localUtil = new HBaseTestingUtility();
        Configuration conf = localUtil.getConfiguration();
        final Path testDir = UTIL.getDataTestDir();
        final FileSystem fs = UTIL.getTestFileSystem();
        LOG.debug((Object)("Writing test data to: " + testDir));
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey);
        AlwaysDelete delegate = (AlwaysDelete)((Object)chore.cleanersChain.get(0));
        AlwaysDelete spy = (AlwaysDelete)((Object)Mockito.spy((Object)((Object)delegate)));
        chore.cleanersChain.set(0, spy);
        Path parent = new Path(testDir, "parent");
        Path file = new Path(parent, "someFile");
        fs.mkdirs(parent);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        final Path racyFile = new Path(parent, "addedFile");
        ((AlwaysDelete)((Object)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                fs.create(racyFile).close();
                FSUtils.logFileSystemState((FileSystem)fs, (Path)testDir, (Log)LOG);
                return (Boolean)invocation.callRealMethod();
            }
        }).when((Object)spy))).isFileDeletable((FileStatus)Mockito.any(FileStatus.class));
        if (chore.checkAndDeleteDirectory(parent)) {
            throw new Exception("Reported success deleting directory, should have failed when adding file mid-iteration");
        }
        Assert.assertTrue((String)"Added file unexpectedly deleted", (boolean)fs.exists(racyFile));
        Assert.assertTrue((String)"Parent directory deleted unexpectedly", (boolean)fs.exists(parent));
        Assert.assertFalse((String)"Original file unexpectedly retained", (boolean)fs.exists(file));
        ((AlwaysDelete)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).isFileDeletable((FileStatus)Mockito.any(FileStatus.class));
    }

    @Test
    public void testDeleteFileWithCleanerEnabled() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey);
        chore.setEnabled(true);
        Path parent = new Path(testDir, "parent");
        Path child = new Path(parent, "child");
        Path file = new Path(child, "someFile");
        fs.mkdirs(child);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        chore.chore();
        Assert.assertFalse((String)"File didn't get deleted", (boolean)fs.exists(file));
        Assert.assertFalse((String)"Empty directory didn't get deleted", (boolean)fs.exists(child));
        Assert.assertFalse((String)"Empty directory didn't get deleted", (boolean)fs.exists(parent));
    }

    @Test
    public void testDeleteFileWithCleanerDisabled() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey);
        chore.setEnabled(false);
        Path parent = new Path(testDir, "parent");
        Path child = new Path(parent, "child");
        Path file = new Path(child, "someFile");
        fs.mkdirs(child);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        chore.chore();
        Assert.assertTrue((String)"File got deleted with cleaner disabled", (boolean)fs.exists(file));
        Assert.assertTrue((String)"Directory got deleted", (boolean)fs.exists(child));
        Assert.assertTrue((String)"Directory got deleted", (boolean)fs.exists(parent));
    }

    public static class NeverDelete
    extends BaseHFileCleanerDelegate {
        public boolean isFileDeletable(FileStatus fStat) {
            return false;
        }
    }

    public static class AlwaysDelete
    extends BaseHFileCleanerDelegate {
        public boolean isFileDeletable(FileStatus fStat) {
            return true;
        }
    }

    private static class AllValidPaths
    extends CleanerChore<BaseHFileCleanerDelegate> {
        public AllValidPaths(String name, Stoppable s, Configuration conf, FileSystem fs, Path oldFileDir, String confkey) {
            super(name, Integer.MAX_VALUE, s, conf, fs, oldFileDir, confkey);
        }

        protected boolean validate(Path file) {
            return true;
        }
    }
}

