/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDefaultLoadBalancer
extends BalancerTestBase {
    private static final Log LOG = LogFactory.getLog(TestDefaultLoadBalancer.class);
    private static LoadBalancer loadBalancer;
    int[][] ourClusterStateMocks = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {1, 1}, {0, 1}, {10, 1}, {14, 1432}, {47, 53}, {0, 1, 2}, {1, 2, 3}, {0, 2, 2}, {0, 3, 0}, {0, 4, 0}, {20, 20, 0}, {0, 1, 2, 3}, {4, 0, 0, 0}, {5, 0, 0, 0}, {6, 6, 0, 0}, {6, 2, 0, 0}, {6, 1, 0, 0}, {6, 0, 0, 0}, {4, 4, 4, 7}, {4, 4, 4, 8}, {0, 0, 0, 7}, {1, 1, 1, 1, 4}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {6, 6, 5, 6, 6, 6, 6, 6, 6, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 10}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 123}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 155}, {0, 0, 144, 1, 1, 1, 1, 1123, 133, 138, 12, 1444}, {0, 0, 144, 1, 0, 4, 1, 1123, 133, 138, 12, 1444}, {1538, 1392, 1561, 1557, 1535, 1553, 1385, 1542, 1619}};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        conf.set("hbase.regions.slop", "0");
        loadBalancer = new SimpleLoadBalancer();
        loadBalancer.setConf(conf);
    }

    @Test(timeout=60000L)
    public void testBalanceCluster() throws Exception {
        for (int[] mockCluster : this.ourClusterStateMocks) {
            TreeMap<ServerName, List<HRegionInfo>> servers = this.mockClusterServers(mockCluster);
            List<ServerAndLoad> list = this.convertToList(servers);
            LOG.info((Object)("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list)));
            List plans = loadBalancer.balanceCluster(servers);
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, servers);
            LOG.info((Object)("Mock Balance : " + this.printMock(balancedCluster)));
            this.assertClusterAsBalanced(balancedCluster);
            for (Map.Entry entry : servers.entrySet()) {
                this.returnRegions((List)entry.getValue());
                this.returnServer((ServerName)entry.getKey());
            }
        }
    }
}

