/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsAssignmentManagerSource;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAssignmentManagerMetrics {
    private static final Log LOG = LogFactory.getLog(TestAssignmentManagerMetrics.class);
    private static final MetricsAssertHelper metricsHelper = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static MiniHBaseCluster cluster;
    private static HMaster master;
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration conf;
    private static final int msgInterval = 1000;

    @BeforeClass
    public static void startCluster() throws Exception {
        LOG.info((Object)"Starting cluster");
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.table.sanity.checks", false);
        conf.setInt("hbase.metrics.rit.stuck.warning.threshold", 20);
        conf.setInt("hbase.regionserver.msginterval", 1000);
        conf.set("hbase.balancer.tablesOnMaster", "none");
        TEST_UTIL.startMiniCluster(1);
        cluster = TEST_UTIL.getHBaseCluster();
        master = cluster.getMaster();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRITAssignmentManagerMetrics() throws Exception {
        TableName TABLENAME = TableName.valueOf((String)"testRITMetrics");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        try (HTable table = null;){
            table = TEST_UTIL.createTable(TABLENAME, FAMILY);
            byte[] row = Bytes.toBytes((String)"row");
            byte[] qualifier = Bytes.toBytes((String)"qualifier");
            byte[] value = Bytes.toBytes((String)"value");
            Put put = new Put(row);
            put.addColumn(FAMILY, qualifier, value);
            table.put(put);
            Thread.sleep(3000L);
            MetricsAssignmentManagerSource amSource = master.getAssignmentManager().getAssignmentManagerMetrics().getMetricsProcSource();
            metricsHelper.assertGauge("ritCount", 0L, (BaseSource)amSource);
            metricsHelper.assertGauge("ritCountOverThreshold", 0L, (BaseSource)amSource);
            HTableDescriptor htd = new HTableDescriptor(TABLENAME);
            HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
            htd.addFamily(hcd);
            String spec = "hdfs:///foo.jar|com.foo.FooRegionObserver|1001|arg1=1,arg2=2";
            htd.addCoprocessorWithSpec(spec);
            TEST_UTIL.getHBaseAdmin().modifyTable(TABLENAME, htd);
            Thread.sleep(3000L);
            metricsHelper.assertGauge("ritCount", 1L, (BaseSource)amSource);
            metricsHelper.assertGauge("ritCountOverThreshold", 1L, (BaseSource)amSource);
        }
    }
}

